/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public abstract class AbstractQueryBuilder {
    private static final Log LOG = LogFactory.getLog(AbstractQueryBuilder.class);
    protected static final String BOS_ENTITY_OBJECT = "bos_entityobject";
    protected MainEntityType queryDataEntityType = MetadataUtils.getMainEntityType((String)"cts_querydynsource");
    protected DynamicObject queryDyn = new DynamicObject((DynamicObjectType)this.queryDataEntityType);
    protected QueryGenParam queryGenParam = QueryContext.get().getQueryGenParam();
    protected QueryGenResult queryGenResult = QueryContext.get().getQueryGenResult();
    private Map<String, QueryField> queryFieldMap;
    protected IFormView view = QueryContext.get().getQueryView();

    public void build() {
        LOG.info("query config dynamic object build start");
        this.doBuild();
        this.view.getModel().setValue("group", (Object)this.queryGenParam.getUnit());
        LOG.info("query config dynamic object build end");
    }

    protected abstract void doBuild();

    protected DynamicObjectCollection buildQuerySelectFieldEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryselectfieldsentry");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.queryGenParam.getMainEntity().getNumber());
        this.buildField(mainEntityType, entryType, entryCollection, true);
        for (QueryEntity queryEntity : this.queryGenParam.getSubQueryEntityList()) {
            MainEntityType subEntityType = MetadataServiceHelper.getDataEntityType((String)queryEntity.getNumber());
            this.buildField(subEntityType, entryType, entryCollection, false);
        }
        return entryCollection;
    }

    protected void buildField(MainEntityType mainEntityType, EntityType entryType, DynamicObjectCollection entryCollection, boolean isSelf) {
        Map fieldMap = mainEntityType.getAllFields();
        if (CollectionUtils.isEmpty((Map)fieldMap)) {
            return;
        }
        String mainEntityTypeName = isSelf ? "" : mainEntityType.getName() + ".";
        String mainEntityTypeDisplayName = isSelf ? "" : mainEntityType.getDisplayName().getLocaleValue() + ".";
        for (Map.Entry fieldEntry : fieldMap.entrySet()) {
            IDataEntityProperty prop = (IDataEntityProperty)fieldEntry.getValue();
            if (prop instanceof BasedataProp) {
                this.addBasedataProp(entryType, entryCollection, mainEntityTypeName, prop);
                continue;
            }
            String queryKey = mainEntityTypeName + prop.getName();
            if (!this.getQueryFieldMap().containsKey(queryKey)) continue;
            QueryField queryField = this.getQueryFieldMap().get(queryKey);
            DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
            entry.set("selectfieldalias", (Object)(mainEntityTypeName + prop.getName()));
            entry.set("selectfielddisplayname", (Object)queryField.getFieldName());
            entry.set("selectfieldentityname", (Object)mainEntityTypeDisplayName);
            entryCollection.add((Object)entry);
        }
    }

    private void addBasedataProp(EntityType entryType, DynamicObjectCollection entryCollection, String prefix, IDataEntityProperty prop) {
        BasedataProp basedataProp = (BasedataProp)prop;
        DataEntityPropertyCollection baseDataProps = basedataProp.getComplexType().getProperties();
        if (CollectionUtils.isNotEmpty((Collection)baseDataProps)) {
            for (IDataEntityProperty pp : baseDataProps) {
                if (pp instanceof BasedataProp) {
                    String subPrefix = prefix + prop.getName() + ".";
                    this.addBasedataProp(entryType, entryCollection, subPrefix, pp);
                    continue;
                }
                String ppName = pp.getName();
                if ("id".equals(ppName) || "multilanguagetext".equals(ppName) || StringUtils.isBlank((CharSequence)ppName)) continue;
                String queryKey = prefix + prop.getName() + "." + pp.getName();
                if (!this.getQueryFieldMap().containsKey(queryKey)) continue;
                QueryField queryField = this.getQueryFieldMap().get(queryKey);
                DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
                entry.set("selectfieldalias", (Object)queryKey);
                entry.set("selectfielddisplayname", (Object)queryField.getFieldName());
                entry.set("selectfieldentityname", (Object)queryField.getFieldName());
                entryCollection.add((Object)entry);
            }
        }
    }

    protected void rebuildQuerySelectFieldEntry(DynamicObject queryDyn) {
        queryDyn.set("queryselectfieldsentry", (Object)this.buildQuerySelectFieldEntry());
    }

    public Map<String, QueryField> getQueryFieldMap() {
        if (this.queryFieldMap == null) {
            QueryContext.get().setNeedQueryFieldMap(QueryContext.get().getQueryFieldMap());
            this.queryFieldMap = QueryContext.get().getQueryFieldMap();
        }
        return this.queryFieldMap;
    }
}

