/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.AbstractQueryBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryConfigHelper;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;

public class ExtendModifyQueryConfigBuilder
extends AbstractQueryBuilder {
    private static final Log LOG = LogFactory.getLog(ExtendModifyQueryConfigBuilder.class);
    private Set<String> parentIdSet = Sets.newHashSet();
    private Set<String> parentNumberSet = Sets.newHashSet();
    private Map<String, QueryField> queryFieldMap;
    private String extQueryId;

    @Override
    protected void doBuild() {
        String extQueryNumber = QueryContext.get().getQueryGenResult().getExtQueryNumber();
        LOG.info("modify extend query dynamic object, extNumber = {}", (Object)extQueryNumber);
        IDataModel dataModel = this.view.getModel();
        dataModel.createNewData((Object)this.queryDyn);
        this.extQueryId = MetadataDao.getIdByNumber((String)extQueryNumber, (MetaCategory)MetaCategory.Entity);
        this.queryDyn.set("id", (Object)this.extQueryId);
        QueryContext.get().getQueryGenResult().setExtQueryId(this.extQueryId);
        QueryConfigHelper queryConfigHelper = new QueryConfigHelper(QueryContext.get().getQueryView());
        queryConfigHelper.setDataFromEntityMetaCache(this.extQueryId);
        this.rebuildExtQuerySelectFieldEntry(dataModel.getDataEntity());
    }

    private void rebuildExtQuerySelectFieldEntry(DynamicObject dataEntity) {
        this.initParentFieldSet();
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryselectfieldsentry");
        DynamicObjectCollection newSelectFieldCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        DynamicObjectCollection oriSelectFieldCollection = dataEntity.getDynamicObjectCollection("queryselectfieldsentry");
        for (DynamicObject dynamicObject : oriSelectFieldCollection) {
            if (!this.parentIdSet.contains(dynamicObject.get("queryselectfieldsentryid"))) continue;
            newSelectFieldCollection.add((Object)dynamicObject);
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.queryGenParam.getMainEntity().getNumber());
        this.buildField(mainEntityType, entryType, newSelectFieldCollection, true);
        for (kd.hdtc.hrdbs.common.pojo.query.QueryEntity queryEntity : this.queryGenParam.getSubQueryEntityList()) {
            MainEntityType subEntityType = MetadataServiceHelper.getDataEntityType((String)queryEntity.getNumber());
            this.buildField(subEntityType, entryType, newSelectFieldCollection, false);
        }
        this.queryDyn.set("queryselectfieldsentry", (Object)newSelectFieldCollection);
    }

    @Override
    public Map<String, QueryField> getQueryFieldMap() {
        if (this.queryFieldMap == null) {
            this.queryFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            for (Map.Entry<String, QueryField> mapEntry : super.getQueryFieldMap().entrySet()) {
                if (this.parentNumberSet.contains(mapEntry.getKey())) continue;
                this.queryFieldMap.put(mapEntry.getKey(), mapEntry.getValue());
            }
            QueryContext.get().setNeedQueryFieldMap(this.queryFieldMap);
            LOG.info("extent queryFieldMap = {}", this.queryFieldMap);
        }
        return this.queryFieldMap;
    }

    public void initParentFieldSet() {
        List<EntityMetadata> inheritMetaList = this.getInheritMetaList(this.extQueryId);
        for (EntityMetadata entityMetadata : inheritMetaList) {
            QueryEntity queryEntity = (QueryEntity)entityMetadata.getRootEntity();
            List selectFieldList = queryEntity.getSelectFields();
            for (QuerySelectField querySelectField : selectFieldList) {
                this.parentIdSet.add(querySelectField.getId());
                this.parentNumberSet.add(querySelectField.getAlias());
            }
        }
        LOG.info("parentNumberSet = {}", this.parentNumberSet);
    }

    private List<EntityMetadata> getInheritMetaList(String queryEntityId) {
        String[] inheritIdArray = this.getInheritIdArray(queryEntityId);
        ArrayList<EntityMetadata> inheritMetaList = new ArrayList<EntityMetadata>(10);
        for (int j = 0; j < inheritIdArray.length; ++j) {
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)inheritIdArray[j], (MetaCategory)MetaCategory.Entity);
            inheritMetaList.add(metadata);
        }
        return inheritMetaList;
    }

    private String[] getInheritIdArray(String queryEntityId) {
        String sql = "select finheritpath from t_meta_formdesign where FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)queryEntityId)};
        ResultSetHandler callBackHanlder = rs -> {
            String[] inheritIdArray = null;
            try {
                if (rs.next()) {
                    String inheritPathStr = rs.getString(1);
                    inheritIdArray = inheritPathStr.split(",");
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", e.getMessage())});
            }
            return inheritIdArray;
        };
        return (String[])DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }
}

