/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.ExtendModifyQueryConfigBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;

public class ExtendNewQueryConfigBuilder
extends ExtendModifyQueryConfigBuilder {
    private static final Log LOG = LogFactory.getLog(ExtendNewQueryConfigBuilder.class);
    private static final IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);

    @Override
    protected void doBuild() {
        LOG.info("extend query dynamic object");
        String extQueryNumber = this.createExtendQuery();
        LOG.info("extend a new query dynamic object, extNumber = {}", (Object)extQueryNumber);
        QueryContext.get().getQueryGenResult().setExtQueryNumber(extQueryNumber);
        super.doBuild();
    }

    private String createExtendQuery() {
        String extNumberAuto = AppUtils.autoExtendedNumber((String)this.queryGenParam.getNumber());
        String extNumber = DevportalUtil.autoFormNumber((String)extNumberAuto, (String)"_ext");
        Map<String, Object> paramMap = this.createExtGenMap(extNumber);
        Map<String, Object> originMetadataNodeMap = metadataEntityService.createDesignMetadata(paramMap);
        Map<String, Object> resultMap = metadataEntityService.save(originMetadataNodeMap);
        boolean success = (Boolean)resultMap.getOrDefault("success", Boolean.FALSE);
        if (!success) {
            throw new HRDBSBizException("generate extend metadata error");
        }
        metadataEntityService.saveAppUnit((String)originMetadataNodeMap.get("id"), this.queryGenParam.getUnit(), (String)paramMap.get("bizappid"));
        EntityMetadataCache.removeDataEntityTypeLocalCache((String)this.queryGenParam.getNumber());
        return extNumber;
    }

    private Map<String, Object> createExtGenMap(String extNumber) {
        HashMap genMap = Maps.newHashMap();
        genMap.put("devType", "2");
        genMap.put("bizappid", this.queryGenResult.getRealAppId());
        genMap.put("name", this.queryGenParam.getName());
        genMap.put("modelType", "QueryListModel");
        genMap.put("bizunitid", this.queryGenParam.getUnit());
        genMap.put("parentId", MetadataDao.getIdByNumber((String)this.queryGenParam.getNumber(), (MetaCategory)MetaCategory.Entity));
        genMap.put("id", extNumber);
        return genMap;
    }
}

