/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.AbstractQueryBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.RelationCondition;

public class NewQueryConfigDynamicObjectBuilder
extends AbstractQueryBuilder {
    private static final Log LOG = LogFactory.getLog(NewQueryConfigDynamicObjectBuilder.class);

    @Override
    public void doBuild() {
        LOG.info("build a new query dynamic object");
        this.buildNewDynamicObject();
        QueryContext.get().getQueryView().getModel().createNewData((Object)this.queryDyn);
        Map<String, List<Map<String, Object>>> relationConditionCache = this.buildQueryRelationConditionCache();
        this.view.getPageCache().put("QueryDynSourcePlugInCache", SerializationUtils.toJsonString(relationConditionCache));
        this.view.getPageCache().put("operations_control_val", SerializationUtils.toJsonString((Object)this.queryGenParam.getEntityOperationList()));
        this.view.getPageCache().put("permission_control_val", SerializationUtils.toJsonString((Object)this.queryGenParam.getPermissionItemsList()));
    }

    private Map<String, List<Map<String, Object>>> buildQueryRelationConditionCache() {
        HashMap queryDataMap = Maps.newHashMapWithExpectedSize((int)16);
        for (QueryEntity queryEntity : this.queryGenParam.getSubQueryEntityList()) {
            ArrayList conList = Lists.newArrayListWithExpectedSize((int)queryEntity.getRelationConditionList().size());
            for (RelationCondition relationCondition : queryEntity.getRelationConditionList()) {
                HashMap<String, String> conditionMap = new HashMap<String, String>(16);
                conditionMap.put("id", null);
                conditionMap.put("parentField", relationCondition.getMainEntityProp());
                conditionMap.put("conditionField", relationCondition.getCondition());
                conditionMap.put("childField", relationCondition.getSubEntityProp());
                conList.add(conditionMap);
            }
            queryDataMap.put(this.queryGenParam.getMainEntity().getNumber() + ":" + queryEntity.getNumber(), conList);
        }
        return queryDataMap;
    }

    private void buildNewDynamicObject() {
        this.queryDyn.set("dstype", (Object)"QueryList");
        this.queryDyn.set("currentappid", (Object)this.queryGenResult.getRealAppId());
        this.queryDyn.set("group", (Object)this.queryGenParam.getUnit());
        this.queryDyn.set("enableimport", (Object)Boolean.FALSE);
        this.queryDyn.set("number", (Object)this.queryGenParam.getNumber());
        this.queryDyn.set("editentityaliasname", (Object)this.queryGenParam.getMainEntity().getNumber());
        this.queryDyn.set("name", (Object)this.queryGenParam.getName());
        this.queryDyn.set("mainentityname", (Object)this.getMainEntity(this.queryGenParam.getMainEntity().getNumber()));
        this.queryDyn.set("mainentityalias", (Object)this.queryGenParam.getMainEntity().getNumber());
        this.queryDyn.set("queryentityentry", (Object)this.buildQueryEntityEntry());
        this.queryDyn.set("queryrelationenrtry", (Object)this.buildQueryRelationEntry());
        this.queryDyn.set("queryrelaconditionentry", (Object)this.buildQueryRelationConditionEntry());
        this.queryDyn.set("queryselectfieldsentry", (Object)this.buildQuerySelectFieldEntry());
    }

    private DynamicObjectCollection buildQueryEntityEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryentityentry");
        DynamicObjectCollection queryEntityEntryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        for (QueryEntity queryEntity : this.queryGenParam.getSubQueryEntityList()) {
            DynamicObject queryEntityEntry = new DynamicObject((DynamicObjectType)entryType);
            queryEntityEntry.set("entityalias", (Object)queryEntity.getNumber());
            queryEntityEntry.set("entitynumber", (Object)queryEntity.getNumber());
            queryEntityEntry.set("entityname", (Object)queryEntity.getName());
            queryEntityEntryCollection.add((Object)queryEntityEntry);
        }
        return queryEntityEntryCollection;
    }

    private DynamicObjectCollection buildQueryRelationEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryrelationenrtry");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        for (QueryEntity queryEntity : this.queryGenParam.getSubQueryEntityList()) {
            DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
            entry.set("parententityalias", (Object)this.queryGenParam.getMainEntity().getNumber());
            entry.set("childentityalias", (Object)queryEntity.getNumber());
            entry.set("childentitynumber", (Object)queryEntity.getNumber());
            entry.set("combinationtype", (Object)"LeftJoin");
            entryCollection.add((Object)entry);
        }
        return entryCollection;
    }

    private DynamicObjectCollection buildQueryRelationConditionEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryrelaconditionentry");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        for (QueryEntity queryEntity : this.queryGenParam.getSubQueryEntityList()) {
            for (RelationCondition relationCondition : queryEntity.getRelationConditionList()) {
                DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
                entry.set("relaparententityprop", (Object)relationCondition.getMainEntityProp());
                entry.set("relaparentdisplayname", (Object)relationCondition.getMainEntityPropName());
                entry.set("relachildentityprop", (Object)relationCondition.getSubEntityProp());
                entry.set("relachilddisplayname", (Object)relationCondition.getSubEntityPropName());
                entry.set("relaconditiontype", (Object)relationCondition.getCondition());
                entryCollection.add((Object)entry);
            }
        }
        return entryCollection;
    }

    private DynamicObject getMainEntity(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject sourceData = CommonEntityServiceFactory.getEntityService("bos_entityobject").queryOne(String.join((CharSequence)",", "id", "name", "number"), filter.toArray());
        return sourceData;
    }
}

