/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.designer.query.QueryDynSourcePlugIn;
import kd.bos.designer.query.QueryMetadataHelper;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.AbstractQueryBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.ExtendModifyQueryConfigBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.ExtendNewQueryConfigBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.ModifyQueryConfigDynamicObjectBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.NewQueryConfigDynamicObjectBuilder;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryJudge;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class QueryConfigGenerator {
    private static final Log LOG = LogFactory.getLog(QueryConfigGenerator.class);
    private static final IDynamicMetadataApplicationService iDynamicMetadataApplicationService = ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private static final Map<String, Supplier<AbstractQueryBuilder>> QUERY_BUILDER_SUPPLIER_MAP = ImmutableMap.of((Object)"new", () -> new NewQueryConfigDynamicObjectBuilder(), (Object)"modify", () -> new ModifyQueryConfigDynamicObjectBuilder(), (Object)"extend_new", () -> new ExtendNewQueryConfigBuilder(), (Object)"extend_modify", () -> new ExtendModifyQueryConfigBuilder());
    private QueryGenParam queryGenParam = QueryContext.get().getQueryGenParam();
    private QueryGenResult queryGenResult = QueryContext.get().getQueryGenResult();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        LOG.info("query config generate start...");
        QueryJudge queryJudge = new QueryJudge(this.queryGenParam.getNumber());
        String sceneType = queryJudge.judge();
        this.queryGenResult.setExtQueryNumber(queryJudge.getExtNumber());
        this.queryGenResult.setQueryId(queryJudge.getId());
        this.initRealAppId();
        FormShowParameter parameter = this.buildTplInfo();
        IFormView view = null;
        try {
            view = parameter.createView();
            view.addService(IPageCache.class, (Object)new PageCache(""));
            parameter.setFormConfig(FormMetadataCache.getFormConfig((String)parameter.getFormId()));
            view.initialize(parameter);
            QueryContext.get().bind(view);
            LOG.info("sceneType = {}, extNumber", (Object)sceneType, (Object)this.queryGenResult.getExtQueryNumber());
            QUERY_BUILDER_SUPPLIER_MAP.get(sceneType).get().build();
            QueryMetadataHelper queryMetadataHelper = new QueryMetadataHelper();
            QueryDynSourcePlugIn plugin = new QueryDynSourcePlugIn();
            plugin.setView(view);
            String queryId = queryMetadataHelper.saveQueryMetadata(plugin, view.getModel());
            this.queryGenResult.setQueryId(queryId);
        }
        finally {
            if (view != null) {
                view.close();
            }
            LOG.info("query config generate end");
        }
    }

    private void initRealAppId() {
        this.queryGenResult.setAppId(this.queryGenParam.getAppId());
        if (!IsvUtils.isKingdeeISV()) {
            String mainEntityAppNumber = this.getMainEntityAppNumber();
            String extAppNumber = iDynamicMetadataApplicationService.getOrCreateExtIsvAppId(mainEntityAppNumber);
            this.queryGenResult.setExtAppId(AppMetadataCache.getAppInfo((String)extAppNumber).getId());
            this.queryGenResult.setExtAppNumber(extAppNumber);
        }
    }

    private FormShowParameter buildTplInfo() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_querydynsource");
        parameter.setAppId("cts");
        parameter.setCustomParam("currentBizAppId", (Object)this.queryGenResult.getRealAppId());
        parameter.setCustomParam("currentUnitId", (Object)this.queryGenParam.getUnit());
        parameter.setCustomParam("queryEntityId", (Object)this.queryGenResult.getQueryId());
        return parameter;
    }

    private String getMainEntityAppNumber() {
        String number = this.queryGenParam.getMainEntity().getNumber();
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)number);
        return mainEntityType.getAppId();
    }
}

