/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.query.QueryEntityParseHelper;
import kd.bos.designer.query.QueryEntityTreeNode;
import kd.bos.designer.query.QueryMetadataHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QueryPlugInField;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySortField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.entity.mulentities.expr.QSPropExpr;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.perm.PermissionControl;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.metadata.perm.PermissionItem;
import kd.bos.util.StringUtils;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;

public class QueryConfigHelper {
    private static final Log LOG = LogFactory.getLog(QueryConfigHelper.class);
    private IDataModel dataModel;
    private IFormView formView;
    private IPageCache pageCache;
    public static final String IDE_OPERATIONSELECT = "ide_operationselect";
    public static final String OPERATIONS_CONTROL_VAL = "operations_control_val";
    public static final String PERMISSION_CONTROL_VAL = "permission_control_val";
    public static final String PERMISSION_FIELD_VAL = "permission_field_val";
    public static final String SELECTFIELDENTITYNUMBER = "selectfieldentitynumber";
    private static final String IDE_PERMITEMSEDIT = "ide_permitemsedit";
    private static final String BOS_DEVP_EXTAPPEXTPAGE = "bos_devp_extappextpage";
    public static final String QUERY_DYN_SOURCE_PLUG_IN_CACHE = "QueryDynSourcePlugInCache";
    public static final String QUERY_QUERYPLUGIN_ENTRY = "querypluginentry";
    public static final String QUERY_ENTITY_ENTRY = "queryentityentry";
    public static final String QUERY_RELATION_ENTRY = "queryrelationenrtry";
    public static final String QUERY_RELATION_CONDITION_ENTRY = "queryrelaconditionentry";
    public static final String QUERY_CONDITION_ENTRY = "queryconditionentry";
    public static final String QUERY_SELECT_FIELDS_ENTRY = "queryselectfieldsentry";
    public static final String SELECT_FIELD_ALIAS = "selectfieldalias";
    public static final String QUERY_SORT_FIELDS_ENTRY = "querysortfieldentry";
    public static final String PARENT_ENTITY_NUMBER = "parententitynumber";
    public static final String PARENT_ENTITY_ALIAS = "parententityalias";
    public static final String CHILD_ENTITY_NUMBER = "childentitynumber";
    public static final String CHILD_ENTITY_ALIAS = "childentityalias";
    public static final String CONDITION_FIELD = "conditionfield";
    public static final String CONDITION_VALUE = "conditionvalue";
    public static final String MAIN_ENTITY_NAME = "mainentityname";
    public static final String MAIN_ENTITY_ALIAS = "mainentityalias";
    public static final String RELATION_CHILD_ENTITY_PROP = "relachildentityprop";
    public static final String RELATION_CHILD_ENTITY_PROPDISNAME = "relachilddisplayname";
    public static final String RELATION_CONDITION_TYPE = "relaconditiontype";
    public static final String RELATION_PARENT_ENTITY_PROP = "relaparententityprop";
    public static final String RELATION_PARENT_ENTITY_PROPDISNAME = "relaparentdisplayname";
    public static final String PAGE_QUERY_FIELD_MODIFY_VAL_F7 = "cts_queryfieldmodifyvalf7";
    public static final String COLUMN_ENTITY_NUMBER = "entitynumber";
    public static final String COLUMN_ENTITY_ALIAS = "entityalias";
    public static final String SPLIT_STRING_FLAG = ":";
    public static final String QUERYSOURCE_JOIN_RELATION_ID = "querysourcejoinrelationid";
    public static final String QS_CONDITION_ROW_ID = "qsconditionrowid";
    private static final String COPY_EXIST_DATASOURCE = "copyexistdatasource";
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_PERMSET = "barpermset";
    private static final String BAR_OPERATIONS_SET = "baroperationsset";
    private static final String QUERY_ENTITY_ID = "queryEntityId";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String BAR_EXTEND = "barextend";
    private static final String PARENT_ID = "parentid";
    private static final String GROUP = "group";
    private static final String CURRENT_UNIT_ID = "currentUnitId";
    private static final String CURRENT_BIZ_APP_ID = "currentBizAppId";
    private static final String QUERY_ENTITY_NUMBER = "queryEntityNumber";
    private static final String NUMBER = "number";
    private static final String VALUE = "value";
    private static final String BTN_IMPORT_ENTITY = "btnimportentity";
    private static final String BTN_SORT_FIELD_IMPORT = "btnsortfieldimport";
    private static final String BTN_QUERY_FIELD_IMPORT = "btnqueryfieldimport";
    private static final String EDIT_ENTITY_ALIAS_NAME = "editentityaliasname";
    private static final String ROW_INDEX = "rowindex";
    private static final String ENTITY_NAME = "entityname";
    private static final String COMBINATION_TYPE = "combinationtype";
    private static final String QUERY_DYN_SOURCE_PLUG_IN_9 = "QueryDynSourcePlugIn_9";
    private static final String PARENT_FIELD = "parentField";
    private static final String ENABLE_IMPORT = "enableimport";
    private static final String INHERIT_PATH = "inheritpath";
    private static final String DEV_TYPE = "devtype";
    private static final String MASTER_ID = "masterid";
    private static final String TYPE = "_Type_";
    private static final String SELECT_FIELD_ENTITY_NAME = "selectfieldentityname";
    private static final String QUERY_SELECT_FIELDS_ENTRY_ID = "queryselectfieldsentryid";
    private static final String SELECT_FIELD_DISPLAY_NAME = "selectfielddisplayname";
    private HashMap<String, List<QueryCondition>> queryDataMap = new HashMap();

    public QueryConfigHelper(IFormView formView) {
        this.dataModel = formView.getModel();
        this.formView = formView;
        this.pageCache = formView.getPageCache();
    }

    public void setDataFromEntityMetaCache(String id) {
        try {
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
            this.getModel().setValue(INHERIT_PATH, (Object)metadata.getInheritPath());
            this.getModel().setValue(PARENT_ID, (Object)metadata.getParentId());
            this.getModel().setValue(DEV_TYPE, (Object)metadata.getDevType());
            this.getModel().setValue(MASTER_ID, (Object)metadata.getMasterId());
            if (metadata.getItems().size() > 1) {
                throw new HRDBSBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u9519\u8bef\uff0c\u9700\u8981\u91cd\u65b0\u4fdd\u5b58!", (String)"QueryDynSourcePlugIn_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            QueryEntity queryEntity = (QueryEntity)metadata.getRootEntity();
            this.setMainEntity(queryEntity);
            this.convertQuerySourceJoinEntity(queryEntity);
            this.setJoinEntity(queryEntity);
            this.setJoinRelation(queryEntity);
            this.setWhereConditions(queryEntity);
            this.setQuerySelectFields(queryEntity);
            this.setQuerySortFields(queryEntity);
            this.setQueryPlugInFields(queryEntity);
            this.setPermissionInfo(queryEntity);
            this.getModel().setValue(ENABLE_IMPORT, (Object)queryEntity.getBusinessControl().isEnableImport());
            String modelType = "DynamicFormModel";
            QueryMetadataHelper.assembleOperationLang((String)id, (String)queryEntity.getEntityName(), (QueryEntity)queryEntity);
            MetadataSerializer template = new MetadataSerializer(modelType);
            Map serializeToMap = template.serializeToMap((Object)queryEntity);
            this.getPageCache().put(OPERATIONS_CONTROL_VAL, SerializationUtils.toJsonString(serializeToMap.get("Operations")));
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.metaNotFound)) {
                throw new HRDBSBizException(e.getMessage());
            }
            throw e;
        }
    }

    private void setPermissionInfo(QueryEntity queryEntity) {
        this.setPermissionControl(queryEntity);
        this.setPermissionDimension(queryEntity);
        this.setPermissionItems(queryEntity);
        this.setQueryEntityPropForPermission(queryEntity);
    }

    private void setQueryEntityPropForPermission(QueryEntity queryEntity) {
        String entityId = queryEntity.getId();
        IPageCache pageCache = this.getPageCache();
        if ("2".equals(this.getModel().getValue(DEV_TYPE))) {
            entityId = this.getModel().getValue(PARENT_ID).toString();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        List querySelectFieldList = queryEntity.getSelectFields();
        ArrayList queryFieldList = new ArrayList();
        for (QuerySelectField querySelectField : querySelectFieldList) {
            IDataEntityProperty selectFieldProp = QueryEntityParseHelper.getFieldProperty((QuerySelectField)querySelectField, (DataEntityPropertyCollection)properties, (QueryEntity)queryEntity);
            if (selectFieldProp == null) continue;
            HashMap<String, String> fieldInfoMap = new HashMap<String, String>();
            fieldInfoMap.put(TYPE, this.getMappingFieldName(selectFieldProp.getClass().getName()));
            fieldInfoMap.put("Name", querySelectField.getDisplayName());
            fieldInfoMap.put("Key", querySelectField.getAlias());
            fieldInfoMap.put("Id", querySelectField.getId());
            queryFieldList.add(fieldInfoMap);
        }
        pageCache.put(PERMISSION_FIELD_VAL, SerializationUtils.toJsonString(queryFieldList));
    }

    private String getMappingFieldName(String propClassName) {
        String fieldTypeName = "";
        if (propClassName.endsWith("Prop")) {
            String propName = propClassName.substring(propClassName.lastIndexOf(".") + 1);
            fieldTypeName = propName.substring(0, propName.indexOf("Prop")) + "Field";
        }
        return fieldTypeName;
    }

    private void setPermissionItems(QueryEntity queryEntity) {
        IPageCache pageCache = this.getPageCache();
        ArrayList permItemList = new ArrayList();
        List permissionItems = queryEntity.getPermissionItems();
        if (permissionItems != null) {
            for (PermissionItem permItem : permissionItems) {
                HashMap<String, String> permItemMap = new HashMap<String, String>();
                permItemMap.put("Id", permItem.getId());
                permItemMap.put("ItemId", permItem.getItemId());
                permItemMap.put("Index", permItem.getIndex());
                permItemList.add(permItemMap);
            }
        }
        pageCache.put(PERMISSION_CONTROL_VAL, SerializationUtils.toJsonString(permItemList));
    }

    private void setPermissionDimension(QueryEntity queryEntity) {
        IPageCache pageCache = this.getPageCache();
        PermissionDimension permissionDimension = queryEntity.getPermissionDimension();
        if (permissionDimension != null) {
            HashMap<String, String> permDimensionMap = new HashMap<String, String>();
            permDimensionMap.put(TYPE, "PermissionDimension");
            permDimensionMap.put("Key", "PermissionDimension");
            permDimensionMap.put("DimensionControl", permissionDimension.getDimension());
            permDimensionMap.put("DataDimensionField", permissionDimension.getDataDimensionField());
            permDimensionMap.put("DataDimension", permissionDimension.getDataDimension());
            permDimensionMap.put("DataAssistDimensionField", permissionDimension.getDataAssistDimensionField());
            permDimensionMap.put("DataAssistDimension", permissionDimension.getDataAssistDimension());
            permDimensionMap.put("PublishApps", permissionDimension.getPublishApps());
            HashMap<String, HashMap<String, String>> permDimensionValMap = new HashMap<String, HashMap<String, String>>();
            permDimensionValMap.put(VALUE, permDimensionMap);
            pageCache.put("PermissionDimension", SerializationUtils.toJsonString(permDimensionValMap));
        }
    }

    private void setPermissionControl(QueryEntity queryEntity) {
        IPageCache pageCache = this.getPageCache();
        PermissionControl permissionControl = queryEntity.getPermissionControl();
        if (permissionControl != null) {
            HashMap<String, String> permControlMap = new HashMap<String, String>();
            permControlMap.put(TYPE, "PermissionControl");
            permControlMap.put("Key", "PermissionControl");
            permControlMap.put("ControlFunction", String.valueOf(permissionControl.isControlFunction()));
            permControlMap.put("ForbidDataPerm", String.valueOf(permissionControl.isForbidDataPerm()));
            permControlMap.put("AnonymousUserControl", String.valueOf(permissionControl.isAnonymousUserControl()));
            HashMap<String, HashMap<String, String>> permControlValMap = new HashMap<String, HashMap<String, String>>();
            permControlValMap.put(VALUE, permControlMap);
            pageCache.put("PermissionControl", SerializationUtils.toJsonString(permControlValMap));
        }
    }

    private void setQueryPlugInFields(QueryEntity queryEntity) {
        List queryPlugInFields = queryEntity.getQueryPlugInFields();
        if (queryPlugInFields.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("pluginname", new Object[0]);
            vs.addField("pluginstatus", new Object[0]);
            int size = queryPlugInFields.size();
            for (int i = 0; i < size; ++i) {
                QueryPlugInField queryPlugInField = (QueryPlugInField)queryPlugInFields.get(i);
                vs.addRow(new Object[]{queryPlugInField.getPluginName(), queryPlugInField.getPluginStatus()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_QUERYPLUGIN_ENTRY, vs);
        }
    }

    private void setQuerySortFields(QueryEntity queryEntity) {
        List selectFields = queryEntity.getQuerySortFields();
        if (selectFields.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("sortfieldalias", new Object[0]);
            vs.addField("sortfieldname", new Object[0]);
            vs.addField("sorttype", new Object[0]);
            int size = selectFields.size();
            for (int i = 0; i < size; ++i) {
                QuerySortField sortField = (QuerySortField)selectFields.get(i);
                vs.addRow(new Object[]{sortField.getAlias(), sortField.getDisplayName(), sortField.getSortType()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_SORT_FIELDS_ENTRY, vs);
        }
    }

    private String getEntityNameByAlias(String entityAlias) {
        DynamicObject mainEntity;
        String mainEntityAlias;
        String entityName = null;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityName = dynObj.getString(ENTITY_NAME);
                break;
            }
        }
        if (entityName == null && entityAlias.equals(mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS)) && (mainEntity = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME)) != null) {
            entityName = mainEntity.getString("name");
        }
        return entityName;
    }

    private String getEntityAliasByFieldName(String fieldName) {
        String[] fieldNames = fieldName.split("\\.");
        String entityAlias = null;
        DynamicObject dynObj = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME);
        String mainEntityAlias = dynObj == null ? "" : dynObj.getString(NUMBER);
        entityAlias = fieldNames.length > 1 ? fieldNames[0] : mainEntityAlias;
        if (this.getEntityNameByAlias(entityAlias) == null) {
            entityAlias = mainEntityAlias;
        }
        return entityAlias;
    }

    private void setQuerySelectFields(QueryEntity queryEntity) {
        List selectFields = queryEntity.getSelectFields();
        if (selectFields.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(SELECT_FIELD_ENTITY_NAME, new Object[0]);
            vs.addField(SELECTFIELDENTITYNUMBER, new Object[0]);
            vs.addField(QUERY_SELECT_FIELDS_ENTRY_ID, new Object[0]);
            vs.addField(SELECT_FIELD_ALIAS, new Object[0]);
            vs.addField(SELECT_FIELD_DISPLAY_NAME, new Object[0]);
            int size = selectFields.size();
            for (int i = 0; i < size; ++i) {
                QuerySelectField selectField = (QuerySelectField)selectFields.get(i);
                String entityAlias = this.getEntityAliasByFieldName(selectField.getAlias());
                vs.addRow(new Object[]{this.getEntityNameByAlias(entityAlias), entityAlias, selectField.getId(), selectField.getAlias(), selectField.getLocaleDisplayName()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_SELECT_FIELDS_ENTRY, vs);
        }
    }

    private void setMainEntity(QueryEntity queryEntity) {
        LocaleString queryEntityName = queryEntity.getName();
        String entityName = queryEntity.getEntityName();
        String entityAlias = queryEntity.getEntityAlias();
        this.getModel().setValue("name", (Object)queryEntityName);
        this.getModel().setValue(NUMBER, (Object)queryEntity.getKey());
        this.getModel().setValue(MAIN_ENTITY_NAME, (Object)entityName);
        this.getModel().setValue(MAIN_ENTITY_ALIAS, (Object)entityAlias);
        this.getModel().setValue(EDIT_ENTITY_ALIAS_NAME, (Object)queryEntity.getEditEntityAliasName());
    }

    private void setJoinEntity(QueryEntity queryEntity) {
        List joinEntities = queryEntity.getJoinEntitys();
        String entityName = queryEntity.getEntityName();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(ENTITY_NAME, new Object[0]);
        vs.addField(COLUMN_ENTITY_NUMBER, new Object[0]);
        vs.addField(COLUMN_ENTITY_ALIAS, new Object[0]);
        TableValueSetter vsRel = new TableValueSetter(new String[0]);
        vsRel.addField(QUERYSOURCE_JOIN_RELATION_ID, new Object[0]);
        vsRel.addField(PARENT_ENTITY_ALIAS, new Object[0]);
        vsRel.addField(CHILD_ENTITY_ALIAS, new Object[0]);
        vsRel.addField(COMBINATION_TYPE, new Object[0]);
        for (Object joinEntity : joinEntities) {
            String joinAlias = joinEntity.getAlias();
            String joinEntityName = joinEntity.getEntityName();
            String joinName = joinEntity.getDisplayName();
            vs.addRow(new Object[]{joinName, joinEntityName, joinAlias});
        }
        List querySourceJoinRelaList = queryEntity.getJoinRelations();
        for (QuerySourceJoinRelation querySourceJoinRela : querySourceJoinRelaList) {
            vsRel.addRow(new Object[]{querySourceJoinRela.getId(), querySourceJoinRela.getEntityNumber(), querySourceJoinRela.getRelEntityNumber(), querySourceJoinRela.getJoinType()});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(QUERY_ENTITY_ENTRY, vs);
        model.batchCreateNewEntryRow(QUERY_RELATION_ENTRY, vsRel);
    }

    private void setJoinRelation(QueryEntity queryEntity) {
        List querySourceJoinRelations = queryEntity.getJoinRelations();
        for (QuerySourceJoinRelation rel : querySourceJoinRelations) {
            String entityNumber = rel.getEntityNumber();
            String relEntityNumber = rel.getRelEntityNumber();
            List qsConditionRows = rel.getCondition();
            ArrayList<QueryCondition> conditionList = new ArrayList<QueryCondition>(10);
            for (QSConditionRow row : qsConditionRows) {
                QSPropExpr qsl;
                String leftItem = "";
                if (row.getLeftItem() instanceof QSPropExpr) {
                    qsl = (QSPropExpr)row.getLeftItem();
                    leftItem = qsl.getPropName();
                } else {
                    qsl = (QSIdentifierExpr)row.getLeftItem();
                    leftItem = qsl.getExpr();
                }
                QSIdentifierExpr qsr = (QSIdentifierExpr)row.getRightItem();
                String rightItem = qsr.getExpr();
                String compareOp = row.getCompareOp();
                QueryCondition condition = new QueryCondition(row.getId(), leftItem, compareOp, rightItem);
                conditionList.add(condition);
            }
            if (conditionList.size() == 0) continue;
            this.putRelInCacheData(entityNumber, relEntityNumber, conditionList);
        }
    }

    private void putRelInCacheData(String entityNumber, String relEntityNumber, List<QueryCondition> conditionList) {
        String pageCacheData = this.getPageCache().get(QUERY_DYN_SOURCE_PLUG_IN_CACHE);
        if (pageCacheData != null) {
            LinkedHashMap queryDataMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)pageCacheData, Map.class);
            List oldConditionList = (List)queryDataMap.get(entityNumber + SPLIT_STRING_FLAG + relEntityNumber);
            if (oldConditionList != null) {
                oldConditionList.addAll(conditionList);
                queryDataMap.put(entityNumber + SPLIT_STRING_FLAG + relEntityNumber, oldConditionList);
            } else {
                queryDataMap.put(entityNumber + SPLIT_STRING_FLAG + relEntityNumber, conditionList);
            }
            queryDataMap.put(entityNumber + SPLIT_STRING_FLAG + relEntityNumber, conditionList);
            this.getPageCache().put(QUERY_DYN_SOURCE_PLUG_IN_CACHE, SerializationUtils.toJsonString((Object)queryDataMap));
        } else {
            this.queryDataMap.put(entityNumber + SPLIT_STRING_FLAG + relEntityNumber, conditionList);
            this.getPageCache().put(QUERY_DYN_SOURCE_PLUG_IN_CACHE, SerializationUtils.toJsonString(this.queryDataMap));
        }
    }

    private String getEntityNumberByAlias(String entityAlias) {
        DynamicObject mainEntity;
        String mainEntityAlias;
        String entityNumber = null;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityNumber = dynObj.getString(COLUMN_ENTITY_NUMBER);
                break;
            }
        }
        if (entityNumber == null && entityAlias != null && (mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS)) != null && entityAlias.equals(mainEntityAlias) && (mainEntity = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME)) != null) {
            entityNumber = mainEntity.getString(NUMBER);
        }
        return entityNumber;
    }

    private void addChildQueryEntityToParentQuery(DynamicObject dynObj, QueryEntityTreeNode parentNode) {
        QueryEntityTreeNode childNode = new QueryEntityTreeNode();
        childNode.setEntityAlias(dynObj.getString(CHILD_ENTITY_ALIAS));
        childNode.setEntityNumber(this.getEntityNumberByAlias(dynObj.getString(CHILD_ENTITY_ALIAS)));
        childNode.setParent(parentNode);
        if (parentNode.getChildList() == null) {
            ArrayList childList = new ArrayList();
            parentNode.setChildList(childList);
        }
        parentNode.getChildList().add(childNode);
    }

    private void convertQuerySourceJoinEntity(QueryEntity queryEntity) {
        if (queryEntity.getJoinRelations().isEmpty()) {
            List joinEntityList = queryEntity.getJoinEntitys();
            for (JoinEntity joinEntity : joinEntityList) {
                QuerySourceJoinRelation rel = new QuerySourceJoinRelation();
                rel.setRelEntityNumber(joinEntity.getAlias());
                rel.setEntityNumber(queryEntity.getEntityName());
                rel.setJoinType("LeftJoin");
                QSConditionRow row = new QSConditionRow();
                row.setLeftItem((QSExpr)new QSPropExpr(queryEntity.getEntityName(), joinEntity.getFKProperty()));
                row.setCompareOp("=");
                row.setRightItem((QSExpr)new QSIdentifierExpr(joinEntity.getAlias() + "." + joinEntity.getProperty()));
                rel.addCondition(row);
                queryEntity.addQuerySourceJoinRelation(rel);
            }
        }
    }

    private void setWhereConditions(QueryEntity queryEntity) {
        List whereConditions = queryEntity.getWhereConditions();
        if (whereConditions.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(CONDITION_FIELD, new Object[0]);
            vs.addField("conditiontype", new Object[0]);
            vs.addField(CONDITION_VALUE, new Object[0]);
            vs.addField("conditionlogiccondition", new Object[0]);
            int size = whereConditions.size();
            for (int i = 0; i < size; ++i) {
                QSConditionRow conditionRow = (QSConditionRow)whereConditions.get(i);
                vs.addRow(new Object[]{conditionRow.getLeftItem(), conditionRow.getCompareOp(), conditionRow.getRightItem(), conditionRow.getRightParenthesis()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_CONDITION_ENTRY, vs);
        }
    }

    public IDataModel getModel() {
        return this.dataModel;
    }

    public IFormView getView() {
        return this.formView;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    class QueryCondition
    implements Serializable {
        private static final long serialVersionUID = -4598536842661975247L;
        private String id = null;
        private String parentField = null;
        private String conditionField = null;
        private String childField = null;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentField() {
            return this.parentField;
        }

        public void setParentField(String parentField) {
            this.parentField = parentField;
        }

        public String getConditionField() {
            return this.conditionField;
        }

        public void setConditionField(String conditionField) {
            this.conditionField = conditionField;
        }

        public String getChildField() {
            return this.childField;
        }

        public void setChildField(String childField) {
            this.childField = childField;
        }

        public QueryCondition(String id, String parentField, String conditionField, String childField) {
            this.id = id;
            this.parentField = parentField;
            this.conditionField = conditionField;
            this.childField = childField;
        }
    }
}

