/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.pojo.query.QueryList;

public class QueryContext {
    private static final Log LOG = LogFactory.getLog(QueryContext.class);
    private static final ThreadLocal<QueryContext> THREAD_LOCAL = new ThreadLocal();
    private QueryGenParam queryGenParam;
    private QueryGenResult queryGenResult;
    private IFormView queryView;
    private Map<String, Object> designMetaDataMap;
    private DesignMetadataParser designMetadataParser;
    private boolean newCreateConfig = false;
    private boolean newCreateList = false;
    private Map<String, QueryField> queryFieldMap;
    private Map<String, QueryField> queryListFieldMap;
    private List<QueryField> queryListFieldList;
    private Map<String, QueryField> needQueryFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private String listNumber;
    private String listType;

    public QueryContext(QueryGenParam queryGenParam, QueryGenResult queryGenResult) {
        this.queryGenParam = queryGenParam;
        this.queryGenResult = queryGenResult;
        queryGenResult.setQueryNumber((String)Optional.ofNullable(queryGenParam).map(QueryGenParam::getNumber).orElse(null));
        queryGenResult.setQueryListNumber((String)Optional.ofNullable(queryGenParam).map(QueryGenParam::getQueryList).map(QueryList::getListNumber).orElse(null));
        this.queryFieldMap = queryGenParam.getQueryFieldList().stream().collect(Collectors.toMap(it -> this.getQueryKey((QueryField)it), Function.identity(), (o1, o2) -> o1));
        this.queryListFieldList = queryGenParam.getQueryFieldList();
        if (queryGenParam.getQueryList() != null && !queryGenParam.getQueryList().isFieldSameAsConfig()) {
            this.queryListFieldList = queryGenParam.getQueryList().getQueryFieldList();
        }
        this.queryListFieldMap = this.queryListFieldList.stream().collect(Collectors.toMap(it -> this.getQueryKey((QueryField)it), Function.identity(), (o1, o2) -> o1));
    }

    private String getQueryKey(QueryField queryField) {
        if (queryField.getQueryEntity().getNumber().equalsIgnoreCase(this.queryGenParam.getMainEntity().getNumber())) {
            return queryField.getFieldNumber();
        }
        return queryField.getQueryEntity().getAlias() + "." + queryField.getFieldNumber();
    }

    public static QueryContext create(QueryGenParam queryGenParam, QueryGenResult queryGenResult) {
        QueryContext queryContext = new QueryContext(queryGenParam, queryGenResult);
        THREAD_LOCAL.set(queryContext);
        return queryContext;
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    public static QueryContext get() {
        return THREAD_LOCAL.get();
    }

    public QueryGenParam getQueryGenParam() {
        return this.queryGenParam;
    }

    public QueryGenResult getQueryGenResult() {
        return this.queryGenResult;
    }

    public Map<String, QueryField> getQueryFieldMap() {
        return this.queryFieldMap;
    }

    public void addNewCreateConfig() {
        this.newCreateConfig = true;
    }

    public void addNewCreateList() {
        this.newCreateList = true;
    }

    public boolean isNewCreateConfig() {
        return this.newCreateConfig;
    }

    public boolean isNewCreateList() {
        return this.newCreateList;
    }

    public void bind(IFormView formView) {
        if (this.queryView != null) {
            throw new HRDBSBizException("query dynamic object already bind");
        }
        this.queryView = formView;
    }

    public IFormView getQueryView() {
        return this.queryView;
    }

    public void bind(Map<String, Object> designMetaDataMap, String listNumber, String listType) {
        if (this.designMetaDataMap != null) {
            throw new HRDBSBizException("query dynamic object already bind");
        }
        this.designMetaDataMap = designMetaDataMap;
        this.designMetadataParser = new DesignMetadataParser(designMetaDataMap);
        this.listNumber = listNumber;
        this.listType = listType;
    }

    public Map<String, Object> getDesignMetaDataMap() {
        return this.designMetaDataMap;
    }

    public DesignMetadataParser getDesignMetadataParser() {
        return this.designMetadataParser;
    }

    public String getListNumber() {
        return this.listNumber;
    }

    public String getListType() {
        return this.listType;
    }

    public Map<String, QueryField> getNeedQueryFieldMap() {
        return this.needQueryFieldMap;
    }

    public void setNeedQueryFieldMap(Map<String, QueryField> needQueryFieldMap) {
        this.needQueryFieldMap = needQueryFieldMap;
    }

    public Map<String, QueryField> getQueryListFieldMap() {
        return this.queryListFieldMap;
    }

    public List<QueryField> getQueryListFieldList() {
        return this.queryListFieldList;
    }
}

