/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query;

import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.bo.MetadataBo;
import kd.hdtc.hrdbs.common.asserts.MyAssert;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class QueryJudge {
    private static final Log LOG = LogFactory.getLog(QueryJudge.class);
    private static final IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);
    private String id;
    private String number;
    private String extNumber;

    public QueryJudge(String number) {
        MyAssert.assertNotEmpty((String)number, (String)"number");
        this.number = number;
    }

    public String judge() {
        boolean exist = metadataEntityService.isExists(this.number);
        if (!exist) {
            return "new";
        }
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)this.number);
        String isv = formMetadata.getIsv();
        if (IsvUtils.isCurrentIsv((String)isv)) {
            this.id = formMetadata.getId();
            return "modify";
        }
        String extQueryNumber = this.getCurrentIsvExtendQueryInSys();
        if (StringUtils.isNotEmpty((String)extQueryNumber)) {
            this.extNumber = extQueryNumber;
            return "extend_modify";
        }
        return "extend_new";
    }

    private String getCurrentIsvExtendQueryInSys() {
        String id = MetadataDao.getIdByNumber((String)this.number, (MetaCategory)MetaCategory.Form);
        Optional<MetadataBo> isvMetadataBoOptional = metadataEntityService.getIsvMetadataBo(id);
        return isvMetadataBoOptional.map(bo -> bo.getNumber()).orElse(null);
    }

    public String getNumber() {
        return this.number;
    }

    public String getExtNumber() {
        return this.extNumber;
    }

    public String getId() {
        return this.id;
    }
}

