/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.id.ID;
import kd.bos.list.SeqColumnType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.bo.FieldBo;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryList;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractQueryListModifier {
    private static final Log LOG = LogFactory.getLog(AbstractQueryListModifier.class);
    private static final String NOT_ORDER = "NotOrder";
    private static final String FSEQ = "fseq";
    protected List<Map<String, Object>> formMetadataList = QueryContext.get().getDesignMetadataParser().getFormMetadata();
    protected QueryGenParam queryGenParam = QueryContext.get().getQueryGenParam();
    protected List<Map<String, Object>> filterNodeList = Lists.newArrayList();
    private int index = 1000;
    protected List<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>(10);
    private Map<String, QueryField> queryFieldMap = QueryContext.get().getNeedQueryFieldMap();
    private Map<QueryField, String> queryFieldQueryKeyMap = QueryContext.get().getQueryListFieldMap().entrySet().stream().collect(Collectors.toMap(entry -> (QueryField)entry.getValue(), entry -> (String)entry.getKey()));
    private Map<String, Map<String, Object>> queryKeyListColumnNodeMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Map<String, Object>> queryKeyFastFilterNodeMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Map<String, Object>> queryKeySchemaFilterNodeMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Map<String, Object>> queryKeyNormalFilterNodeMap = Maps.newHashMapWithExpectedSize((int)16);

    public void modify() {
        LOG.info("modify query list start");
        this.doModify();
        this.modifyVisible();
        this.modifyOrder();
        LOG.info("modify query list end");
    }

    private void modifyVisible() {
        for (QueryField queryField : QueryContext.get().getQueryListFieldList()) {
            String queryKey = this.queryFieldQueryKeyMap.get(queryField);
            Optional.ofNullable(this.queryKeyListColumnNodeMap.get(queryKey)).ifPresent(nodeMap -> {
                if (queryField.isVisible()) {
                    nodeMap.remove("Visible");
                } else {
                    nodeMap.put("Visible", "");
                }
            });
        }
    }

    private void modifyOrder() {
        for (QueryField queryField : QueryContext.get().getQueryListFieldList()) {
            String queryKey = this.queryFieldQueryKeyMap.get(queryField);
            Optional.ofNullable(this.queryKeyListColumnNodeMap.get(queryKey)).ifPresent(nodeMap -> nodeMap.put("Index", ConvertUtils.toString((Object)this.index)));
            Optional.ofNullable(this.queryKeyFastFilterNodeMap.get(queryKey)).ifPresent(nodeMap -> nodeMap.put("Index", ConvertUtils.toString((Object)this.index)));
            Optional.ofNullable(this.queryKeySchemaFilterNodeMap.get(queryKey)).ifPresent(nodeMap -> nodeMap.put("Index", ConvertUtils.toString((Object)this.index)));
            Optional.ofNullable(this.queryKeyNormalFilterNodeMap.get(queryKey)).ifPresent(nodeMap -> nodeMap.put("Index", ConvertUtils.toString((Object)this.index)));
            ++this.index;
        }
    }

    protected abstract void doModify();

    protected void initFilterNodeList() {
        for (QueryField queryField : QueryContext.get().getQueryListFieldList()) {
            this.addFastFilterNode(queryField);
            this.addSchemeFilterNode(queryField);
            this.addNormalQueryFilter(queryField);
        }
    }

    protected void clearNodeByType(String columnAp) {
        Iterator<Map<String, Object>> iterator = this.formMetadataList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> nodeMap = iterator.next();
            if (this.skipCondition(nodeMap) || !columnAp.equals(nodeMap.get("_Type_"))) continue;
            iterator.remove();
        }
    }

    protected boolean skipCondition(Map<String, Object> nodeMap) {
        return false;
    }

    protected List<Map<String, Object>> buildNewDataColumnList() {
        this.nodeList.addAll(this.createNewDataColumns("", QueryContext.get().getQueryGenParam().getMainEntity().getNumber()));
        for (QueryEntity queryEntity : this.queryGenParam.getSubQueryEntityList()) {
            this.nodeList.addAll(this.createNewDataColumns(queryEntity.getNumber() + ".", queryEntity.getNumber()));
        }
        return this.nodeList;
    }

    private void addNormalQueryFilter(QueryField queryField) {
        if (!queryField.isNormalQueryFilter()) {
            return;
        }
        String queryFieldNumber = this.queryFieldQueryKeyMap.get(queryField);
        if (this.queryKeyNormalFilterNodeMap.containsKey(queryFieldNumber)) {
            return;
        }
        String baseEntityId = this.getBaseEntityId(queryField);
        HashMap nodeMap = Maps.newHashMap();
        nodeMap.put("ParentId", "filtergridview");
        nodeMap.put("_Type_", baseEntityId == null ? "CommonFilterColumnAp" : "CommonBaseDataFilterColumnAp");
        nodeMap.put("Type", baseEntityId == null ? "enum" : "text");
        nodeMap.put("Index", 1);
        nodeMap.put("Id", ID.genStringId());
        nodeMap.put("FieldName", queryFieldNumber);
        nodeMap.put("Key", AbstractQueryListModifier.getFilterKey((String)nodeMap.get("_Type_"), queryFieldNumber));
        nodeMap.put("Name", queryField.getFieldName());
        if (baseEntityId != null) {
            nodeMap.put("BaseEntityId", baseEntityId);
        }
        this.filterNodeList.add(nodeMap);
        this.queryKeyNormalFilterNodeMap.put((String)nodeMap.get("Key"), nodeMap);
    }

    private String getBaseEntityId(QueryField queryField) {
        FieldBo fieldBo = new FieldBo(queryField.getQueryEntity().getNumber(), queryField.getFieldNumber());
        fieldBo.init();
        return fieldBo.getBaseEntityId();
    }

    private void addSchemeFilterNode(QueryField queryField) {
        if (!queryField.isSchemeFilter()) {
            return;
        }
        String queryFieldNumber = this.queryFieldQueryKeyMap.get(queryField);
        if (this.queryKeySchemaFilterNodeMap.containsKey(queryFieldNumber)) {
            return;
        }
        HashMap nodeMap = Maps.newHashMap();
        nodeMap.put("ParentId", "schemefilterview");
        nodeMap.put("_Type_", "SchemeComboFilterColumnAp");
        nodeMap.put("Id", ID.genStringId());
        nodeMap.put("FieldName", queryFieldNumber);
        nodeMap.put("Key", AbstractQueryListModifier.getFilterKey((String)nodeMap.get("_Type_"), queryFieldNumber));
        nodeMap.put("Name", queryField.getFieldName());
        this.filterNodeList.add(nodeMap);
        this.queryKeySchemaFilterNodeMap.put((String)nodeMap.get("Key"), nodeMap);
    }

    private static String getFilterKey(String apType, String queryKey) {
        return apType.toLowerCase(Locale.ROOT) + queryKey;
    }

    private void addFastFilterNode(QueryField queryField) {
        if (!queryField.isFastFilter()) {
            return;
        }
        String queryFieldNumber = this.queryFieldQueryKeyMap.get(queryField);
        if (this.queryKeyFastFilterNodeMap.containsKey(queryFieldNumber)) {
            return;
        }
        HashMap fastFilterNodeMap = Maps.newHashMap();
        fastFilterNodeMap.put("ParentId", "fastsearchgridview");
        fastFilterNodeMap.put("_Type_", "FilterColumnAp");
        fastFilterNodeMap.put("Id", ID.genStringId());
        fastFilterNodeMap.put("FieldName", queryFieldNumber);
        fastFilterNodeMap.put("Key", AbstractQueryListModifier.getFilterKey((String)fastFilterNodeMap.get("_Type_"), queryFieldNumber));
        fastFilterNodeMap.put("Name", queryField.getFieldName());
        this.filterNodeList.add(fastFilterNodeMap);
        this.queryKeyFastFilterNodeMap.put((String)fastFilterNodeMap.get("Key"), fastFilterNodeMap);
    }

    protected List<Map<String, Object>> createNewDataColumns(String prefix, String number) {
        ArrayList<Map<String, Object>> entityNodeList = new ArrayList<Map<String, Object>>(10);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        Map allFields = mainType.getAllFields();
        if (CollectionUtils.isNotEmpty((Map)allFields)) {
            for (Map.Entry propertyEntry : allFields.entrySet()) {
                String queryKey;
                QueryField queryField;
                IDataEntityProperty prop = (IDataEntityProperty)propertyEntry.getValue();
                if (prop instanceof BasedataProp) {
                    this.addBasedataProp(prefix, entityNodeList, prop);
                    continue;
                }
                if (prop.isDbIgnore() || (queryField = this.queryFieldMap.get(queryKey = prefix + prop.getName())) == null) continue;
                entityNodeList.add(this.createNodeMap(queryKey, queryField, prop));
            }
        }
        return entityNodeList;
    }

    private void addBasedataProp(String prefix, List<Map<String, Object>> entityNodeList, IDataEntityProperty prop) {
        BasedataProp basedataProp = (BasedataProp)prop;
        DataEntityPropertyCollection baseDataProps = basedataProp.getComplexType().getProperties();
        if (CollectionUtils.isNotEmpty((Collection)baseDataProps)) {
            for (IDataEntityProperty complexProp : baseDataProps) {
                String queryKey;
                QueryField queryField;
                if (complexProp instanceof BasedataProp) {
                    String subPrefix = prefix + prop.getName() + ".";
                    this.addBasedataProp(subPrefix, entityNodeList, complexProp);
                    continue;
                }
                String ppName = complexProp.getName();
                if ("id".equals(ppName) || "multilanguagetext".equals(ppName) || StringUtils.isBlank((CharSequence)ppName) || (queryField = this.queryFieldMap.get(queryKey = prefix + prop.getName() + "." + complexProp.getName())) == null) continue;
                entityNodeList.add(this.createNodeMap(queryKey, queryField, null));
            }
        }
    }

    private Map<String, Object> createNodeMap(String queryKey, QueryField queryField, IDataEntityProperty prop) {
        LinkedHashMap listNodeMap = Maps.newLinkedHashMap();
        listNodeMap.put("ParentId", "gridview");
        String fieldName = queryField.getFieldName();
        if (prop == null && HRStringUtils.equals((String)fieldName, (String)ResManager.loadKDString((String)"\u4eba\u5458\u5934\u50cf", (String)"AbstractQueryListModifier_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]))) {
            listNodeMap.put("_Type_", "AvatarListColumnAp");
        } else {
            listNodeMap.put("_Type_", this.getType(prop));
        }
        listNodeMap.put("Name", fieldName);
        listNodeMap.put("Order", NOT_ORDER);
        listNodeMap.put("SeqColumnType", SeqColumnType.NotSeq.name());
        String nodeKey = this.queryFieldQueryKeyMap.get(queryField);
        listNodeMap.put("ListFieldId", nodeKey);
        listNodeMap.put("ColumnOrderAndFilter", Boolean.TRUE);
        listNodeMap.put("Id", ID.genStringId());
        listNodeMap.put("Key", AbstractQueryListModifier.getFilterKey((String)listNodeMap.get("_Type_"), nodeKey));
        if (queryField.isHyperLink()) {
            listNodeMap.put("Hyperlink", Boolean.TRUE);
        }
        this.addListColumnQueryKeyNode(queryKey, listNodeMap);
        return listNodeMap;
    }

    private String getType(IDataEntityProperty prop) {
        if (prop == null) {
            return "ListColumnAp";
        }
        if (prop instanceof DateProp || prop instanceof DateTimeProp) {
            return "DateListColumnAp";
        }
        if (prop instanceof DecimalProp) {
            return "DecimalListColumnAp";
        }
        if (prop instanceof PictureProp) {
            return "PictureListColumnAp";
        }
        if (prop instanceof BooleanProp) {
            return "CheckBoxListColumnAp";
        }
        if (prop instanceof MulComboProp) {
            return "MulComboListColumnAp";
        }
        if (prop instanceof ComboProp) {
            return "ComboListColumnAp";
        }
        if (prop instanceof TimeProp) {
            return "TimeListColumnAp";
        }
        return "ListColumnAp";
    }

    public final void addListColumnQueryKeyNode(String queryKey, Map<String, Object> listNodeMap) {
        this.queryKeyListColumnNodeMap.put(queryKey, listNodeMap);
    }

    public final void addFastFilterQueryKeyNode(String nodeKey, Map<String, Object> nodeMap) {
        this.queryKeyFastFilterNodeMap.put(nodeKey, nodeMap);
    }

    public final void addSchemeFilterQueryKeyNode(String nodeKey, Map<String, Object> nodeMap) {
        this.queryKeySchemaFilterNodeMap.put(nodeKey, nodeMap);
    }

    public final void addNormalFilterQueryKeyNode(String nodeKey, Map<String, Object> nodeMap) {
        this.queryKeyNormalFilterNodeMap.put(nodeKey, nodeMap);
    }

    protected List<Map<String, Object>> buildSeqNewDataColumnList() {
        boolean generateSeq = Optional.ofNullable(this.queryGenParam).map(QueryGenParam::getQueryList).map(QueryList::isGenerateSeq).orElse(false);
        if (generateSeq) {
            HashMap seqNodeMap = Maps.newHashMapWithExpectedSize((int)16);
            seqNodeMap.put("ParentId", "gridview");
            seqNodeMap.put("_Type_", "ListColumnAp");
            seqNodeMap.put("Name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AbstractQueryListModifier_1", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
            seqNodeMap.put("Order", NOT_ORDER);
            seqNodeMap.put("SeqColumnType", SeqColumnType.EntitySeq.name());
            seqNodeMap.put("ListFieldId", FSEQ);
            seqNodeMap.put("Id", ID.genStringId());
            seqNodeMap.put("Index", 1);
            seqNodeMap.put("Key", "listcolumnap.fseq");
            return Lists.newArrayList((Object[])new Map[]{seqNodeMap});
        }
        return Lists.newArrayListWithCapacity((int)10);
    }
}

