/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query.list;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.AbstractQueryListModifier;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class NewQueryListModifier
extends AbstractQueryListModifier {
    private static final Log LOG = LogFactory.getLog(NewQueryListModifier.class);
    private static final IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);
    private List<Map<String, Object>> resultNodeList;

    @Override
    protected void doModify() {
        this.initResultNodeList();
        this.addListPlugins();
        this.addNodes();
        LOG.info("NewQueryListModifier end");
    }

    private void initResultNodeList() {
        this.resultNodeList = this.formMetadataList.stream().filter(node -> "QueryListFormAp".equals(node.get("_Type_"))).collect(Collectors.toList());
        Map<String, Object> sourceMetaData = metadataEntityService.getDesignMetadata(this.queryGenParam.getQueryList().getRelQueryListNumber());
        DesignMetadataParser sourceDataDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List<Map<String, Object>> formNodeList = sourceDataDesignMetadataParser.getFormMetadata();
        List addNodeList = formNodeList.stream().filter(node -> !"QueryListFormAp".equals(node.get("_Type_")) && !node.containsKey("ListFieldId")).collect(Collectors.toList());
        this.resultNodeList.addAll(addNodeList);
    }

    private void addNodes() {
        this.initFilterNodeList();
        this.resultNodeList.addAll(this.filterNodeList);
        this.resultNodeList.addAll(this.buildSeqNewDataColumnList());
        this.resultNodeList.addAll(this.buildNewDataColumnList());
        Map formData = Optional.ofNullable(QueryContext.get().getDesignMetaDataMap()).map(it -> (Map)it.get("formmeta")).get();
        formData.put("Items", this.resultNodeList);
    }

    private void addListPlugins() {
        if (CollectionUtils.isNotEmpty(this.resultNodeList)) {
            List<Map<String, Object>> plugins = this.buildPluginList();
            Map<String, Object> baseInfo = this.resultNodeList.get(0);
            baseInfo.put("Plugins", plugins);
        }
    }

    private List<Map<String, Object>> buildPluginList() {
        ArrayList<Map<String, Object>> pluginMapList = new ArrayList<Map<String, Object>>(4);
        for (String pluginClass : this.queryGenParam.getQueryList().getPluginList()) {
            ImmutableMap pluginMap = ImmutableMap.builder().put((Object)"FPK", (Object)"").put((Object)"_Type_", (Object)"Plugin").put((Object)"Description", (Object)"Plugin").put((Object)"ClassName", (Object)pluginClass).put((Object)"Enabled", (Object)Boolean.TRUE).put((Object)"BizAppId", (Object)Boolean.TRUE).build();
            pluginMapList.add((Map<String, Object>)pluginMap);
        }
        return pluginMapList;
    }
}

