/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query.list;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.AbstractQueryListModifier;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.ExtendModifyQueryListModifier;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.ExtendNewQueryListModifier;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.ModifyQueryListModifier;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.NewQueryListModifier;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.QueryListLoader;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.util.LogUtils;

public class QueryListGenerator {
    private static final Log LOG = LogFactory.getLog(QueryListGenerator.class);
    private static final IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);
    private Map<String, Supplier<AbstractQueryListModifier>> sceneMap = ImmutableMap.of((Object)"new", () -> new NewQueryListModifier(), (Object)"modify", () -> new ModifyQueryListModifier(), (Object)"extend_new", () -> new ExtendNewQueryListModifier(), (Object)"extend_modify", () -> new ExtendModifyQueryListModifier());

    public void generate() {
        if (QueryContext.get().getQueryGenParam().getQueryList() == null) {
            LOG.info("queryList is empty, jump generate");
            return;
        }
        LOG.info("query list generate start");
        LogUtils.printTimeCostLog((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5217\u8868\u52a0\u8f7d", (String)"QueryListGenerator_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]), () -> new QueryListLoader().load());
        if (QueryContext.get().getListType() == null) {
            throw new HRDBSBizException("list type should not be null");
        }
        Optional.ofNullable(this.sceneMap.get(QueryContext.get().getListType())).map(it -> (AbstractQueryListModifier)it.get()).ifPresent(it -> it.modify());
        Map<String, Object> designMetaDataMap = QueryContext.get().getDesignMetaDataMap();
        Map<String, Object> resultMap = metadataEntityService.save(designMetaDataMap);
        boolean success = (Boolean)resultMap.getOrDefault("success", Boolean.FALSE);
        if (!success) {
            throw new HRDBSBizException("generate query list error");
        }
        String formId = (String)designMetaDataMap.get("id");
        this.addFormId2Result(formId);
        metadataEntityService.saveAppUnit(formId, QueryContext.get().getQueryGenParam().getUnit(), (String)designMetaDataMap.get("bizappid"));
        LOG.info("query list generate end");
    }

    private void addFormId2Result(String formId) {
        QueryGenResult queryGenResult = QueryContext.get().getQueryGenResult();
        if (QueryContext.get().getListType().contains("extend")) {
            queryGenResult.setExtQueryListId(formId);
            return;
        }
        queryGenResult.setQueryListId(formId);
    }
}

