/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.query.list;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryJudge;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class QueryListLoader {
    private static final Log LOG = LogFactory.getLog(QueryListLoader.class);
    private QueryGenParam queryGenParam = QueryContext.get().getQueryGenParam();
    private QueryGenResult queryGenResult = QueryContext.get().getQueryGenResult();
    private Map<String, Object> designMetadataMap;
    private QueryContext queryContext = QueryContext.get();
    private static final IDynamicMetadataApplicationService iDynamicMetadataApplicationService = ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private static final IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);
    private Map<String, Consumer<String>> sceneMap = ImmutableMap.of((Object)"new", param -> this.initNewDesignMetadata(), (Object)"modify", param -> this.initModifyDesignMetadata(), (Object)"extend_new", param -> this.initExtendNewDesignMetadata(), (Object)"extend_modify", param -> this.initExtendModifyDesignMetadata());
    private String extQueryListNumber;
    private String sceneType;

    public void load() {
        this.initQueryListBaseInfo();
        this.sceneMap.get(this.sceneType).accept(null);
        this.queryGenResult.setExtQueryListNumber(this.extQueryListNumber);
        LOG.info("sceneType = {}, ori query list = {}, ext query list = {}", new Object[]{this.sceneType, this.queryGenParam.getQueryList().getListNumber(), this.extQueryListNumber});
    }

    private void initQueryListBaseInfo() {
        QueryJudge queryJudge = new QueryJudge(this.queryGenParam.getQueryList().getListNumber());
        this.sceneType = queryJudge.judge();
        this.extQueryListNumber = queryJudge.getExtNumber();
    }

    private void initNewDesignMetadata() {
        Map<String, Object> param = this.buildTplInfo(this.queryGenParam.getQueryList().getListNumber(), this.queryGenParam.getQueryList().getListName());
        this.designMetadataMap = metadataEntityService.createDesignMetadata(param);
        this.queryContext.bind(this.designMetadataMap, this.queryGenParam.getQueryList().getListNumber(), "new");
    }

    private void initModifyDesignMetadata() {
        this.designMetadataMap = metadataEntityService.getDesignMetadata(this.queryGenParam.getQueryList().getListNumber());
        this.queryContext.bind(this.designMetadataMap, this.queryGenParam.getQueryList().getListNumber(), "modify");
    }

    private void initExtendNewDesignMetadata() {
        String extNumberAuto = AppUtils.autoExtendedNumber((String)this.queryGenParam.getQueryList().getListNumber());
        String extNumber = DevportalUtil.autoFormNumber((String)extNumberAuto, (String)"_ext");
        Map<String, Object> paramMap = this.createExtGenMap(extNumber);
        this.extQueryListNumber = extNumber;
        this.designMetadataMap = metadataEntityService.createDesignMetadata(paramMap);
        this.queryContext.bind(this.designMetadataMap, this.queryGenParam.getQueryList().getListNumber(), "extend_new");
    }

    private void initExtendModifyDesignMetadata() {
        this.designMetadataMap = metadataEntityService.getDesignMetadata(this.extQueryListNumber);
        this.queryContext.bind(this.designMetadataMap, this.extQueryListNumber, "extend_modify");
    }

    private Map<String, Object> createExtGenMap(String extNumber) {
        HashMap genMap = Maps.newHashMap();
        genMap.put("devType", "2");
        genMap.put("bizappid", this.queryGenResult.getRealAppId());
        genMap.put("name", this.queryGenParam.getName());
        genMap.put("modelType", "QueryListModel");
        genMap.put("bizunitid", this.queryGenParam.getUnit());
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)this.queryGenParam.getQueryList().getListNumber());
        genMap.put("parentId", formMetadata.getId());
        genMap.put("entityId", formMetadata.getEntityId());
        genMap.put("id", extNumber);
        return genMap;
    }

    private Map<String, Object> buildTplInfo(String metaDataNumber, String metaDataName) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("bizappid", this.queryGenResult.getRealAppId());
        param.put("modelType", "QueryListModel");
        param.put("id", metaDataNumber);
        param.put("name", metaDataName);
        param.put("entityId", this.queryGenResult.getQueryId());
        return param;
    }
}

