/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.impl.bo.MetadataBo;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class MetadataUtils {
    public static final DesignerData DESIGNER_DATA = new DesignerData();
    private static final String QUERY_METADATA_SQL = "SELECT FID id, FMasterId masterId, FParentId parentId, FVERSION version, FNumber number, finheritpath inheritPath, fmodifydate modifyDate from  T_META_FORMDESIGN WHERE  %s in (%s);";
    private static final String METADATA_EXT_SQL = "SELECT FId id, FMasterId masterId, FNumber number, finheritpath inheritPath, fmodifydate modifyDate from  T_META_FORMDESIGN WHERE fmasterid in (%s) and ftype = '2' order by fmasterid, FInheritPath desc;";
    private static final String METADATA_EXT_ISV_SQL = "SELECT FId id, FMasterId masterId, FNumber number, finheritpath inheritPath, fmodifydate modifyDate from  T_META_FORMDESIGN WHERE fmasterid in (%s) and ftype = '2'  and fisv = ? order by fmasterid, FInheritPath desc;";
    private static final String MULTI_LANGUAGE_TEXT = "multilanguagetext";

    public static boolean checkNumber(String number) {
        return DESIGNER_DATA.checkNumber(number);
    }

    public static Map<String, Object> createBlankModel(Map<String, Object> parameters) {
        if (MetadataUtils.useBosDesigner()) {
            return DESIGNER_DATA.createBlankModel(parameters);
        }
        return MetadataUtils.createBlankModelSimple(parameters);
    }

    private static boolean useBosDesigner() {
        return HRStringUtils.isNotEmpty((String)ISVService.getISVInfo().getId());
    }

    public static Map<String, Object> save(Map<String, Object> content) {
        if (MetadataUtils.useBosDesigner()) {
            return DESIGNER_DATA.save(content, true);
        }
        return MetadataUtils.saveSimple(content);
    }

    public static Map<String, Object> getDesignerMetadata(String number) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
        if (designerMetadata != null) {
            designerMetadata.put("subSystem", 1);
            designerMetadata.put("isv", "kingdee");
        }
        return designerMetadata;
    }

    public static List<MainEntityType> getEntityTypeList(String number) {
        ArrayList<MainEntityType> entityTypeList = new ArrayList<MainEntityType>();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypeList.add(queryType.getMainEntityType());
            entityTypeList.addAll(queryType.getAllJoinEntityType());
        } else {
            entityTypeList.add(mainType);
        }
        return entityTypeList;
    }

    public static MainEntityType getMainEntityType(String number) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            return queryType.getMainEntityType();
        }
        return mainType;
    }

    public static List<String> getQueryFieldNumberList(String number) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType(number);
        ArrayList queryFileNameList = Lists.newArrayListWithExpectedSize((int)mainEntityType.getProperties().size());
        ArrayList needDeleteFieldNumberList = Lists.newArrayListWithExpectedSize((int)10);
        mainEntityType.getProperties().forEach(property -> {
            if (property instanceof EntryProp) {
                String entityName = property.getName();
                ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties().forEach(pro -> {
                    if (pro instanceof SubEntryProp) {
                        ((EntryProp)pro).getDynamicCollectionItemPropertyType().getProperties().forEach(subPro -> {
                            String queryField = pro.getName() + "." + subPro.getName();
                            if (!MULTI_LANGUAGE_TEXT.equals(subPro.getName())) {
                                queryFileNameList.add(queryField);
                            }
                            if (subPro instanceof BasedataProp) {
                                needDeleteFieldNumberList.add(queryField + "_id");
                            }
                        });
                    } else {
                        String queryField = entityName + "." + pro.getName();
                        if (!MULTI_LANGUAGE_TEXT.equals(pro.getName())) {
                            queryFileNameList.add(queryField);
                        }
                        if (pro instanceof BasedataProp) {
                            needDeleteFieldNumberList.add(queryField + "_id");
                        }
                    }
                });
            } else {
                if (!MULTI_LANGUAGE_TEXT.equals(property.getName())) {
                    queryFileNameList.add(property.getName());
                }
                if (property instanceof BasedataProp) {
                    needDeleteFieldNumberList.add(property.getName() + "_id");
                }
            }
        });
        queryFileNameList.removeAll(needDeleteFieldNumberList);
        return queryFileNameList;
    }

    public static String getExtMetaNumber(String number) {
        MetadataReader reader = new MetadataReader(false, RequestContext.get().getLang().toString());
        AbstractMetadata metadata = reader.readMetaForMetadataDao(MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form), OrmUtils.getDataEntityType(DesignFormMeta.class), true, false);
        ArrayList<String> nodeList = new ArrayList<String>();
        nodeList.add(metadata.getId());
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignFormMeta.class);
        String tableName = designerMetaType.getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID, FMasterId, FParentId, FENABLED, FVERSION, FNumber from ", new Object[0]).append(tableName, new Object[0]).append(" WHERE ", new Object[0]).appendIn("FMasterId", nodeList.toArray()).append(" and FType = '2' order by FInheritPath", new Object[0]);
        ResultSetHandler action = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString("FNumber"));
            }
            return list;
        };
        List list = (List)DB.query((DBRoute)MetadataUtils.getDbRoute(designerMetaType), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return CollectionUtils.isEmpty((Collection)list) ? number : (String)list.get(0);
    }

    public static String getExtMetaNumber(String number, boolean isv) {
        MetadataReader reader = new MetadataReader(false, RequestContext.get().getLang().toString());
        AbstractMetadata metadata = reader.readMetaForMetadataDao(MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form), OrmUtils.getDataEntityType(DesignFormMeta.class), true, false);
        ArrayList<String> nodeList = new ArrayList<String>();
        nodeList.add(metadata.getId());
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignFormMeta.class);
        String tableName = designerMetaType.getAlias();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID, FMasterId, FParentId, FENABLED, FVERSION, FNumber from ", new Object[0]).append(tableName, new Object[0]).append(" WHERE ", new Object[0]).appendIn("FMasterId", nodeList.toArray()).append(" and FType = '2' order by FInheritPath", new Object[0]);
        ResultSetHandler action = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString("FNumber"));
            }
            return list;
        };
        List list = (List)DB.query((DBRoute)MetadataUtils.getDbRoute(designerMetaType), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return CollectionUtils.isEmpty((Collection)list) ? number : (String)list.get(0);
    }

    public static Map<String, MetadataBo> getMetadataBoByNumberMap(Set<String> numberSet) {
        String queryField = "fnumber";
        return MetadataUtils.getStringMetadataBoMap(queryField, numberSet);
    }

    public static Map<String, MetadataBo> getMetadataBoByIdMap(Set<String> idSet) {
        String queryField = "fid";
        return MetadataUtils.getStringMetadataBoMap(queryField, idSet);
    }

    private static Map<String, MetadataBo> getStringMetadataBoMap(String key, Set<String> keySet) {
        String sql = String.format(Locale.ROOT, QUERY_METADATA_SQL, key, MetadataUtils.getOccupySymbol(keySet));
        Map metadataBoMap = (Map)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, (Object[])keySet.toArray(), resultSet -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            while (resultSet.next()) {
                MetadataBo metadataBo = MetadataUtils.packageBo(resultSet);
                map.put(metadataBo.getId(), metadataBo);
            }
            return map;
        });
        return metadataBoMap;
    }

    private static MetadataBo packageBo(ResultSet resultSet) throws SQLException {
        MetadataBo metadataBo = new MetadataBo();
        metadataBo.setId(resultSet.getString("id"));
        metadataBo.setMasterId(resultSet.getString("masterId"));
        metadataBo.setModifyDate(resultSet.getTimestamp("modifyDate"));
        metadataBo.setInheritPath(resultSet.getString("inheritPath"));
        metadataBo.setNumber(resultSet.getString("number"));
        return metadataBo;
    }

    private static String getOccupySymbol(Set<String> numberSet) {
        List list = numberSet.stream().map(it -> "?").collect(Collectors.toList());
        return StringUtils.join((Object[])list.toArray(), (String)",");
    }

    public static Map<String, String> getMetadataInheritPath(Map<String, MetadataBo> boMap) {
        Set boSet = boMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Map<String, String> map = boSet.stream().collect(Collectors.toMap(MetadataBo::getId, MetadataBo::getNumber, (o1, o2) -> o1));
        String sql = String.format(Locale.ROOT, METADATA_EXT_SQL, MetadataUtils.getOccupySymbol(map.keySet()));
        List metadataBoList = (List)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, (Object[])map.keySet().toArray(), resultSet -> {
            ArrayList boList = Lists.newArrayList();
            if (resultSet.next()) {
                boList.add(MetadataUtils.packageBo(resultSet));
            }
            return boList;
        });
        Map<String, List<MetadataBo>> mapList = metadataBoList.stream().collect(Collectors.groupingBy(MetadataBo::getMasterId));
        Map<String, String> resultMap = boMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toMap(MetadataBo::getId, it -> it.getInheritPath() + "," + it.getId()));
        for (Map.Entry<String, List<MetadataBo>> entry : mapList.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            MetadataBo bo = entry.getValue().get(0);
            resultMap.put(entry.getKey(), bo.getInheritPath() + "," + bo.getId());
        }
        return resultMap;
    }

    public static List<MetadataBo> getIsvExtMetadata(Set<String> numberSet) {
        String sql = String.format(Locale.ROOT, METADATA_EXT_ISV_SQL, MetadataUtils.getOccupySymbol(numberSet));
        ArrayList paramList = Lists.newArrayList(numberSet);
        paramList.add(ISVService.getISVInfo().getId());
        List metadataBoList = (List)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, (Object[])paramList.toArray(), resultSet -> {
            ArrayList boList = Lists.newArrayListWithCapacity((int)10);
            while (resultSet.next()) {
                boList.add(MetadataUtils.packageBo(resultSet));
            }
            return boList;
        });
        return metadataBoList;
    }

    private static DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    public static Map<String, Object> createBlankModelSimple(Map<String, Object> parameters) {
        String modelType = (String)parameters.get("modelType");
        String entityNumber = (String)parameters.get("id");
        String objName = (String)parameters.get("name");
        LocaleString name = new LocaleString("zh_CN", objName);
        String parentId = (String)parameters.get("parentId");
        String bizAppId = (String)parameters.get("bizappid");
        String devType = (String)parameters.get("devType");
        devType = StringUtils.isBlank((CharSequence)devType) ? "0" : devType;
        IFormTemplate template = FormTemplateFactory.createTemplate((String)modelType);
        EntityMetadata entityMeta = null;
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)parentId, (MetaCategory)MetaCategory.Form);
        formMeta.setId(DBServiceHelper.genStringId());
        String inheritPath = formMeta.getInheritPath();
        formMeta.setModelType(modelType);
        formMeta.setParentId(parentId);
        formMeta.setDevType(devType);
        if (!StringUtils.isEmpty((CharSequence)parentId)) {
            inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? parentId : inheritPath + ',' + parentId;
            formMeta.setInheritPath(inheritPath);
            MetadataUtils.setInheritFlag(formMeta.getItems());
        }
        formMeta.setKey(entityNumber);
        formMeta.setName(name);
        String entityId = (String)parameters.get("entityId");
        if (StringUtils.isBlank((CharSequence)parentId)) {
            throw new HRDBSBizException("templdate id should not be empty");
        }
        entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        entityMeta.setParentId(parentId);
        entityMeta.setId(formMeta.getId());
        entityMeta.setModelType(modelType);
        entityMeta.getRootEntity().setTemplate(false);
        if (entityMeta.getRootEntity() instanceof BillEntity) {
            ((BillEntity)entityMeta.getRootEntity()).setDefaultPageSetting("{\"mblist\":\"\",\"pclist\":\"\",\"pcbill\":\"\",\"mbbill\":\"\"}");
        }
        MetadataUtils.setInheritFlag(entityMeta.getItems());
        entityId = formMeta.getId();
        entityMeta.setKey(entityNumber);
        entityMeta.setName(name);
        entityMeta.getRootEntity().setKey(entityNumber);
        entityMeta.getRootEntity().setdbRoute(MetadataUtils.getDBRouteNameByAppId(bizAppId));
        formMeta.setBizappId(bizAppId);
        entityMeta.setBizappId(bizAppId);
        formMeta.bindEntityMetadata(entityMeta);
        formMeta.setEntityId(entityId);
        formMeta.setIsv("kingdee");
        return formMeta.buildDesignMeta("zh_CN");
    }

    public static String getDBRouteNameByAppId(String appId) {
        AppInfo appInfo = EntityMetadataCache.getAppInfo((String)appId);
        return appInfo.getDbRoute();
    }

    public static Map<String, Object> saveSimple(Map<String, Object> content) {
        Map formMeta = (Map)content.get("formmeta");
        String modelType = (String)formMeta.get("ModelType");
        AbstractMetadata metadata = new FormMetadataConverter().convertTo(content);
        EntityMetadata entityMetadata = ((FormMetadata)metadata).getEntityMetadata();
        entityMetadata.setIsvSign(metadata.getIsvSign());
        MetadataUtils.clearSubRuntimeMeta((AbstractMetadata)((FormMetadata)metadata));
        return new MetadataWriter(modelType).save(Boolean.TRUE, new AbstractMetadata[]{metadata, entityMetadata});
    }

    private static void clearSubRuntimeMeta(AbstractMetadata formMeta) {
        ArrayList<String> formIds = new ArrayList<String>();
        formIds.add(formMeta.getId());
        MetadataDao.clearSubRuntimeMeta(formIds);
    }

    private static void setInheritFlag(List<? extends AbstractElement> elementList) {
        elementList.forEach(ele -> ele.setInherit(true));
    }

    public static Set<String> getExtAppInfoByAppIds(Set<String> appIdSet) {
        if (CollectionUtils.isEmpty(appIdSet)) {
            return new HashSet<String>();
        }
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignFormMeta.class);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_meta_bizapp where ", new Object[0]).appendIn("FMasterId", appIdSet.toArray());
        ResultSetHandler action = rs -> {
            HashSet extAppIdSet = Sets.newHashSetWithExpectedSize((int)appIdSet.size());
            while (rs.next()) {
                extAppIdSet.add(rs.getString("fid"));
            }
            return extAppIdSet;
        };
        Set extAppIdSet = (Set)DB.query((DBRoute)MetadataUtils.getDbRoute(designerMetaType), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return CollectionUtils.isEmpty((Collection)extAppIdSet) ? new HashSet() : extAppIdSet;
    }
}

