/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.util;

import java.util.Collection;
import java.util.List;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.hibernate.groups.MidGroup;
import kd.hdtc.hrdbs.common.hibernate.groups.NormalGroup;
import kd.hdtc.hrdbs.common.hibernate.utils.ValidationUtils;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.pojo.metadata.ParamValidateResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class ParamValidateUtils {
    public static void validateParam(MetadataGenParam metadataGenParam, MetadataGenResult genResult) {
        BaseParam baseParam = metadataGenParam.getBaseParam();
        MetadataGenTypeEnum type = baseParam.getType();
        ParamValidateUtils.validate(baseParam, type, genResult);
        List fieldParamList = metadataGenParam.getFieldParamList();
        ParamValidateUtils.listParamValidate(fieldParamList, type, genResult);
    }

    private static void listParamValidate(List<?> paramList, MetadataGenTypeEnum type, MetadataGenResult genResult) {
        for (Object obj : paramList) {
            ParamValidateUtils.validate(obj, type, genResult);
        }
    }

    private static <T> void validate(T obj, MetadataGenTypeEnum type, MetadataGenResult genResult) {
        List validateList = ValidationUtils.validate(obj, ParamValidateUtils.getGroupByType(type));
        if (CollectionUtils.isNotEmpty((Collection)validateList)) {
            genResult.setSuccess(Boolean.FALSE.booleanValue());
            genResult.setErrorCode(1000);
            List msgList = genResult.getMsgList();
            for (ParamValidateResult result : validateList) {
                msgList.add(result.getMsg());
            }
        }
    }

    private static Class<?> getGroupByType(MetadataGenTypeEnum type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case MID_TABLE: {
                return MidGroup.class;
            }
            case NORMAL_METADATA: {
                return NormalGroup.class;
            }
        }
        return null;
    }
}

