/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.ParamValidateUtils;
import kd.hdtc.hrdbs.common.pojo.NodeParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import org.apache.commons.lang3.StringUtils;

public class ParamValidator {
    private static final Log LOG = LogFactory.getLog(ParamValidator.class);
    private MetadataGenParam metadataGenParam;
    private MetadataGenResult metadataGenResult;

    public ParamValidator(MetadataGenParam metadataGenParam, MetadataGenResult metadataGenResult) {
        this.metadataGenParam = metadataGenParam;
        this.metadataGenResult = metadataGenResult;
    }

    public void validate() {
        ParamValidateUtils.validateParam(this.metadataGenParam, this.metadataGenResult);
        this.validateFieldRepeat();
    }

    private void validateFieldRepeat() {
        ArrayList allNumberList = Lists.newArrayListWithCapacity((int)10);
        this.metadataGenParam.getFieldParamList().stream().map(NodeParam::getNumber).forEach(number -> allNumberList.add(number));
        this.appendEntryField(allNumberList);
        this.appendContainer(allNumberList);
        Map numberFieldListMap = allNumberList.stream().collect(Collectors.groupingBy(Function.identity()));
        Set numberSet = numberFieldListMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (numberSet == null || numberSet.isEmpty()) {
            return;
        }
        String numberStr = StringUtils.join(numberSet, (String)",");
        this.metadataGenResult.setSuccess(false);
        this.metadataGenResult.setErrorCode(1000);
        this.metadataGenResult.getMsgList().add("field or container has repeat, number is " + numberStr);
    }

    private void appendContainer(List<String> allNumberList) {
        Optional.ofNullable(this.metadataGenParam.getContainerParamList()).ifPresent(containerParamList -> containerParamList.stream().map(containerParam -> containerParam.getNumber()).forEach(number -> allNumberList.add((String)number)));
    }

    private void appendEntryField(List<String> allNumberList) {
        if (this.metadataGenParam.getEntryParamList() == null) {
            return;
        }
        for (EntryParam entryParam : this.metadataGenParam.getEntryParamList()) {
            Optional.ofNullable(entryParam.getFieldParamList()).ifPresent(fieldParamList -> fieldParamList.stream().map(NodeParam::getNumber).forEach(number -> allNumberList.add((String)number)));
        }
    }
}

