/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.rule.bo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.rule.bo.InputValueArrayMatcherBo;
import kd.hdtc.hrdbs.business.domain.rule.bo.InputValueMapMatcherBo;
import kd.hdtc.hrdbs.business.domain.rule.bo.MatchValueBo;
import kd.hdtc.hrdbs.common.util.StringUtils;

public abstract class AbstractInputValueMatcherBo {
    private static final Log LOG = LogFactory.getLog(InputValueArrayMatcherBo.class);
    private String matchKey;
    private MatchValueBo matchValueBo;
    private Object inputValueObject;

    public AbstractInputValueMatcherBo(String matchKey, Object inputValueObject, MatchValueBo matchValueBo) {
        this.matchKey = matchKey;
        this.inputValueObject = inputValueObject;
        this.matchValueBo = matchValueBo;
    }

    protected boolean matchValue(List<String> splitList) {
        String currentKey = splitList.get(0);
        String remainKey = splitList.get(1);
        Object obj = this.parseValue(currentKey);
        return this.matchValue(remainKey, obj);
    }

    protected boolean matchValue(String remainKey, Object obj) {
        if (obj instanceof List) {
            return new InputValueArrayMatcherBo(remainKey, (List)obj, this.matchValueBo).parse();
        }
        if (obj instanceof Map) {
            return new InputValueMapMatcherBo(remainKey, (LinkedHashMap)obj, this.matchValueBo).match();
        }
        if (StringUtils.isEmpty((String)remainKey)) {
            return this.matchValueBo.match(obj);
        }
        return false;
    }

    protected abstract Object parseValue(String var1);

    public String getMatchKey() {
        return this.matchKey;
    }

    public Object getInputValueObject() {
        return this.inputValueObject;
    }

    public MatchValueBo getMatchValueBo() {
        return this.matchValueBo;
    }
}

