/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.rule.bo;

import java.util.List;
import kd.hdtc.hrdbs.common.enums.MatchWayEnum;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class MatchValueBo {
    private Object matchValue;
    private MatchWayEnum matchWayEnum;

    public MatchValueBo(Object matchValue, String code) {
        this.matchValue = matchValue;
        this.matchWayEnum = StringUtils.isEmpty((String)code) ? MatchWayEnum.EQUAL : MatchWayEnum.getMathWay((String)code);
    }

    public boolean match(Object value) {
        switch (this.matchWayEnum) {
            case EQUAL: {
                return this.equal(value);
            }
            case SIZE_MORE_THAN: {
                return this.sizeMoreThan(value);
            }
            case CONTAINS: {
                return this.contains(value);
            }
        }
        return false;
    }

    private boolean contains(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String valueStr = (String)value;
        if (this.matchValue instanceof String) {
            return ((String)this.matchValue).contains(valueStr);
        }
        if (this.matchValue instanceof List) {
            return ((List)this.matchValue).stream().anyMatch(str -> str.equals(valueStr));
        }
        return false;
    }

    private boolean sizeMoreThan(Object value) {
        int matchValueInt = Integer.parseInt(this.matchValue.toString());
        if (value == null) {
            return false;
        }
        if (value instanceof List) {
            return ((List)value).size() > matchValueInt;
        }
        return false;
    }

    private boolean equal(Object inputValue) {
        if (this.matchValue == null && inputValue == null) {
            return true;
        }
        if (this.matchValue != null) {
            return this.matchValue.equals(inputValue);
        }
        return false;
    }
}

