/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.rule.bo;

import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.rule.bo.InputValueMapMatcherBo;
import kd.hdtc.hrdbs.business.domain.rule.bo.MatchValueBo;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleParseBo {
    private static final Log LOG = LogFactory.getLog(RuleParseBo.class);
    private String input;
    private LinkedHashMap<Object, Object> inputMap;
    private String rule;
    private List<LinkedHashMap<String, Object>> ruleMapList;

    public RuleParseBo(String input, String rule) {
        this.input = input;
        this.rule = rule;
    }

    public boolean match() {
        try {
            if (StringUtils.isEmpty((CharSequence)this.rule) || StringUtils.isEmpty((CharSequence)this.input)) {
                return false;
            }
            this.inputMap = (LinkedHashMap)JsonUtils.cast((String)this.input, LinkedHashMap.class);
            this.ruleMapList = (List)JsonUtils.cast((String)this.rule, List.class);
            if (CollectionUtils.isEmpty(this.ruleMapList)) {
                return false;
            }
            return this.ruleMapList.stream().allMatch(ruleMap -> this.judgeMatch((LinkedHashMap<String, Object>)ruleMap));
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            throw new HRDBSBizException("rule parse error" + ex.getMessage());
        }
    }

    private boolean judgeMatch(LinkedHashMap<String, Object> ruleMap) {
        String conditionKey = (String)ruleMap.get("key");
        Object value = ruleMap.get("value");
        String matchWayCode = (String)ruleMap.get("matchWay");
        return new InputValueMapMatcherBo(conditionKey, this.inputMap, new MatchValueBo(value, matchWayCode)).match();
    }
}

