/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.entity.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.business.entity.IBaseCommonDomainService;
import kd.hdtc.hrdbs.business.servicehelper.AdaptorMetadataCacheHelper;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisInitReturnBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class BaseCommonDomainServiceImpl
implements IBaseCommonDomainService {
    private static final Log LOG = LogFactory.getLog(BaseCommonDomainServiceImpl.class);

    @Override
    public DynamicObject queryOneById(String entityNumber, String selectProperties, Object id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        return hrBaseServiceHelper.queryOne(id);
    }

    @Override
    public DynamicObject[] queryByFilter(String entityNumber, String selectProperties, QFilter[] qFilters) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        return hrBaseServiceHelper.query(selectProperties, qFilters);
    }

    @Override
    public int count(String entityNumber, QFilter[] qFilters) {
        return HRBaseServiceHelper.create((String)entityNumber).count(entityNumber, qFilters);
    }

    @Override
    public List<DynamicObject> loadBaseDataFromDBWithRefProp(String uniqueField, String entityType, Set<String> fieldValSet, String fieldName, String entityCode) {
        IDataEntityProperty property = MetadataServiceHelper.getDataEntityType((String)entityCode).findProperty(fieldName);
        IDataEntityType relField = null;
        relField = property instanceof BasedataProp ? ((BasedataProp)property).getComplexType() : ((MulBasedataProp)property).getComplexType();
        String relFieldStr = relField.toString();
        String searchField = relFieldStr.substring(relFieldStr.indexOf(91) + 1, relFieldStr.lastIndexOf(93));
        return this.loadBaseDataFromDB(uniqueField, entityType, fieldValSet, fieldName, entityCode, searchField + ",id");
    }

    @Override
    public List<DynamicObject> loadBaseDataFromDB(String uniqueField, String entityType, Set<String> fieldValSet, String fieldName, String entityCode, String selectedProperties) {
        if (StringUtils.isEmpty((String)uniqueField) || !"id".equals(uniqueField)) {
            return this.loadBaseDataFromDB(entityType, fieldValSet, fieldName, entityCode, selectedProperties);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
        QFilter searchFilter = new QFilter(uniqueField, "in", fieldValSet);
        Object[] dys = serviceHelper.query(selectedProperties, BaseCommonDomainServiceImpl.buildHisQFilter(entityCode, fieldName, entityType, searchFilter).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])dys);
    }

    @Override
    public List<DynamicObject> loadBaseDataFromDB(String entityType, Set<String> fieldValSet, String fieldName, String entityCode, String selectedProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
        String numberFieldName = AdaptorMetadataCacheHelper.getEntityNumberFieldName(entityType);
        String nameFieldName = AdaptorMetadataCacheHelper.getEntityNameFieldName(entityType);
        if (StringUtils.isEmpty((String)numberFieldName) && StringUtils.isEmpty((String)nameFieldName)) {
            return new ArrayList<DynamicObject>();
        }
        QFilter searchFilter = StringUtils.isNotEmpty((String)numberFieldName) ? new QFilter(numberFieldName, "in", fieldValSet) : new QFilter(nameFieldName, "in", fieldValSet);
        Object[] dys = serviceHelper.query(selectedProperties, BaseCommonDomainServiceImpl.buildHisQFilter(entityCode, fieldName, entityType, searchFilter).toArray());
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])dys);
    }

    @Override
    public List<DynamicObject> query(String midTableNumber, String selectedProperties, Set<Long> idSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(midTableNumber);
        Object[] dys = serviceHelper.query(selectedProperties, new QFilter("id", "in", idSet).toArray());
        if (dys == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])dys);
    }

    @Override
    public void save(List<DynamicObject> midDyList) {
        HRBaseServiceHelper.create((String)"").save(midDyList.toArray(new DynamicObject[0]));
    }

    @Override
    public DynamicObject generateEmptyDynamicObject(String entityNumber) {
        return new HRBaseServiceHelper(entityNumber).generateEmptyDynamicObject();
    }

    private static QFilter buildHisQFilter(String entityCode, String fieldName, String entityType, QFilter defaultQFilter) {
        try {
            HisInitReturnBo hisInitReturnBo = HisModelController.getInstance().buildImportFilter(entityCode, fieldName, entityType);
            if (Objects.nonNull(hisInitReturnBo) && Objects.nonNull(hisInitReturnBo.getqFilter())) {
                LOG.info("importbo filter, {}", (Object)hisInitReturnBo.getqFilter());
                return defaultQFilter.and(hisInitReturnBo.getqFilter());
            }
        }
        catch (Exception ex) {
            LOG.error("his error", (Throwable)ex);
        }
        return defaultQFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult executeOperate(String operationKey, String entityNumber, List<DynamicObject> params) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])params.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence[])new CharSequence[]{operationResult.getMessage()}) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u8c03\u7528op\u5931\u8d25", (String)"BaseCommonDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    @Override
    public DynamicObject[] queryPageCollection(String entityNumber, String selectProperties, QFilter[] qFilters, int pageIndex, int pageSize) {
        return BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])qFilters, (String)"id", (int)pageIndex, (int)pageSize);
    }
}

