/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.handle;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Splitter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.InteTimeZone;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseCommonDomainService;
import kd.hdtc.hrdbs.business.handle.IMapHandle;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractMapHandle
implements IMapHandle {
    protected static final Log LOG = LogFactory.getLog(AbstractMapHandle.class);
    protected final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    protected String entityCode;
    protected String businessKey;
    protected MainEntityType dataEntityType;
    protected List<Map<String, Object>> currHandleBatchData;
    protected Set<String> entityOnlyKeySet;
    protected Map<String, List<DynamicObject>> baseDataMap = new HashMap<String, List<DynamicObject>>();
    protected List<DynamicObject> entityDycList = new ArrayList<DynamicObject>();

    public AbstractMapHandle(String entityCode, String businessKey, MainEntityType dataEntityType) {
        this.entityCode = entityCode;
        this.businessKey = businessKey;
        this.dataEntityType = dataEntityType;
        this.entityOnlyKeySet = Splitter.on((String)"|").trimResults().omitEmptyStrings().splitToStream((CharSequence)businessKey).collect(Collectors.toSet());
    }

    @Override
    public List<DynamicObject> handleData(List<Map<String, Object>> dys) {
        this.init();
        this.currHandleBatchData = dys;
        this.loadBasedata();
        this.structBizEntity();
        if (CollectionUtils.isEmpty(this.entityDycList)) {
            return new ArrayList<DynamicObject>();
        }
        return this.entityDycList;
    }

    protected abstract void init();

    protected abstract void structBizEntity();

    protected abstract void loadBasedata();

    protected void baseDataMapSetVal(Set<String> fieldValSet, String entityType, String fieldName, String belongEntityCode) {
        if (this.isEmptyFieldValSet(fieldValSet)) {
            return;
        }
        List<DynamicObject> dys = this.baseDataMap.get(entityType);
        if (!CollectionUtils.isEmpty(dys)) {
            dys.addAll(this.iBaseCommonDomainService.loadBaseDataFromDBWithRefProp(this.businessKey, entityType, fieldValSet, fieldName, belongEntityCode));
            Map<Long, DynamicObject> dycMap = dys.stream().collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc, (k1, k2) -> k1));
            this.baseDataMap.put(entityType, new ArrayList<DynamicObject>(dycMap.values()));
        } else {
            this.baseDataMap.put(entityType, this.iBaseCommonDomainService.loadBaseDataFromDBWithRefProp(this.businessKey, entityType, fieldValSet, fieldName, belongEntityCode));
        }
    }

    private boolean isEmptyFieldValSet(Set<String> fieldValSet) {
        for (String fieldVal : fieldValSet) {
            if (!StringUtils.isNotEmpty((String)fieldVal)) continue;
            return false;
        }
        return true;
    }

    protected void distributeMainEntity(Map<String, Object> dy, Map<String, List<Map<String, Object>>> midTblDataMap) {
        StringBuilder sb = new StringBuilder();
        this.entityOnlyKeySet.forEach(it -> sb.append(dy.get(it)).append('|'));
        String key = sb.toString();
        if (!midTblDataMap.containsKey(key)) {
            midTblDataMap.put(key, new ArrayList());
        }
        midTblDataMap.get(key).add(dy);
    }

    protected void valueConvert(Map<String, Object> midDyc, DynamicObject bizDyc, IDataEntityProperty property) {
        String midDycFieldVal;
        String propName = this.entityField2MidTblField(property);
        String string = midDycFieldVal = midDyc.get(propName) == null ? "" : midDyc.get(propName) + "";
        if (property instanceof BasedataProp) {
            if (HRStringUtils.isNotEmpty((String)midDycFieldVal)) {
                this.baseDataHandle(bizDyc, midDycFieldVal, this.baseDataMap.get(((BasedataProp)property).getBaseEntityId()), propName);
            } else {
                bizDyc.set(property.getName(), null);
            }
        } else if (property instanceof MulBasedataProp) {
            if (HRStringUtils.isNotEmpty((String)midDycFieldVal)) {
                this.mulBaseDataHandle(bizDyc, (JSONArray)midDyc.get(propName), this.baseDataMap.get(((MulBasedataProp)property).getBaseEntityId()), propName);
            }
        } else if (property instanceof DateTimeProp) {
            Date date = this.parseDateValue(property, midDyc.get(propName));
            bizDyc.set(property.getName(), (Object)date);
        } else if (property instanceof MuliLangTextProp) {
            Object value = midDyc.get(propName);
            bizDyc.set(property.getName(), (Object)(value == null ? "" : LocaleString.fromMap((Map)((Map)midDyc.get(propName)))));
        } else {
            bizDyc.set(property.getName(), midDyc.get(propName));
        }
    }

    private Date parseDateValue(IDataEntityProperty prop, Object timeValue) {
        Date startTime;
        if (timeValue == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String[] timeValues = timeValue.toString().split(":");
            SimpleDateFormat dateFormat = timeValues.length > 3 && timeValues[timeValues.length - 1].length() > 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS") : simpleDateFormat;
            dateFormat.setLenient(false);
            startTime = InteTimeZone.getSysTimeZone().parse(timeValue.toString(), (DateFormat)dateFormat);
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd HH:mm:ss \u6216 yyyy-MM-dd HH:mm:ss:SSS", (String)"MidTableDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]), prop.getName(), timeValue);
            throw new HRDBSBizException(errMsg);
        }
        return startTime;
    }

    protected void baseDataHandle(DynamicObject bizDyc, String dycFieldVal, List<DynamicObject> dys, String propName) {
        if (CollectionUtils.isEmpty(dys)) {
            return;
        }
        DataEntityPropertyCollection bizDycProperties = bizDyc.getDynamicObjectType().getProperties();
        for (DynamicObject dyc : dys) {
            if (!HRStringUtils.equals((String)dycFieldVal, (String)dyc.getString(this.businessKey))) continue;
            if (!bizDycProperties.containsKey((Object)propName)) {
                bizDyc.set(propName, (Object)dyc);
                return;
            }
            bizDyc.set(propName, (Object)dyc);
            return;
        }
    }

    protected void mulBaseDataHandle(DynamicObject bizDyc, JSONArray fieldValList, List<DynamicObject> dys, String propName) {
        DynamicObjectCollection docs = bizDyc.getDynamicObjectCollection(propName);
        fieldValList.forEach(val -> {
            for (DynamicObject dyc : dys) {
                if (!HRStringUtils.equals((String)val.toString(), (String)dyc.getString(this.businessKey))) continue;
                DynamicObject dy = new DynamicObject(docs.getDynamicObjectType());
                dy.set("fbasedataid", (Object)dyc);
                docs.add((Object)dy);
                break;
            }
        });
        DataEntityPropertyCollection bizDycProperties = bizDyc.getDynamicObjectType().getProperties();
        if (!bizDycProperties.containsKey((Object)propName)) {
            bizDyc.set(propName, (Object)docs);
            return;
        }
        bizDyc.set(propName, (Object)docs);
    }

    protected void handleBaseDataOrMulBaseData(List<Map<String, Object>> paramMapList, Map<String, IDataEntityProperty> entityFieldMap, String fieldName, IDataEntityProperty prop) {
        String belongEntityCode = this.getBelongEntityCode(prop);
        HashSet<String> fieldValSet = new HashSet<String>();
        if (prop instanceof BasedataProp) {
            paramMapList.stream().map(dyc -> dyc.get(fieldName) == null ? "" : dyc.get(fieldName) + "").filter(HRStringUtils::isNotEmpty).forEach(fieldValSet::add);
            String entityType = ((BasedataProp)entityFieldMap.get(fieldName)).getBaseEntityId();
            this.baseDataMapSetVal(fieldValSet, entityType, fieldName, belongEntityCode);
        } else if (prop instanceof MulBasedataProp) {
            paramMapList.forEach(dyc -> {
                Object values = dyc.get(fieldName);
                if (values != null) {
                    ((JSONArray)values).forEach(value -> fieldValSet.add(value.toString()));
                }
            });
            String entityType = ((MulBasedataProp)entityFieldMap.get(fieldName)).getBaseEntityId();
            this.baseDataMapSetVal(fieldValSet, entityType, fieldName, belongEntityCode);
        }
    }

    protected abstract String getBelongEntityCode(IDataEntityProperty var1);

    private String entityField2MidTblField(IDataEntityProperty property) {
        return property.getName();
    }
}

