/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.handle;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.util.CollectionUtils;
import kd.hdtc.hrdbs.business.handle.AbstractMapHandle;

public class MapHandleEntity
extends AbstractMapHandle {
    private Map<String, IDataEntityProperty> billHeadFieldMap = new HashMap<String, IDataEntityProperty>();
    private Map<String, Map<String, IDataEntityProperty>> billEntryFieldMap = new HashMap<String, Map<String, IDataEntityProperty>>();

    public MapHandleEntity(String entityCode, String businessKey, MainEntityType dataEntityType) {
        super(entityCode, businessKey, dataEntityType);
    }

    @Override
    protected void init() {
        this.handleBill();
        this.setNumberList();
    }

    @Override
    protected void loadBasedata() {
        LOG.info("MidTblOpHandleEntity loadBasedata start.");
        this.loadBasedata(this.currHandleBatchData, this.billHeadFieldMap);
        if (ObjectUtils.isEmpty(this.billEntryFieldMap)) {
            return;
        }
        this.billEntryFieldMap.forEach((key, value) -> this.currHandleBatchData.forEach(paramMap -> {
            List paramMapList = (List)paramMap.get(key);
            if (paramMapList != null) {
                this.loadBasedata(paramMapList, (Map<String, IDataEntityProperty>)value);
            }
        }));
    }

    private void loadBasedata(List<Map<String, Object>> paramMapList, Map<String, IDataEntityProperty> billFieldMap) {
        billFieldMap.forEach((fieldName, prop) -> this.handleBaseDataOrMulBaseData(paramMapList, billFieldMap, (String)fieldName, (IDataEntityProperty)prop));
    }

    @Override
    protected String getBelongEntityCode(IDataEntityProperty prop) {
        return this.entityCode;
    }

    @Override
    protected void structBizEntity() {
        LOG.info("MidTblOpHandleEntity structBizEntity start.");
        HashMap midTblDataMap = Maps.newHashMap();
        this.currHandleBatchData.forEach(dy -> this.distributeMainEntity((Map<String, Object>)dy, midTblDataMap));
        for (Map it : this.currHandleBatchData) {
            DynamicObject bizDyc = this.iBaseCommonDomainService.generateEmptyDynamicObject(this.entityCode);
            this.billHeadFieldMap.forEach((field, entityProperty) -> this.valueConvert(it, bizDyc, (IDataEntityProperty)entityProperty));
            if (!CollectionUtils.isEmpty(this.billEntryFieldMap)) {
                this.billEntryFieldMap.forEach((key, entryFieldMap) -> {
                    DynamicObjectCollection docs = bizDyc.getDynamicObjectCollection(key);
                    docs.clear();
                    List entryArray = (List)it.get(key);
                    if (entryArray != null) {
                        entryArray.forEach(entryObj -> {
                            DynamicObject entryEntity = docs.addNew();
                            entryFieldMap.forEach((entryField, entryFieldProperty) -> this.valueConvert((Map<String, Object>)entryObj, entryEntity, (IDataEntityProperty)entryFieldProperty));
                        });
                    }
                });
            }
            this.entityDycList.add(bizDyc);
        }
    }

    private void setNumberList() {
    }

    private void handleBill() {
        LOG.info("MidTblOpHandleEntity handleBill start.");
        this.billHeadFieldMap = this.dataEntityType.getProperties().stream().collect(Collectors.toMap(IMetadata::getName, pro -> pro));
        this.billHeadFieldMap.remove("multilanguagetext");
        this.dataEntityType.getProperties().forEach(dy -> {
            if (dy instanceof BasedataProp) {
                this.billHeadFieldMap.remove(dy.getName() + "_id");
            }
        });
        List<IDataEntityProperty> entryPropList = this.billHeadFieldMap.values().stream().filter(pro -> pro instanceof EntryProp).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entryPropList)) {
            return;
        }
        entryPropList.forEach(entryProp -> {
            HashMap entryPropFieldMap = new HashMap(16);
            ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties().forEach(pro -> entryPropFieldMap.put(pro.getName(), pro));
            entryPropFieldMap.remove("multilanguagetext");
            ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties().forEach(dy -> {
                if (dy instanceof BasedataProp) {
                    entryPropFieldMap.remove(dy.getName() + "_id");
                }
            });
            this.billEntryFieldMap.put(entryProp.getName(), entryPropFieldMap);
            this.billHeadFieldMap.remove(entryProp.getName());
        });
    }
}

