/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.util.StringUtils;
import kd.hdtc.hrdbs.business.model.MetaDataConfigBo;
import kd.hdtc.hrdbs.business.model.MultiSubEntryDecodeBo;
import kd.hdtc.hrdbs.business.model.MultiTableDecodeBo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class MultiEntryDecodeBo
extends MultiTableDecodeBo {
    public MultiEntryDecodeBo(List<MetaDataConfigBo> metaDataConfigs) {
        super(metaDataConfigs);
    }

    @Override
    public void addMetaData(MetaDataConfigBo metaDataConfig) {
        this.addEntryMeta(metaDataConfig, new EntryProp());
    }

    public void addMetaDataOnlyWithFilter(MetaDataConfigBo metaDataConfig, Map<String, String> entryQFilter) {
        this.addEntryMetaWithFilter(metaDataConfig, new EntryProp(), entryQFilter);
    }

    protected <T extends EntryProp> void addEntryMeta(MetaDataConfigBo mainMetaDaya, T tmp) {
        List<T> entryPropList = super.getMultiTableProp(mainMetaDaya, tmp);
        for (T entryProp : entryPropList) {
            String tableName = entryProp.getDynamicCollectionItemPropertyType().getAlias();
            if (StringUtils.isEmpty((String)tableName)) continue;
            List<IDataEntityProperty> list = this.addProp(mainMetaDaya, entryProp);
            MetaDataConfigBo metaDataConfig = this.getMetaDataConfig(mainMetaDaya, list, entryProp);
            this.addReference(mainMetaDaya, metaDataConfig);
            super.addReference(mainMetaDaya, metaDataConfig);
            MultiTableDecodeBo.addMetaDataConfig(metaDataConfig, this.metaList, null);
            super.parseMainMetaData(metaDataConfig);
            if (!this.isContainMulTab(metaDataConfig, new SubEntryProp(), false)) continue;
            new MultiSubEntryDecodeBo(this.metaList).addMetaData(metaDataConfig);
        }
    }

    protected <T extends EntryProp> void addEntryMetaWithFilter(MetaDataConfigBo mainMetaDaya, T tmp, Map<String, String> entryQFilter) {
        List<T> entryPropList = super.getMultiTableProp(mainMetaDaya, tmp);
        for (T entryProp : entryPropList) {
            String tableName = entryProp.getDynamicCollectionItemPropertyType().getAlias();
            if (StringUtils.isEmpty((String)tableName)) continue;
            List<IDataEntityProperty> list = this.addProp(mainMetaDaya, entryProp);
            MetaDataConfigBo metaDataConfig = this.getMetaDataConfig(mainMetaDaya, list, entryProp);
            if (CollectionUtils.isNotEmpty(entryQFilter)) {
                String where = entryQFilter.get(entryProp.getName());
                if (!StringUtils.isNotEmpty((String)where)) continue;
                metaDataConfig.setWhere(where);
            }
            this.addReference(mainMetaDaya, metaDataConfig);
            super.addReference(mainMetaDaya, metaDataConfig);
            MultiTableDecodeBo.addMetaDataConfig(metaDataConfig, this.metaList, null);
            super.parseMainMetaData(metaDataConfig);
            if (!this.isContainMulTab(metaDataConfig, new SubEntryProp(), false)) continue;
            new MultiSubEntryDecodeBo(this.metaList).addMetaDataOnlyWithFilter(metaDataConfig, null);
        }
    }

    private MetaDataConfigBo getMetaDataConfig(MetaDataConfigBo mainMetaData, List<IDataEntityProperty> list, EntryProp entryProp) {
        MetaDataConfigBo meteDataConfig = super.getMetaData(mainMetaData, list);
        meteDataConfig.setDisplayName(entryProp.getDisplayName());
        meteDataConfig.setAlias(super.upperCase(entryProp.getDynamicCollectionItemPropertyType().getAlias()));
        meteDataConfig.setName(super.upperCase(entryProp.getDynamicCollectionItemPropertyType().getName()));
        return meteDataConfig;
    }

    @Override
    protected void addIndex(MetaDataConfigBo mainMeta, MetaDataConfigBo metaDataConfig) {
        List<String> pkNameList = super.getFKProp(mainMeta).stream().filter(Objects::nonNull).map(arg -> this.upperCase(arg.getAlias())).collect(Collectors.toList());
        metaDataConfig.addIndex(pkNameList);
    }

    @Override
    protected <T extends IDataEntityProperty> List<IDataEntityProperty> addProp(MetaDataConfigBo mainMetaData, T arg) {
        ArrayList<PKFieldProp> list = new ArrayList<PKFieldProp>();
        list.addAll((Collection<PKFieldProp>)((EntryProp)arg).getDynamicCollectionItemPropertyType().getProperties());
        list.addAll(super.getFKProp(mainMetaData, this.getPkInfo()));
        return list.stream().filter(MultiEntryDecodeBo.distinctByKey(IMetadata::getName)).collect(Collectors.toList());
    }
}

