/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.servicehelper;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.cache.HRAppCache;

public class CacheServiceHelper {
    private static final Log LOG = LogFactory.getLog(CacheServiceHelper.class);

    public static void putAppCache(String appKey, String cacheKey, Object data) {
        if (StringUtils.isEmpty((String)appKey) || StringUtils.isEmpty((String)cacheKey)) {
            LOG.error("AppKey or CacheKey cannot be empty.");
            throw new HRDBSBizException("AppKey or CacheKey cannot be empty.");
        }
        HRAppCache.get((String)appKey).put(cacheKey, data);
    }

    public static <T> T getAppCache(String appKey, String cacheKey, Class<T> dataType) {
        if (StringUtils.isEmpty((String)appKey) || StringUtils.isEmpty((String)cacheKey)) {
            LOG.error("AppKey or CacheKey cannot be empty.");
            throw new HRDBSBizException("AppKey or CacheKey cannot be empty.");
        }
        return (T)HRAppCache.get((String)appKey).get(cacheKey, dataType);
    }

    public static void removeAppCache(String appKey, String cacheKey) {
        if (StringUtils.isEmpty((String)appKey) || StringUtils.isEmpty((String)cacheKey)) {
            LOG.error("AppKey or CacheKey cannot be empty.");
            throw new HRDBSBizException("AppKey or CacheKey cannot be empty.");
        }
        HRAppCache.get((String)appKey).remove(cacheKey);
    }
}

