/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.formplugin.web;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.StringUtils;

public abstract class AbstractHDTCTreeListPlugin
extends StandardTreeListPlugin {
    private static final Log LOG = LogFactory.getLog(AbstractHDTCTreeListPlugin.class);

    public void initializeTree(EventObject event) {
        TreeNode root = this.loadTreeNode();
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        treeView.focusNode(root);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public void refreshNode(RefreshNodeEvent event) {
        String nodeId = event.getNodeId().toString();
        if (StringUtils.equals((String)this.getRootNodeId(), (String)nodeId)) {
            event.setChildNodes(this.loadTreeNode().getChildren());
        } else {
            TreeNode evtTreeNode = this.getTreeModel().getRoot().getTreeNode(nodeId, 20);
            if (!Objects.isNull(evtTreeNode)) {
                event.setChildNodes(evtTreeNode.getChildren());
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        QFilter filter;
        String nodeId = (String)event.getNodeId();
        if (!StringUtils.isEmpty((String)nodeId) && (filter = this.buildLeftTreeFilter(nodeId)) != null) {
            event.addQFilter(filter);
        }
    }

    protected abstract TreeNode loadTreeNode();

    protected abstract QFilter buildLeftTreeFilter(String var1);

    protected String getRootNodeId() {
        return null;
    }
}

