/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.mservice;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;
import kd.hdtc.hrdi.mservice.IntSourceServiceImpl;
import kd.hr.hbp.business.init.ITransferConfPostMicroService;
import kd.hr.hbp.common.mservice.HRMServiceResult;

public abstract class AbstractTransferConfPostService
implements ITransferConfPostMicroService {
    private static final Log LOG = LogFactory.getLog(IntSourceServiceImpl.class);

    public HRMServiceResult postSync(String entityNumber, Map<Object, String> entityDataIdVsNumMap) {
        LOG.info("postSync param, entityNumber:{}, entityDataIdVsNumMap:{}", (Object)entityNumber, entityDataIdVsNumMap);
        HRMServiceResult serviceResult = new HRMServiceResult();
        if (CollectionUtils.isEmpty(entityDataIdVsNumMap)) {
            return serviceResult;
        }
        String msg = this.checkEnttiy(entityNumber);
        if (StringUtils.isNotEmpty((String)msg)) {
            serviceResult.setSuccess(false);
            serviceResult.setMessage(msg);
            return serviceResult;
        }
        HashSet pkIdSet = Sets.newHashSetWithExpectedSize((int)entityDataIdVsNumMap.size());
        entityDataIdVsNumMap.forEach((id, number) -> pkIdSet.add((Long)id));
        try {
            this.doSync(serviceResult, pkIdSet);
        }
        catch (Exception exception) {
            String errorMsg = ThrowableUtils.toString((Throwable)exception);
            serviceResult.setSuccess(false);
            serviceResult.setMessage(errorMsg);
            LOG.error(errorMsg);
        }
        return serviceResult;
    }

    protected String checkEnttiy(String entityNumber) {
        return null;
    }

    protected void doSync(HRMServiceResult serviceResult, Set<Long> pkIdSet) {
    }
}

