/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.mservice;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBizSyncDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncResultBo;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableDomainService;
import kd.hdtc.hrdi.common.enums.SynTypeEnum;
import kd.hdtc.hrdi.mservice.IIntMidTableService;
import kd.sdk.hdtc.hrdbs.model.ApiResponse;

public class IntMidTableServiceImpl
implements IIntMidTableService {
    private static final Log LOG = LogFactory.getLog(IntMidTableServiceImpl.class);
    private final IMidTableDomainService midTableDomainService = (IMidTableDomainService)ServiceFactory.getService(IMidTableDomainService.class);
    private final IBizSyncDomainService iMidTableConfigEntityService = (IBizSyncDomainService)ServiceFactory.getService(IBizSyncDomainService.class);
    private final IHRDIBaseConfigDomainService configDomainService = (IHRDIBaseConfigDomainService)ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private final int SYNC_DATA_MAX_COUNT = 500;
    private final IIntSourceSysDomainService iIntSourceSysDomainService = (IIntSourceSysDomainService)ServiceFactory.getService(IIntSourceSysDomainService.class);
    private final String SYNC_DATA_EMPTY_ERROR = ResManager.loadKDString((String)"\u96c6\u6210\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntMidTableServiceImpl_3", (String)"hdtc-hrdi-mservice", (Object[])new Object[0]);
    private final String SYNC_DATA_MAX_COUNT_ERROR = ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u96c6\u6210\uff0c\u6bcf\u6b21\u6700\u591a\u652f\u6301500\u6761\u3002", (String)"IntMidTableServiceImpl_0", (String)"hdtc-hrdi-mservice", (Object[])new Object[0]);
    private final String SOURCE_SYSTEM_NOT_EXIST_ERROR = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5916\u90e8\u7cfb\u7edf\u3002", (String)"IntMidTableServiceImpl_2", (String)"hdtc-hrdi-mservice", (Object[])new Object[0]);
    private final String TRANSFER_ERROR = ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u4e2d\u95f4\u8868\u5bf9\u8c61\u5931\u8d25\u3002", (String)"IntMidTableServiceImpl_4", (String)"hdtc-hrdi-mservice", (Object[])new Object[0]);

    public ApiResponse syncMidTableData(String tableNumber, String batchNumber, String sourceSys, List<Map<String, Object>> data) {
        String errorMsg = this.paramValidate(sourceSys, data);
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            return ApiResponse.failed((String)String.valueOf(data.size()), (String)errorMsg);
        }
        this.deleteParamHandle(data, false);
        return this.doSyncMidTableData(tableNumber, batchNumber, sourceSys, data);
    }

    public ApiResponse deleteMidTableData(String tableNumber, String batchNumber, String sourceSys, List<Map<String, Object>> data) {
        String errorMsg = this.paramValidate(sourceSys, data);
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            return ApiResponse.failed((String)String.valueOf(data.size()), (String)errorMsg);
        }
        this.deleteParamHandle(data, true);
        return this.doSyncMidTableData(tableNumber, batchNumber, sourceSys, data);
    }

    private void deleteParamHandle(List<Map<String, Object>> data, boolean defaultDelete) {
        data.forEach(param -> {
            if (!defaultDelete) {
                param.putIfAbsent("is_delete", defaultDelete);
            } else {
                param.put("is_delete", defaultDelete);
            }
        });
    }

    private ApiResponse doSyncMidTableData(String tableNumber, String batchNumber, String sourceSys, List<Map<String, Object>> data) {
        BizDataSyncResultBo resultBo;
        Boolean isSync = Boolean.TRUE;
        if (StringUtils.isEmpty((String)batchNumber)) {
            batchNumber = this.createBatchNumber();
        }
        this.midTableDomainService.syncMidTableValidate(tableNumber, data);
        DynamicObject[] midTableDyns = this.midTableDomainService.transferMidTableDyn(tableNumber, batchNumber, sourceSys, data);
        if (midTableDyns == null) {
            LOG.error("data transfer to MidTableDyn error.");
            return ApiResponse.failed((String)String.valueOf(data.size()), (String)this.TRANSFER_ERROR);
        }
        boolean saveMidTable = this.isSaveMidTable(isSync);
        if (saveMidTable) {
            this.midTableDomainService.saveMidTableData(midTableDyns);
            List midTabelIdList = Arrays.stream(midTableDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            resultBo = this.iMidTableConfigEntityService.bizSync(tableNumber, batchNumber, midTabelIdList, midTableDyns, SynTypeEnum.NEW.getCode());
        } else {
            resultBo = this.iMidTableConfigEntityService.bizSyncWithNoSaveMidTable(tableNumber, batchNumber, midTableDyns, SynTypeEnum.NEW.getCode());
        }
        if (resultBo.getFailCount() == 0) {
            return ApiResponse.success((String)String.valueOf(data.size()));
        }
        return ApiResponse.failed((String)String.valueOf(resultBo.getFailCount()), (String)String.valueOf(resultBo.getSuccessCount()), (Map)resultBo.getErrorMap());
    }

    private String paramValidate(String sourceSys, List<Map<String, Object>> data) {
        if (CollectionUtils.isEmpty(data)) {
            String error = "syncMidTableData error:" + this.SYNC_DATA_EMPTY_ERROR;
            LOG.error(error);
            return this.SYNC_DATA_EMPTY_ERROR;
        }
        if (data.size() > 500) {
            String error = "syncMidTableData error:" + this.SYNC_DATA_MAX_COUNT_ERROR;
            LOG.error(error);
            return this.SYNC_DATA_MAX_COUNT_ERROR;
        }
        if (!this.isSouceSysExist(sourceSys)) {
            String sourceSysErrorInfo = String.format(Locale.ROOT, this.SOURCE_SYSTEM_NOT_EXIST_ERROR, sourceSys);
            String error = "hrdisourcesys is not exist error:" + sourceSysErrorInfo;
            LOG.error(error);
            return sourceSysErrorInfo;
        }
        return null;
    }

    private boolean isSouceSysExist(String sourceSys) {
        DynamicObject sourceSysDyn = this.iIntSourceSysDomainService.queryByNumber(sourceSys);
        return sourceSysDyn != null;
    }

    private boolean isSaveMidTable(Boolean isSync) {
        if (!isSync.booleanValue()) {
            return true;
        }
        String saveMidTable = this.configDomainService.queryBaseConfigValueByNumber("is.save.midtable.data");
        return !"0".equals(saveMidTable);
    }

    private String createBatchNumber() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            return dateFormat.format(new Date()) + secureRandom.nextInt(9999);
        }
        catch (NoSuchAlgorithmException exception) {
            LOG.error((Throwable)exception);
            return dateFormat.format(new Date());
        }
    }
}

