/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.common.adaptor.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class EntityFieldToComboItemUtil {
    public static List<ComboItem> getEntityItems(String entityId, boolean containEntity) {
        Map entityItemsMap = MetadataUtils.getMultiEntityFieldItems((String)entityId);
        if (CollectionUtils.isEmpty((Map)entityItemsMap)) {
            return new ArrayList<ComboItem>();
        }
        boolean multiEntity = entityItemsMap.size() > 1;
        LinkedHashMap<String, String> fieldCodeNameMap = new LinkedHashMap<String, String>();
        for (Map.Entry next : entityItemsMap.entrySet()) {
            EntityMetadata entityMetadata = (EntityMetadata)next.getKey();
            List items = (List)next.getValue();
            String entityCode = entityMetadata.getKey();
            String entityName = entityMetadata.getName().getLocaleValue();
            for (EntityItem item : items) {
                String fieldCode = containEntity ? entityCode + "." + item.getKey() : item.getKey();
                String fieldName = item.getName().getLocaleValue();
                if (multiEntity) {
                    fieldName = entityName + "." + fieldName;
                }
                fieldCodeNameMap.put(fieldCode, fieldName);
            }
        }
        return EntityFieldToComboItemUtil.mapToComboItem(fieldCodeNameMap);
    }

    private static List<ComboItem> mapToComboItem(Map<String, String> fieldCodeNameMap) {
        if (fieldCodeNameMap == null) {
            return null;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(fieldCodeNameMap.size());
        for (Map.Entry<String, String> next : fieldCodeNameMap.entrySet()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(next.getValue()));
            comboItem.setValue(next.getKey());
            comboItems.add(comboItem);
        }
        return comboItems;
    }
}

