/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.entity.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdi.business.application.external.entity.IBizAppEntityService;

public class BizAppEntityServiceImpl
extends AbstractBaseEntityService
implements IBizAppEntityService {
    public BizAppEntityServiceImpl() {
        super("bos_devportal_bizapp");
    }

    @Override
    public List<String> getHrAppIdsWithoutHDTC(List<String> cloudIdList) {
        DynamicObject[] appDyns = this.getHrAppDynList(null, cloudIdList);
        return Arrays.stream(appDyns).map(appDyn -> appDyn.getString("id")).collect(Collectors.toList());
    }

    @Override
    public DynamicObject[] getHrAppDynList(List<String> appIdList, List<String> cloudIdList) {
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)2);
        if (appIdList != null) {
            QFilter appIdFilter = new QFilter("id", "in", appIdList);
            filterList.add(appIdFilter);
        }
        if (cloudIdList != null) {
            QFilter hdtcFilter = new QFilter("bizcloud", "in", cloudIdList);
            filterList.add(hdtcFilter);
        }
        Map cacheAppDynMap = this.getMapFromCache("id,name,bizcloud", filterList.toArray(new QFilter[0]));
        DynamicObject[] hrApps = new DynamicObject[cacheAppDynMap.size()];
        AtomicInteger index = new AtomicInteger();
        cacheAppDynMap.forEach((key, val) -> {
            hrApps[index.getAndIncrement()] = val;
        });
        return hrApps;
    }
}

