/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.entity.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.entity.IPersonEntityService;
import kd.hdtc.hrdi.common.pojo.FourFloorPersonIdEntry;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class PersonEntityServiceImpl
extends AbstractBaseEntityService
implements IPersonEntityService {
    private static final Log LOG = LogFactory.getLog(PersonEntityServiceImpl.class);
    private static final String SELECT_PROPERTIES = String.join((CharSequence)",", "id", "name", "number", "headsculpture");
    private static final Set<Long> MAIN_FILE_TYPE = ImmutableSet.of((Object)1010L, (Object)1050L, (Object)1070L, (Object)1090L, (Object)1110L);

    public PersonEntityServiceImpl() {
        super("hrpi_person");
    }

    @Override
    public Map<String, Object> addNewPerson(List<Map<String, Object>> personParamList) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIApplyService", (String)"addEmployee", (Object[])new Object[]{personParamList, "integration"});
        return result;
    }

    @Override
    public Map<String, Object> savePersonInfo(List<Map<String, Object>> personInfoParamList) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIApplyService", (String)"savePersonInfo", (Object[])new Object[]{personInfoParamList, "integration"});
        return result;
    }

    @Override
    public Map<String, Object> saveEmpentrels(List<Map<String, Object>> empentrelsParamList) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIApplyService", (String)"saveEmpentrels", (Object[])new Object[]{empentrelsParamList, "integration"});
        return result;
    }

    @Override
    public Map<String, Object> saveEmpOrgrels(List<Map<String, Object>> empOrgrelsParamList) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIApplyService", (String)"saveEmpOrgrels", (Object[])new Object[]{empOrgrelsParamList, "integration"});
        return result;
    }

    @Override
    public List<FourFloorPersonIdEntry> getFourFloorPersonModelsWithFilter(String entityNumber, List<Long> boidList, QFilter filter) {
        if (filter == null) {
            return null;
        }
        filter.and(QFilterConstants.Q_CURRENTVERSION).and(QFilterConstants.Q_HISDATASTATUS).and(QFilterConstants.Q_INITSTATUS);
        DynamicObject[] personFileDyns = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"getErManFile", (Object[])new Object[]{entityNumber, boidList, filter});
        return this.buildFourFloorPersonModels(personFileDyns);
    }

    @Override
    public List<FourFloorPersonIdEntry> getMainFileFourFloorPersonModels(String entityNumber, List<Long> boidList) {
        if (CollectionUtils.isEmpty(boidList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        QFilter bizStatusFilter = new QFilter("businessstatus", "=", (Object)"1");
        bizStatusFilter.and("filetype.erfiletypeassign", "in", MAIN_FILE_TYPE);
        bizStatusFilter.and(QFilterConstants.Q_CURRENTVERSION).and(QFilterConstants.Q_HISDATASTATUS).and(QFilterConstants.Q_INITSTATUS);
        DynamicObject[] personFileDyns = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"getErManFile", (Object[])new Object[]{entityNumber, boidList, bizStatusFilter});
        return this.buildFourFloorPersonModels(personFileDyns);
    }

    private List<FourFloorPersonIdEntry> buildFourFloorPersonModels(DynamicObject[] personFileDyns) {
        ArrayList resultList;
        if (personFileDyns == null) {
            resultList = Lists.newArrayListWithCapacity((int)1);
            resultList.add(new FourFloorPersonIdEntry(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L)));
        } else {
            resultList = Lists.newArrayListWithCapacity((int)personFileDyns.length);
            for (DynamicObject personFileDyn : personFileDyns) {
                FourFloorPersonIdEntry fourFloorPerson = new FourFloorPersonIdEntry();
                fourFloorPerson.setPersonId(Long.valueOf(personFileDyn.getLong("person_id")));
                fourFloorPerson.setEmployeeId(Long.valueOf(personFileDyn.getLong("employee_id")));
                fourFloorPerson.setCmpempId(Long.valueOf(personFileDyn.getLong("cmpemp_id")));
                fourFloorPerson.setDepempId(Long.valueOf(personFileDyn.getLong("depemp_id")));
                resultList.add(fourFloorPerson);
            }
        }
        return resultList;
    }

    @Override
    public Map<Long, DynamicObject> queryListByPersonId(Set<Long> personIdSet) {
        if (CollectionUtils.isEmpty(personIdSet)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        QFilter idFilter = new QFilter("id", "in", personIdSet);
        Object[] dynamicObjects = this.query(SELECT_PROPERTIES, new QFilter[]{idFilter, QFilterConstants.Q_CURRENTVERSION});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dd -> dd.getLong("id"), Function.identity()));
    }

    @Override
    public Map<String, Boolean> checkEmployeeStatus(List<Object> numberList) {
        if (CollectionUtils.isEmpty(numberList)) {
            return new HashMap<String, Boolean>(16);
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"checkEmployeeStatus", (Object[])new Object[]{numberList, "EMPNUMBER"});
    }

    @Override
    public List<FourFloorPersonIdEntry> listFieldsFilterInfo(String entityNumber, List<Long> idList) {
        if (CollectionUtils.isEmpty(idList) || StringUtils.isEmpty((String)entityNumber)) {
            return new ArrayList<FourFloorPersonIdEntry>();
        }
        QFilter qFilter = new QFilter("id", "in", idList);
        DynamicObject[] personFileDys = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{"person", qFilter, entityNumber});
        List<Long> personIdList = Stream.of(personFileDys).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        return this.getMainFileFourFloorPersonModels("person", personIdList);
    }

    @Override
    public Map<String, Long> getPersonInfoByCert(Map<String, Object> certInfoMap) {
        Map serviceResultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfoByCert", (Object[])new Object[]{certInfoMap});
        LOG.info("getPersonInfoByCert result:{}", (Object)serviceResultMap);
        List dataList = (List)serviceResultMap.get("data");
        HashMap<String, Long> resultMap = new HashMap<String, Long>(16);
        dataList.forEach(dataMap -> {
            String number = (String)dataMap.get("number");
            Long credentialstypeId = (Long)dataMap.get("credentialstype_id");
            Map person = (Map)dataMap.get("hrpi_person");
            resultMap.put(number + credentialstypeId, (Long)person.get("id"));
        });
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> getDepempInfo(List<Long> depempIds) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"listDataEmpOrgrels", (Object[])new Object[]{depempIds});
    }
}

