/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hdtc.hrdi.business.application.external.IBizAppDomainService;
import kd.hdtc.hrdi.business.application.external.entity.IBizAppEntityService;
import kd.hdtc.hrdi.business.application.external.entity.IHBSSCloudEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;

public class BizAppDomainServiceImpl
implements IBizAppDomainService {
    private final IBizAppEntityService bizAppEntityService = ServiceFactory.getService(IBizAppEntityService.class);
    private final IHBSSCloudEntityService cloudEntityService = ServiceFactory.getService(IHBSSCloudEntityService.class);

    @Override
    public List<String> getHrAppIdsWithoutHDTC() {
        return this.bizAppEntityService.getHrAppIdsWithoutHDTC(this.getHrCloudIdsWithoutHDTC());
    }

    @Override
    public List<String> getHrCloudIdsWithoutHDTC() {
        List<String> hrCloudIdList = this.cloudEntityService.queryHRCloudId();
        hrCloudIdList.remove("33ZTI5A4PW59");
        return hrCloudIdList;
    }

    @Override
    public DynamicObject getBizApp(String entityNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)entityNumber);
        return BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"bizappid", (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public Map<String, Object> getBizAppId(Set<String> entityNumberSet) {
        QFilter qFilter = new QFilter("number", "in", entityNumberSet);
        DynamicObject[] bizApps = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"number,bizappid", (QFilter[])new QFilter[]{qFilter});
        return Arrays.stream(bizApps).collect(Collectors.toMap(it -> it.getString("number"), it -> it.get("bizappid")));
    }
}

