/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.hdtc.hrdi.business.application.external.IBizAppTreeDomainService;
import kd.hdtc.hrdi.business.application.external.entity.IBizAppEntityService;
import kd.hdtc.hrdi.business.application.external.entity.IHBSSCloudEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;

public class BizAppTreeDomainServiceImpl
implements IBizAppTreeDomainService {
    private final IBizAppEntityService bizAppEntityService = ServiceFactory.getService(IBizAppEntityService.class);
    private final IHBSSCloudEntityService cloudEntityService = ServiceFactory.getService(IHBSSCloudEntityService.class);

    @Override
    public TreeNode loadAppTreeNodes(List<String> appIdList, Boolean showHdtcApps) {
        DynamicObject[] bizAppDyns;
        TreeNode root = new TreeNode("", "01010", ResManager.loadKDString((String)"\u5168\u90e8", (String)"BizAppTreeServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]));
        root.setIsOpened(Boolean.TRUE.booleanValue());
        List<String> cloudIdList = null;
        if (!showHdtcApps.booleanValue()) {
            cloudIdList = this.cloudEntityService.queryHRCloudId();
        }
        if ((bizAppDyns = this.bizAppEntityService.getHrAppDynList(appIdList, cloudIdList)) != null) {
            this.initTree(root, bizAppDyns);
        }
        return root;
    }

    private void initTree(TreeNode root, DynamicObject[] hrBizAppDyns) {
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(hrBizAppDyns.length);
        treeNodeMap.put("01010", root);
        for (DynamicObject hrBizAppDyn : hrBizAppDyns) {
            DynamicObject bizCloud = hrBizAppDyn.getDynamicObject("bizcloud");
            if (bizCloud == null) continue;
            TreeNode bizCloudNode = this.buildCloudNode(root, bizCloud, treeNodeMap);
            this.buildAppNode(bizCloudNode, hrBizAppDyn, treeNodeMap);
        }
    }

    private TreeNode buildCloudNode(TreeNode root, DynamicObject bizCloud, Map<String, TreeNode> treeMaps) {
        String bizCloudId = bizCloud.getString("id");
        String bizCloudNodeId = bizCloudId + "-" + "C";
        TreeNode bizCloudNode = treeMaps.get(bizCloudNodeId);
        if (bizCloudNode == null) {
            bizCloudNode = new TreeNode("01010", bizCloudNodeId, bizCloud.getString("name"));
            root.addChild(bizCloudNode);
        }
        treeMaps.put(bizCloudNodeId, bizCloudNode);
        return bizCloudNode;
    }

    private void buildAppNode(TreeNode bizCloudNode, DynamicObject app, Map<String, TreeNode> treeMaps) {
        String appId = app.getString("id");
        String appNodeId = appId + "-" + "A";
        TreeNode appNode = treeMaps.get(appNodeId);
        if (appNode != null) {
            return;
        }
        String bizcloudId = bizCloudNode.getId();
        appNode = new TreeNode(bizcloudId, appNodeId, app.getString("name"));
        treeMaps.put(appNodeId, appNode);
        bizCloudNode.addChild(appNode);
    }
}

