/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdi.business.application.external.IBizAppDomainService;
import kd.hdtc.hrdi.business.application.external.IBusinessEventModelDomainService;
import kd.hdtc.hrdi.business.application.external.bo.BizEventModel;
import kd.hdtc.hrdi.business.application.external.entity.IBusinessEventModelEntityService;
import kd.hdtc.hrdi.business.application.external.entity.IBusinessSubscriptionModelEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IntegratedConfDomainService;
import kd.hr.hbp.common.util.HRArrayUtils;

public class BusinessEventModelDomainServiceImpl
implements IBusinessEventModelDomainService {
    private final IBusinessEventModelEntityService iBusinessEventModelEntityService = ServiceFactory.getService(IBusinessEventModelEntityService.class);
    private final IBusinessSubscriptionModelEntityService iBusinessSubscriptionModelEntityService = ServiceFactory.getService(IBusinessSubscriptionModelEntityService.class);
    private final IBizAppDomainService iBizAppDomainService = ServiceFactory.getService(IBizAppDomainService.class);
    private final IntegratedConfDomainService intConfDomainService = ServiceFactory.getService(IntegratedConfDomainService.class);
    private final Long PLUGIN_SERVICE = 904236026388547584L;

    @Override
    public Map<String, List<Long>> saveBusinessEventModel(List<Map<String, Object>> opMap) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(10);
        for (Map<String, Object> map : opMap) {
            String number = String.join((CharSequence)".", ConvertUtils.toString((Object)map.get("number")), ConvertUtils.toString((Object)map.get("fcode")));
            DynamicObject event = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"evt_event"));
            event.set("type", (Object)"cosmic");
            event.set("entity", map.get("entityobj"));
            event.set("source", map.get("source"));
            event.set("operationview", map.get("fname"));
            event.set("numberview", (Object)number);
            event.set("name", (Object)String.join((CharSequence)".", ConvertUtils.toString((Object)map.get("name")), ConvertUtils.toString((Object)map.get("fname"))));
            event.set("number", (Object)number);
            event.set("status", (Object)"1");
            event.set("ismodified", (Object)"1");
            event.set("scene", (Object)"operate");
            event.set("opernumber", map.get("fcode"));
            LocaleString operName = new LocaleString();
            operName.setLocaleValue(ConvertUtils.toString((Object)map.get("fname")));
            event.set("operation", (Object)operName);
            resultList.add(event);
        }
        Object[] result = this.iBusinessEventModelEntityService.save(resultList.toArray(new DynamicObject[0]));
        if (HRArrayUtils.isEmpty((Object[])result)) {
            return new HashMap<String, List<Long>>(16);
        }
        HashMap<String, List<Long>> bizEventIdMap = new HashMap<String, List<Long>>(16);
        Arrays.stream(result).forEach(it -> {
            DynamicObject bizEventDyn = (DynamicObject)it;
            String entity = bizEventDyn.getString("entity");
            List idList = bizEventIdMap.getOrDefault(entity, new ArrayList(16));
            idList.add(bizEventDyn.getLong("id"));
            bizEventIdMap.put(entity, idList);
        });
        return bizEventIdMap;
    }

    @Override
    public DynamicObject[] queryByNumber(Set<String> number) {
        Object[] query = this.iBusinessEventModelEntityService.query("entity,number", new QFilter("number", "in", number).toArray());
        if (HRArrayUtils.isEmpty((Object[])query)) {
            return new DynamicObject[0];
        }
        return query;
    }

    @Override
    public Map<String, List<Long>> saveBusinessSubscriptionModel(List<Long> idList) {
        DynamicObject[] bizs = this.iBusinessEventModelEntityService.query("number,entity,name", new QFilter("id", "in", idList).toArray());
        List numberList = Arrays.stream(bizs).map(biz -> String.join((CharSequence)".", biz.getString("number"), "executePlugin", "hrdi")).collect(Collectors.toList());
        Object[] numbers = this.iBusinessSubscriptionModelEntityService.query("event,number", new QFilter("number", "in", numberList).toArray());
        List eventNumberList = Arrays.stream(numbers).map(it -> it.getString("number")).collect(Collectors.toList());
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(10);
        for (DynamicObject biz2 : bizs) {
            DynamicObject event = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"evt_subscription"));
            String number = String.join((CharSequence)".", biz2.getString("number"), "executePlugin", "hrdi");
            if (eventNumberList.contains(number)) continue;
            event.set("event", (Object)biz2);
            event.set("service", (Object)this.PLUGIN_SERVICE);
            event.set("number", (Object)number);
            LocaleString name = new LocaleString();
            name.setLocaleValue(String.join((CharSequence)".", biz2.getLocaleString("name").getLocaleValue(), ResManager.loadKDString((String)"\u6267\u884c\u63d2\u4ef6", (String)"IBusinessEventModelDomainServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0])));
            event.set("name", (Object)name);
            HashMap<String, String> jsonMap = new HashMap<String, String>(16);
            jsonMap.put("scriptid", "");
            jsonMap.put("appid", "hrdi");
            jsonMap.put("type", "class");
            jsonMap.put("class", "kd.hdtc.hrdi.adaptor.outbound.event.IntCommonEventServicePlugin");
            jsonMap.put("operateparamsconf", "");
            HashMap<String, String> valueMap = new HashMap<String, String>(16);
            valueMap.put("appid", "hrdi");
            valueMap.put("class", "kd.hdtc.hrdi.adaptor.outbound.event.IntCommonEventServicePlugin");
            valueMap.put("operateparamsconf", "");
            jsonMap.put("value", JSON.toJSONString(valueMap));
            event.set("serviceconfig", (Object)JSON.toJSONString(jsonMap));
            event.set("isconcurrent", (Object)"1");
            event.set("status", (Object)"1");
            event.set("errorstrategy", (Object)"retry");
            event.set("sequence", (Object)0);
            event.set("servicenumber", (Object)"executePlugin");
            event.set("eventnumber", (Object)biz2.getString("number"));
            event.set("ismodified", (Object)"1");
            event.set("ispreinsdata", (Object)"0");
            resultList.add(event);
        }
        Object[] result = this.iBusinessSubscriptionModelEntityService.save(resultList.toArray(new DynamicObject[0]));
        this.saveAfterExecute(result);
        HashMap<String, List<Long>> bizSubMap = new HashMap<String, List<Long>>(16);
        this.parseResult(result, bizSubMap);
        this.parseResult(numbers, bizSubMap);
        return bizSubMap;
    }

    private void parseResult(Object[] datas, Map<String, List<Long>> bizSubMap) {
        Arrays.stream(datas).forEach(it -> {
            DynamicObject bizSubDyn = (DynamicObject)it;
            String entity = bizSubDyn.getString("event.entity.id");
            List bizSubIdList = bizSubMap.getOrDefault(entity, new ArrayList(16));
            bizSubIdList.add(bizSubDyn.getLong("id"));
            bizSubMap.put(entity, bizSubIdList);
        });
    }

    @Override
    public Map<String, List<Long>> saveBizEventModel(List<DynamicObject> relationDynList) {
        HashSet<String> entityNumberSet = new HashSet<String>(16);
        relationDynList.forEach(intRelation -> entityNumberSet.add(intRelation.getDynamicObject("intsource").getString("entityobj.id")));
        Map<String, Object> bizAppIdMap = this.iBizAppDomainService.getBizAppId(entityNumberSet);
        Map<String, DynamicObject> intConfigMap = this.intConfDomainService.queryConf(entityNumberSet);
        HashSet<String> bizEventNumberSet = new HashSet<String>(16);
        ArrayList bizEventModelList = new ArrayList(16);
        relationDynList.forEach(relation -> {
            String entityNumber = relation.getDynamicObject("intsource").getString("entityobj.id");
            String entityName = relation.getDynamicObject("intsource").getDynamicObject("entityobj").getString("name");
            DynamicObject intConfigDyn = (DynamicObject)intConfigMap.get(entityNumber);
            String opType = intConfigDyn.getString("bizop");
            String[] ops = opType.split(",");
            HashMap<String, String> opCodeNumberMap = new HashMap<String, String>(16);
            Arrays.stream(ops).forEach(op -> {
                String[] opCodeNames = op.split("!");
                if (opCodeNames.length > 1) {
                    String bizEventNumber = String.join((CharSequence)".", entityNumber, opCodeNames[0]);
                    bizEventNumberSet.add(bizEventNumber);
                    opCodeNumberMap.put(opCodeNames[0], opCodeNames[1]);
                }
            });
            List numbers = Arrays.stream(ops).map(it -> String.join((CharSequence)".", entityNumber, it.split("!")[0])).collect(Collectors.toList());
            bizEventNumberSet.addAll(numbers);
            BizEventModel model = new BizEventModel();
            model.setEntityNumber(entityNumber);
            model.setEntityName(entityName);
            model.setOpCodeNameMap(opCodeNumberMap);
            bizEventModelList.add(model);
        });
        DynamicObject[] events = this.queryByNumber(bizEventNumberSet);
        HashSet dbBizEventNumberSet = new HashSet(16);
        HashMap dbBizEventIdMap = new HashMap(16);
        Arrays.stream(events).forEach(event -> {
            dbBizEventNumberSet.add(event.getString("number"));
            String entity = event.getString("entity.id");
            List idList = dbBizEventIdMap.getOrDefault(entity, new ArrayList(16));
            idList.add(event.getLong("id"));
            dbBizEventIdMap.put(entity, idList);
        });
        ArrayList<Map<String, Object>> opMap = new ArrayList<Map<String, Object>>(16);
        bizEventModelList.forEach(bizEventModel -> bizEventModel.getOpCodeNameMap().forEach((code, name) -> {
            String entityNumber = bizEventModel.getEntityNumber();
            String bizEventNumber = String.join((CharSequence)".", entityNumber, code);
            if (!dbBizEventNumberSet.contains(bizEventNumber)) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("fcode", (String)code);
                map.put("fname", (String)name);
                map.put("entityobj", entityNumber);
                map.put("number", entityNumber);
                map.put("name", bizEventModel.getEntityName());
                map.put("source", (String)bizAppIdMap.get(entityNumber));
                opMap.add(map);
            }
        }));
        Map<String, List<Long>> bizEventIdMap = this.saveBusinessEventModel(opMap);
        entityNumberSet.forEach(entityNumber -> {
            List idList = bizEventIdMap.getOrDefault(entityNumber, new ArrayList(16));
            List dbIdList = (List)dbBizEventIdMap.get(entityNumber);
            if (CollectionUtils.isNotEmpty((Collection)dbIdList)) {
                idList.addAll((Collection)dbBizEventIdMap.get(entityNumber));
            }
            bizEventIdMap.put((String)entityNumber, idList);
        });
        return bizEventIdMap;
    }

    @Override
    public void deleteBizEventById(List<Long> idList) {
        this.iBusinessEventModelEntityService.delete(idList.toArray(new Long[0]));
    }

    @Override
    public void deleteBizSubById(List<Long> idList) {
        this.iBusinessSubscriptionModelEntityService.delete(idList.toArray(new Long[0]));
    }

    private void saveAfterExecute(Object[] result) {
        if (HRArrayUtils.isEmpty((Object[])result)) {
            return;
        }
        Object[] pks = Arrays.stream(result).map(it -> ((DynamicObject)it).getLong("id")).toArray();
        DynamicObject[] savedSubscriptions = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"evt_subscription"));
        if (savedSubscriptions == null || savedSubscriptions.length < 1) {
            return;
        }
        for (DynamicObject subscription : savedSubscriptions) {
            String evtNumber = subscription.getString("eventnumber");
            String groupNumber = evtNumber.contains(".") ? evtNumber.split("\\.")[0] : "defaultGroup";
            EvtCacheHelper.removeCacheEvent((String)groupNumber);
        }
    }
}

