/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdi.business.application.external.ICommonIntDomainService;
import kd.hdtc.hrdi.business.application.external.IIscServiceFlowDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.intserviceconfig.IIntScmLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.bean.CommonSubMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;

public class CommonIntDomainServiceImpl
implements ICommonIntDomainService {
    private static final Log LOG = LogFactory.getLog(CommonIntDomainServiceImpl.class);
    private final IIscServiceFlowDomainService serviceFlowDomainService = ServiceFactory.getService(IIscServiceFlowDomainService.class);
    private final IIntScmLogDomainService logDomainService = ServiceFactory.getService(IIntScmLogDomainService.class);
    private final IIntRelationDomainService iIntRelationDomainService = ServiceFactory.getService(IIntRelationDomainService.class);
    private final IMsgRecordLogEntityService msgRecordLogEntityService = ServiceFactory.getService(IMsgRecordLogEntityService.class);

    @Override
    public List<Long> handleCommonInt(List<Long> boIdList, String entityNumber, String msgSubNo, String number) {
        Object[] intRelations = this.iIntRelationDomainService.queryEnableDataByMsgSubNo(entityNumber, "2", null, msgSubNo);
        ArrayList msgRecordLogIdList = Lists.newArrayListWithExpectedSize((int)16);
        if (ArrayUtils.isNotEmpty((Object[])intRelations)) {
            Arrays.stream(intRelations).forEach(intRelation -> {
                CommonSubMsgRecordContentBean commonSubMsgRecordContentBean = this.getCommonSubMsgRecordContentBean(boIdList, entityNumber, msgSubNo, number);
                Long msgRecordLogId = this.msgRecordLogEntityService.saveCommonSubMsgRecordLog(commonSubMsgRecordContentBean, (DynamicObject)intRelation);
                msgRecordLogIdList.add(msgRecordLogId);
            });
        }
        return msgRecordLogIdList;
    }

    @Override
    public String outCommonIntHandle(String msgContent, DynamicObject intRelation) {
        String errorInfo = "";
        if ("isc_service_flow".equals(intRelation.getString("inttype"))) {
            DynamicObject iscFlow = intRelation.getDynamicObject("intscm");
            if (iscFlow == null) {
                LOG.info("Integration ralation ({}) has no service flow");
            } else {
                CommonSubMsgRecordContentBean commonSubMsgRecordContentBean = (CommonSubMsgRecordContentBean)JSONObject.parseObject((String)msgContent, CommonSubMsgRecordContentBean.class);
                HashMap otherParamMap = Maps.newHashMapWithExpectedSize((int)1);
                otherParamMap.put("number", commonSubMsgRecordContentBean.getNumber());
                ArrayList paramList = Lists.newArrayListWithExpectedSize((int)1);
                paramList.add(commonSubMsgRecordContentBean.getIdList());
                paramList.add(otherParamMap);
                try {
                    Map<String, Object> resultMap = this.serviceFlowDomainService.invokeServiceFlow(iscFlow.get("number"), paramList);
                    LOG.info("Service flow execute result{}", resultMap);
                    errorInfo = ((Map)((Map)((Map)((Map)resultMap.get("output")).get("rtn")).get("data")).get("result")).get("errorMsg") + "";
                }
                catch (Exception e) {
                    LOG.error("handleCommonInt flow error:{} ", (Object)e.getMessage());
                    throw e;
                }
                this.logDomainService.saveIntScmLog(iscFlow, intRelation.getDynamicObject("intsource"));
            }
        } else {
            LOG.error("Do not support isc trigger schema.");
        }
        return errorInfo;
    }

    private CommonSubMsgRecordContentBean getCommonSubMsgRecordContentBean(List<Long> boIdList, String entityNumber, String msgSubNo, String number) {
        CommonSubMsgRecordContentBean commonSubMsgRecordContentBean = new CommonSubMsgRecordContentBean();
        commonSubMsgRecordContentBean.setNumber(number);
        commonSubMsgRecordContentBean.setMsgSubNo(msgSubNo);
        commonSubMsgRecordContentBean.setEntityNumber(entityNumber);
        commonSubMsgRecordContentBean.setIdList(boIdList);
        return commonSubMsgRecordContentBean;
    }
}

