/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.servicehelper.MSServiceHelper;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataInfoParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.application.external.IIscExternalApiDomainService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;

public class IscExternalApiDomainServiceImpl
implements IIscExternalApiDomainService {
    private static final Log LOG = LogFactory.getLog(IscExternalApiDomainServiceImpl.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);

    @Override
    public Object invokeBizService(String number, Object ... paras) {
        return MSServiceHelper.invokeIscbService((String)"IscApicService", (String)"invokeExternalApi", (Object[])new Object[]{number, paras, ""});
    }

    @Override
    public List<Map<String, Object>> toExternalApiMapList(String entityNumber, List<String> businessKeys, String operation, String uniqueFieldKey) {
        Map<Object, DynamicObject> idAndDyMap;
        if (StringUtils.isEmpty((String)entityNumber) || CollectionUtils.isEmpty(businessKeys)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList externalApiMapList = Lists.newArrayListWithExpectedSize((int)businessKeys.size());
        if ("delete".equals(operation)) {
            businessKeys.forEach(id -> {
                HashMap externalApiMap = Maps.newHashMapWithExpectedSize((int)1);
                externalApiMap.put("id", id);
                externalApiMapList.add(externalApiMap);
            });
            return externalApiMapList;
        }
        MetadataInfoParam metadataInfoParam = MetadataUtils.parseMetadataInfo((String)uniqueFieldKey, (String)entityNumber);
        ArrayList<Object> idList = MetadataUtils.getPrimaryKeys(businessKeys, (String)entityNumber);
        boolean hisBaseData = MetadataUtils.hisEntity((String)entityNumber);
        if (hisBaseData) {
            Set<Object> boIdSet = this.iBaseCommonDomainService.queryHisDataBoIdByIdList(entityNumber, (List<Object>)idList);
            idAndDyMap = this.iBaseCommonDomainService.queryCurrentVersionDataByIdList(entityNumber, String.join((CharSequence)",", metadataInfoParam.getQueryFileNameList()), boIdSet);
            idList = new ArrayList<Object>(boIdSet);
        } else {
            idAndDyMap = this.iBaseCommonDomainService.queryDataByIdList(entityNumber, String.join((CharSequence)",", metadataInfoParam.getQueryFileNameList()), (Collection<Object>)idList);
        }
        if (CollectionUtils.isEmpty(idAndDyMap)) {
            return new ArrayList<Map<String, Object>>();
        }
        idList.forEach(id -> {
            boolean hisBaseDataCurrentVersion;
            DynamicObject dyInDb = (DynamicObject)idAndDyMap.get(id);
            boolean bl = hisBaseDataCurrentVersion = hisBaseData && dyInDb != null && dyInDb.getBoolean("iscurrentversion");
            if (!hisBaseData || hisBaseDataCurrentVersion) {
                Map externalApiMap = DynamicObjectUtils.convertDynamicObjectToSimpleValueMap((DynamicObject)dyInDb, (String)uniqueFieldKey);
                externalApiMapList.add(externalApiMap);
            }
        });
        return externalApiMapList;
    }

    @Override
    public String getErrorInfo(Map<String, Object> result) {
        if (Boolean.FALSE.equals(result.get("success"))) {
            return result.getOrDefault("message", "").toString();
        }
        return "";
    }
}

