/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.CodeRuleUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.IMsgSubscriberDomainService;
import kd.hdtc.hrdi.business.application.external.entity.IMsgSubscriberEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class MsgSubscriberDomainServiceImpl
implements IMsgSubscriberDomainService {
    private static final Log LOG = LogFactory.getLog(MsgSubscriberDomainServiceImpl.class);
    private final IMsgSubscriberEntityService iMsgSubscriberEntityService = ServiceFactory.getService(IMsgSubscriberEntityService.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);

    @Override
    public OperationResult reMsgSubscriber(List<Long> msgSubscriberIdList) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        DynamicObject[] msgSubscribers = this.iMsgSubscriberEntityService.queryMsgSubscribers(msgSubscriberIdList, "0");
        Stream.of(msgSubscribers).forEach(dy -> {
            dy.set("substatus", (Object)"1");
            dy.set("enable", (Object)"1");
        });
        try {
            String entityNumber = msgSubscribers[0].getDataEntityType().getName();
            operationResult = OperationServiceHelper.executeOperate((String)"sub", (String)entityNumber, (DynamicObject[])msgSubscribers, (OperateOption)option);
        }
        catch (Exception ex) {
            LOG.error("reMsgSubscriber error", (Throwable)ex);
            return null;
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence[])new CharSequence[]{operationResult.getMessage()}) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u6d88\u606f\u91cd\u65b0\u8ba2\u9605\u5931\u8d25\u3002", (String)"MsgSubscriberDomainServiceImpl_2", (String)"hdtc-hrdi-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    @Override
    public List<DynamicObject> toMsgSubscriberList(Collection<DynamicObject> msgPublisherList) {
        if (CollectionUtils.isEmpty(msgPublisherList)) {
            return new ArrayList<DynamicObject>();
        }
        DynamicObject app = this.iBaseCommonDomainService.queryOneById("hbp_devportal_bizapp", "id,name,number,bizcloud", "33ZTSDV7P6VX");
        if (app == null) {
            throw new HRDBSBizException("hrdi app should not be empty");
        }
        DynamicObject businessField = this.iBaseCommonDomainService.queryOneById("hbss_bussinessfield", "id,name,number", "109010");
        if (businessField == null) {
            LOG.error("businessField should not be empty");
            throw new HRDBSBizException("businessField should not be empty");
        }
        boolean isExistCodeRule = CodeRuleUtils.isExist((String)"hrcs_msgsubscriber");
        if (!isExistCodeRule) {
            LOG.error("MsgSubscriber hasCodeRule should not be notExist");
            throw new HRDBSBizException("MsgSubscriber hasCodeRule should not be notExist");
        }
        ArrayList msgSubscriberList = Lists.newArrayListWithExpectedSize((int)msgPublisherList.size());
        ArrayList<DynamicObject> msgPublishers = new ArrayList<DynamicObject>(msgPublisherList);
        long[] ids = ID.genLongIds((int)msgPublisherList.size());
        for (int i = 0; i < msgPublishers.size(); ++i) {
            DynamicObject msgSubscriber = this.getMsgSubscriber(app, businessField, (DynamicObject)msgPublishers.get(i));
            msgSubscriber.set("id", (Object)ids[i]);
            String number = this.hasCodeRule(msgSubscriber);
            msgSubscriber.set("number", (Object)number);
            msgSubscriberList.add(msgSubscriber);
        }
        return msgSubscriberList;
    }

    @Override
    public List<Map<String, Object>> toMsgSubscriberMapList(Collection<DynamicObject> msgPublisherList) {
        if (CollectionUtils.isEmpty(msgPublisherList)) {
            return new ArrayList<Map<String, Object>>();
        }
        DynamicObject app = this.iBaseCommonDomainService.queryOneById("hbp_devportal_bizapp", "id,name,number,bizcloud", "33ZTSDV7P6VX");
        if (app == null) {
            throw new HRDBSBizException("hrdi app should not be empty");
        }
        DynamicObject businessField = this.iBaseCommonDomainService.queryOneById("hbss_bussinessfield", "id,name,number", "109010");
        if (businessField == null) {
            throw new HRDBSBizException("businessField should not be empty");
        }
        ArrayList msgSubscriberList = Lists.newArrayListWithExpectedSize((int)msgPublisherList.size());
        msgPublisherList.forEach(msgPublisher -> {
            Map<String, Object> msgSubscriberMap = this.getConsumeMsgMap(app, businessField, (DynamicObject)msgPublisher);
            msgSubscriberList.add(msgSubscriberMap);
        });
        return msgSubscriberList;
    }

    private DynamicObject getMsgSubscriber(DynamicObject app, DynamicObject businessField, DynamicObject msgPublisher) {
        DynamicObject msgSubscriber = this.iMsgSubscriberEntityService.generateEmptyDynamicObject();
        msgSubscriber.set("name", msgPublisher.get("name"));
        msgSubscriber.set("consumerapp", (Object)app);
        msgSubscriber.set("consumercloud", app.get("bizcloud"));
        msgSubscriber.set("subscribebd", (Object)businessField);
        msgSubscriber.set("consumerservice", (Object)"changeEventCommonConsumer");
        msgSubscriber.set("consumermethod", (Object)"consumerSaveMsg");
        msgSubscriber.set("msgpublisher", (Object)msgPublisher);
        msgSubscriber.set("msgcode", (Object)msgPublisher.getString("number"));
        msgSubscriber.set("actioncloud", msgPublisher.get("actioncloud"));
        msgSubscriber.set("actionapp", msgPublisher.get("actionapp"));
        msgSubscriber.set("msgdomain", msgPublisher.get("publishbd"));
        msgSubscriber.set("msgactiontype", msgPublisher.get("actiontype"));
        msgSubscriber.set("action", msgPublisher.get("action"));
        msgSubscriber.set("msgtag", msgPublisher.get("msgtag"));
        msgSubscriber.set("puber", msgPublisher.get("puber"));
        msgSubscriber.set("suber", (Object)RequestContext.get().getCurrUserId());
        msgSubscriber.set("pubdate", msgPublisher.get("publishdate"));
        msgSubscriber.set("pubstatus", msgPublisher.get("pubstatus"));
        msgSubscriber.set("issubscribe", msgPublisher.get("issubscribe"));
        msgSubscriber.set("substatus", (Object)"1");
        return msgSubscriber;
    }

    private Map<String, Object> getConsumeMsgMap(DynamicObject app, DynamicObject businessField, DynamicObject msgPublisher) {
        HashMap consumeMsgMap = Maps.newHashMapWithExpectedSize((int)16);
        String number = this.hasCodeRule(this.iMsgSubscriberEntityService.generateEmptyDynamicObject());
        consumeMsgMap.put("msgSubNo", number);
        consumeMsgMap.put("msgPublisherNo", msgPublisher.getString("number"));
        consumeMsgMap.put("subStatus", "1");
        consumeMsgMap.put("consumerCloudId", app.get("bizcloud.id"));
        consumeMsgMap.put("consumerAppId", app.get("id"));
        consumeMsgMap.put("consumerService", "changeEventCommonConsumer");
        consumeMsgMap.put("consumerMethod", "consumerSaveMsg");
        consumeMsgMap.put("isNonoriginal", "0");
        consumeMsgMap.put("subscribeDdId", businessField.getLong("id"));
        consumeMsgMap.put("suberId", RequestContext.get().getCurrUserId());
        consumeMsgMap.put("description", "");
        consumeMsgMap.put("apiEntryEntity", null);
        return consumeMsgMap;
    }

    private String hasCodeRule(DynamicObject msgSubscriber) {
        return CodeRuleServiceHelper.getNumber((String)"hrcs_msgsubscriber", (DynamicObject)msgSubscriber, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult msgSubscriber(List<DynamicObject> msgSubscriberList) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        OperationResult operationResult = null;
        try (TXHandle txHandle = TX.requiresNew();){
            String entityNumber = msgSubscriberList.get(0).getDataEntityType().getName();
            for (DynamicObject msgSubscriber : msgSubscriberList) {
                operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])new DynamicObject[]{msgSubscriber}, (OperateOption)option);
            }
        }
        if (operationResult != null && !operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence[])new CharSequence[]{operationResult.getMessage()}) ? this.paraseOpResult(operationResult) : ResManager.loadKDString((String)"\u8ba2\u9605\u6d88\u606f\u534f\u540c\u4e1a\u52a1\u4e8b\u4ef6\u5931\u8d25\u3002", (String)"MsgSubscriberDomainServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    @Override
    public List<Long> batchMsgSubscriber(List<Map<String, Object>> subscriberMapList) {
        List idList;
        try {
            idList = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"saveMsgSubscriberList", (Object[])new Object[]{subscriberMapList});
        }
        catch (Exception ex) {
            LOG.error("batchMsgSubscriber error", (Throwable)ex);
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence[])new CharSequence[]{ex.getMessage()}) ? ex.getMessage() : ResManager.loadKDString((String)"\u8ba2\u9605\u6d88\u606f\u534f\u540c\u4e1a\u52a1\u4e8b\u4ef6\u5931\u8d25\u3002", (String)"MsgSubscriberDomainServiceImpl_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]));
        }
        return idList;
    }

    private String paraseOpResult(OperationResult operationResult) {
        ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
        if (validateResultCollection != null) {
            StringBuilder errMsgBuilder = new StringBuilder();
            List validateErrorList = validateResultCollection.getValidateErrors();
            validateErrorList.forEach(validateResult -> {
                List allErrorInfoList = validateResult.getAllErrorInfo();
                allErrorInfoList.forEach(operateErrorInfo -> errMsgBuilder.append(operateErrorInfo.getMessage()));
            });
            return errMsgBuilder.toString();
        }
        return null;
    }
}

