/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.external.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdi.business.application.external.IIscServiceFlowDomainService;
import kd.hdtc.hrdi.business.application.external.IPersonDomainService;
import kd.hdtc.hrdi.business.application.external.entity.IPersonEntityService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.intserviceconfig.IIntScmLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.bean.PersonSubMsgRecordContentBean;
import kd.hdtc.hrdi.business.domain.monitor.entity.IMsgRecordLogEntityService;
import kd.hdtc.hrdi.common.adaptor.constants.PersonConstants;
import kd.hdtc.hrdi.common.pojo.FourFloorPersonIdEntry;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.hdtc.hrdi.adaptor.extend.IPersonMainEntityExtend;

public class PersonDomainServiceImpl
implements IPersonDomainService {
    private static final Log LOG = LogFactory.getLog(PersonDomainServiceImpl.class);
    private final IPersonEntityService iPersonEntityService = ServiceFactory.getService(IPersonEntityService.class);
    private final IMsgRecordLogEntityService msgRecordLogEntityService = ServiceFactory.getService(IMsgRecordLogEntityService.class);
    private final IIscServiceFlowDomainService serviceFlowDomainService = ServiceFactory.getService(IIscServiceFlowDomainService.class);
    private final IIntScmLogDomainService logDomainService = ServiceFactory.getService(IIntScmLogDomainService.class);
    private final IIntRelationDomainService iIntRelationDomainService = ServiceFactory.getService(IIntRelationDomainService.class);

    @Override
    public List<FourFloorPersonIdEntry> getFourFloorPersonIdEntryList(String entityNumber, List<Long> idList, IPersonMainEntityExtend personMainEntityExtend) {
        if (CollectionUtils.isNotEmpty(idList)) {
            Map<String, String> personMainEntity = this.getPersonMainEntity(personMainEntityExtend);
            String field = personMainEntity.get(entityNumber);
            List<FourFloorPersonIdEntry> fourFloorPersonDbList = "person.id".equals(field) ? this.iPersonEntityService.listFieldsFilterInfo(entityNumber, idList) : (PersonConstants.EMP_ENTITY_NUMBER.contains(entityNumber) ? this.iPersonEntityService.getFourFloorPersonModelsWithFilter(field, idList, new QFilter(field, "in", idList)) : this.iPersonEntityService.getMainFileFourFloorPersonModels(field, idList));
            return fourFloorPersonDbList;
        }
        return new ArrayList<FourFloorPersonIdEntry>();
    }

    @Override
    public Map<Long, FourFloorPersonIdEntry> getFourPersonIds(List<Long> depempIdList) {
        List<Map<String, Object>> depempInfoList = this.iPersonEntityService.getDepempInfo(depempIdList);
        if (CollectionUtils.isEmpty(depempInfoList)) {
            return new HashMap<Long, FourFloorPersonIdEntry>();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)depempInfoList.size());
        depempInfoList.forEach(depempInfoMap -> {
            FourFloorPersonIdEntry fourFloorPerson = new FourFloorPersonIdEntry();
            depempInfoMap.forEach((field, value) -> {
                switch (field) {
                    case "person": {
                        fourFloorPerson.setPersonId((Long)value);
                        break;
                    }
                    case "employee": {
                        fourFloorPerson.setEmployeeId((Long)value);
                        break;
                    }
                    case "cmpemp": {
                        fourFloorPerson.setCmpempId((Long)value);
                        break;
                    }
                    case "depemp": {
                        fourFloorPerson.setDepempId((Long)value);
                        resultMap.put((Long)value, fourFloorPerson);
                        break;
                    }
                }
            });
        });
        return resultMap;
    }

    @Override
    public Map<String, String> getPersonMainEntity(IPersonMainEntityExtend personMainEntityExtend) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)personMainEntityExtend, IPersonMainEntityExtend.class, (String)"kd.sdk.hdtc.hrdi.adaptor.extend.IPersonMainEntityExtend", null);
        List resultList = pluginProxy.callReplaceIfPresent(IPersonMainEntityExtend::getPersonMainExtEntity);
        HashMap<String, String> personExtEntityMap = new HashMap<String, String>(16);
        personExtEntityMap.putAll(PersonConstants.PERSON_ENTITY_NUMBER);
        for (Map resultMap : resultList) {
            if (!CollectionUtils.isNotEmpty((Map)resultMap)) continue;
            LOG.info("PersonCommonSync getPersonMainEntity:{}", (Object)resultMap);
            personExtEntityMap.putAll(resultMap);
        }
        return personExtEntityMap;
    }

    @Override
    public List<Long> handlePersonMainInt(FourFloorPersonIdEntry fourFloorPersonIdEntry, boolean delete, String caller, String variationType, List<String> changePersonEntityList, String msgSubNo, String number) {
        DynamicObject[] intRelations = this.iIntRelationDomainService.queryEnableDataByMsgSubNo("hrpi_emp_integrate", "2", "isc_service_flow", msgSubNo);
        ArrayList msgRecordLogIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject intRelation : intRelations) {
            PersonSubMsgRecordContentBean personSubMsgRecordContentBean = this.getPersonMainSubMsgRecordContentBean(fourFloorPersonIdEntry, delete, caller, variationType, changePersonEntityList, msgSubNo, number);
            Long msgRecordLogId = this.msgRecordLogEntityService.savePersonSubMsgRecordLog(personSubMsgRecordContentBean, intRelation);
            msgRecordLogIdList.add(msgRecordLogId);
        }
        return msgRecordLogIdList;
    }

    @Override
    public String personMainOutInt(FourFloorPersonIdEntry fourFloorPersonIdEntry, boolean delete, String caller, String variationType, List<String> changePersonEntityList, DynamicObject intRelation) {
        DynamicObject intScm = intRelation.getDynamicObject("intscm");
        String errorInfo = "";
        if (intScm != null) {
            List<Object> param = this.getPersonMainParam(fourFloorPersonIdEntry, delete, caller, variationType, changePersonEntityList);
            try {
                Map<String, Object> result = this.serviceFlowDomainService.invokeServiceFlow(intScm.get("number"), param);
                LOG.info("Service flow execute result{}", result);
                errorInfo = ((Map)((Map)((Map)((Map)result.get("output")).get("rtn")).get("data")).get("result")).get("errorMsg") + "";
            }
            catch (Exception e) {
                LOG.error("executeIscFlowService flow error:{} ", (Object)e.getMessage());
                throw e;
            }
            this.logDomainService.saveIntScmLog(intScm, intRelation.getDynamicObject("intsource"));
        } else {
            LOG.info("Integration relation ({}) has no service flow");
        }
        return errorInfo;
    }

    private PersonSubMsgRecordContentBean getPersonMainSubMsgRecordContentBean(FourFloorPersonIdEntry fourFloorPersonIdEntry, boolean delete, String caller, String variationType, List<String> changePersonEntityList, String msgSubNo, String number) {
        PersonSubMsgRecordContentBean personSubMsgRecordContentBean = new PersonSubMsgRecordContentBean();
        personSubMsgRecordContentBean.setNumber(number);
        personSubMsgRecordContentBean.setMsgSubNo(msgSubNo);
        personSubMsgRecordContentBean.setDelete(delete);
        personSubMsgRecordContentBean.setCaller(caller);
        personSubMsgRecordContentBean.setEntityNumber("hrpi_emp_integrate");
        personSubMsgRecordContentBean.setVariationType(variationType);
        personSubMsgRecordContentBean.setChangePersonEntityList(changePersonEntityList);
        personSubMsgRecordContentBean.setFourFloorPersonIdEntry(fourFloorPersonIdEntry);
        return personSubMsgRecordContentBean;
    }

    private List<Object> getPersonMainParam(FourFloorPersonIdEntry fourFloorPersonIdEntry, boolean delete, String caller, String variationType, List<String> changePersonEntityList) {
        ArrayList param = Lists.newArrayListWithExpectedSize((int)16);
        param.add(Collections.singletonList(fourFloorPersonIdEntry.getPersonId()));
        param.add(Collections.singletonList(fourFloorPersonIdEntry.getEmployeeId()));
        param.add(Collections.singletonList(fourFloorPersonIdEntry.getCmpempId()));
        param.add(Collections.singletonList(fourFloorPersonIdEntry.getDepempId()));
        param.add(caller);
        param.add(delete);
        param.add(variationType);
        param.add(changePersonEntityList);
        return param;
    }

    @Override
    public List<Long> handlePersonAttachInt(List<Long> idList, boolean delete, String caller, String entityNumber, String msgSubNo, String number) {
        Object[] intRelations = this.iIntRelationDomainService.queryEnableDataByMsgSubNo(entityNumber, "2", "isc_service_flow", msgSubNo);
        ArrayList msgRecordLogIdList = Lists.newArrayListWithExpectedSize((int)16);
        if (ArrayUtils.isNotEmpty((Object[])intRelations)) {
            for (Object intRelation : intRelations) {
                PersonSubMsgRecordContentBean personSubMsgRecordContentBean = this.getPersonAttachSubMsgRecordContentBean(entityNumber, idList, delete, caller, msgSubNo, number);
                Long msgRecordLogId = this.msgRecordLogEntityService.savePersonSubMsgRecordLog(personSubMsgRecordContentBean, (DynamicObject)intRelation);
                msgRecordLogIdList.add(msgRecordLogId);
            }
        }
        return msgRecordLogIdList;
    }

    @Override
    public String personAttachOutInt(List<Long> idList, boolean delete, String caller, DynamicObject intRelation) {
        DynamicObject intScm = intRelation.getDynamicObject("intscm");
        String errorInfo = "";
        if (intScm != null) {
            ArrayList param = Lists.newArrayListWithExpectedSize((int)16);
            param.add(idList);
            param.add(caller);
            param.add(delete);
            try {
                Map<String, Object> result = this.serviceFlowDomainService.invokeServiceFlow(intScm.getString("number"), param);
                LOG.info("Service flow execute result{}", result);
                errorInfo = ((Map)((Map)((Map)((Map)result.get("output")).get("rtn")).get("data")).get("result")).get("errorMsg") + "";
            }
            catch (Exception e) {
                LOG.error("executeIscFlowService flow error:{} ", (Object)e.getMessage());
                throw e;
            }
            this.logDomainService.saveIntScmLog(intScm, intRelation.getDynamicObject("intsource"));
        } else {
            LOG.info("Integration relation ({}) has no service flow");
        }
        return errorInfo;
    }

    private PersonSubMsgRecordContentBean getPersonAttachSubMsgRecordContentBean(String entityNumber, List<Long> idList, boolean delete, String caller, String msgSubNo, String number) {
        PersonSubMsgRecordContentBean personSubMsgRecordContentBean = new PersonSubMsgRecordContentBean();
        personSubMsgRecordContentBean.setNumber(number);
        personSubMsgRecordContentBean.setIdList(idList);
        personSubMsgRecordContentBean.setMsgSubNo(msgSubNo);
        personSubMsgRecordContentBean.setDelete(delete);
        personSubMsgRecordContentBean.setCaller(caller);
        personSubMsgRecordContentBean.setEntityNumber(entityNumber);
        return personSubMsgRecordContentBean;
    }
}

