/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.service.intgovern.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.application.external.IBusinessEventModelDomainService;
import kd.hdtc.hrdi.business.application.external.IMsgSubscriberDomainService;
import kd.hdtc.hrdi.business.application.external.entity.IMsgPublisherEntityService;
import kd.hdtc.hrdi.business.application.external.entity.IMsgSubscriberEntityService;
import kd.hdtc.hrdi.business.application.service.intgovern.IIntRelationApplicationService;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntRelationDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IntegratedConfDomainService;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;

public class IntRelationApplicationServiceImpl
implements IIntRelationApplicationService {
    private static final Log log = LogFactory.getLog(IntRelationApplicationServiceImpl.class);
    private List<DynamicObject> bizMsgDynList;
    private List<DynamicObject> bizOpDynList;
    private Map<String, DynamicObject> intConfigMap;
    private Map<String, BizCategoryEnum> categoryMap;
    private Map<Long, DynamicObject> dbRelationMap;
    private final Set<Long> personMsgPublishSet = ImmutableSet.of((Object)1752987804394074112L, (Object)1751595029278752768L);
    private final IIntEntityCategoryDomainService domainService = ServiceFactory.getService(IIntEntityCategoryDomainService.class);
    private final IntegratedConfDomainService intConfDomainService = ServiceFactory.getService(IntegratedConfDomainService.class);
    private final IMsgSubscriberDomainService iMsgSubscriberDomainService = ServiceFactory.getService(IMsgSubscriberDomainService.class);
    private final IMsgSubscriberEntityService iMsgSubscriberEntityService = ServiceFactory.getService(IMsgSubscriberEntityService.class);
    private final IMsgPublisherEntityService iMsgPublisherEntityService = ServiceFactory.getService(IMsgPublisherEntityService.class);
    private final IIntRelationDomainService intRelationDomainService = ServiceFactory.getService(IIntRelationDomainService.class);
    private final IBusinessEventModelDomainService iBusinessEventModelDomainService = ServiceFactory.getService(IBusinessEventModelDomainService.class);

    @Override
    public void outBoundRelationHandle(List<DynamicObject> relationList) {
        if (CollectionUtils.isEmpty(relationList)) {
            return;
        }
        this.init(relationList);
        this.bizBizMsgHandle();
        this.bizOpHandle();
    }

    private void bizBizMsgHandle() {
        this.bizMsgDynList.forEach(dyn -> {
            String entityNumber = dyn.getDynamicObject("intsource").getString("entityobj.id");
            this.fillMsgTypeFields((DynamicObject)dyn, this.intConfigMap.get(entityNumber), this.categoryMap.get(entityNumber));
            List<DynamicObject> subscriberList = this.handleSubscriber((DynamicObject)dyn);
            List<Long> subscriberIdList = subscriberList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            this.fillMuliBaseData(subscriberIdList, (DynamicObject)dyn, "msgsubscriber");
        });
    }

    private List<DynamicObject> handleSubscriber(DynamicObject intRelation) {
        Map<Long, DynamicObject> msgPublisherIdMsgPublishMap;
        List<DynamicObject> newSubscriberDynList;
        DynamicObjectCollection msgPublisherCollection = intRelation.getDynamicObjectCollection("msgpublisher");
        List<Object> publisherIdList = Lists.newArrayListWithExpectedSize((int)msgPublisherCollection.size());
        if (CollectionUtils.isNotEmpty((Collection)msgPublisherCollection)) {
            publisherIdList = msgPublisherCollection.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        ArrayList<DynamicObject> allSubscriberDynList = new ArrayList<DynamicObject>(16);
        Object[] hasMsgSubscribers = this.iMsgSubscriberEntityService.queryMsgSubscribersByPublisherIdList((List<Long>)publisherIdList, "1", "33ZTSDV7P6VX");
        if (ArrayUtils.isNotEmpty((Object[])hasMsgSubscribers)) {
            for (Object dy2 : hasMsgSubscribers) {
                long publisherId = dy2.getLong("msgpublisher.id");
                publisherIdList.remove(publisherId);
                allSubscriberDynList.add((DynamicObject)dy2);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)publisherIdList) && CollectionUtils.isNotEmpty(newSubscriberDynList = this.iMsgSubscriberDomainService.toMsgSubscriberList((msgPublisherIdMsgPublishMap = this.iMsgPublisherEntityService.queryMsgPublisherByIds((List<Long>)publisherIdList, null)).values()))) {
            OperationResult operationResult = this.iMsgSubscriberDomainService.msgSubscriber(newSubscriberDynList);
            allSubscriberDynList.addAll(newSubscriberDynList);
        }
        return allSubscriberDynList;
    }

    private void fillMuliBaseData(List<Long> baseDataList, DynamicObject intRelation, String field) {
        DynamicObjectCollection muliBaseDataCol = intRelation.getDynamicObjectCollection(field);
        muliBaseDataCol.clear();
        long[] ids = ID.genLongIds((int)baseDataList.size());
        for (int i = 0; i < baseDataList.size(); ++i) {
            Long baseDataId = baseDataList.get(i);
            DynamicObject msgPublisher = muliBaseDataCol.addNew();
            msgPublisher.set("pkid", (Object)ids[i]);
            msgPublisher.set("fbasedataid", (Object)baseDataId);
            msgPublisher.set("fbasedataid_id", (Object)baseDataId);
        }
        intRelation.set(field, (Object)muliBaseDataCol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bizOpHandle() {
        if (CollectionUtils.isEmpty(this.bizOpDynList)) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            Map<String, List<Long>> bizEventIdMap = this.iBusinessEventModelDomainService.saveBizEventModel(this.bizOpDynList);
            this.bizOpDynList.forEach(intRelation -> this.buildEntry((DynamicObject)intRelation, bizEventIdMap, "eventdef"));
            ArrayList<Long> bizEventIdList = new ArrayList<Long>(16);
            bizEventIdMap.forEach((entity, idList) -> bizEventIdList.addAll((Collection<Long>)idList));
            Map<String, List<Long>> bizSubIdMap = this.iBusinessEventModelDomainService.saveBusinessSubscriptionModel(bizEventIdList);
            this.deleteBizSubscription(bizSubIdMap);
            this.bizOpDynList.forEach(intRelation -> {
                DynamicObjectCollection eventDefList = intRelation.getDynamicObjectCollection("eventdef");
                if (CollectionUtils.isNotEmpty((Collection)eventDefList)) {
                    this.buildEntry((DynamicObject)intRelation, bizSubIdMap, "evtsubscribe");
                }
            });
        }
    }

    private void deleteBizSubscription(Map<String, List<Long>> bizSubIdMap) {
        ArrayList<Long> deleteBizSubIdList = new ArrayList<Long>(16);
        this.bizOpDynList.forEach(bizOpDyn -> {
            String entityNumber = bizOpDyn.getDynamicObject("intsource").getString("entityobj.id");
            DynamicObject dbRelation = this.dbRelationMap.get(bizOpDyn.getLong("id"));
            if (dbRelation != null) {
                List bizSubIdList = (List)bizSubIdMap.get(entityNumber);
                DynamicObjectCollection bizSubCollection = dbRelation.getDynamicObjectCollection("evtsubscribe");
                bizSubCollection.forEach(dyn -> {
                    long bizEventId = dyn.getLong("fbasedataid_id");
                    if (!bizSubIdList.contains(bizEventId)) {
                        deleteBizSubIdList.add(bizEventId);
                    }
                });
            }
        });
        if (CollectionUtils.isNotEmpty(deleteBizSubIdList)) {
            this.iBusinessEventModelDomainService.deleteBizSubById(deleteBizSubIdList);
        }
    }

    private void buildEntry(DynamicObject intRelation, Map<String, List<Long>> entityIdMap, String field) {
        String entityNumber = intRelation.getDynamicObject("intsource").getString("entityobj.id");
        List<Long> idList = entityIdMap.get(entityNumber);
        this.fillMuliBaseData(idList, intRelation, field);
    }

    private void init(List<DynamicObject> relationList) {
        HashSet<String> bizEntitySet = new HashSet<String>(16);
        HashSet<Long> relationIdSet = new HashSet<Long>(16);
        relationList.forEach(relation -> {
            bizEntitySet.add(relation.getDynamicObject("intsource").getString("entityobj.id"));
            relationIdSet.add(relation.getLong("id"));
        });
        this.categoryMap = this.domainService.getCategoryByEntityNumber(bizEntitySet);
        this.intConfigMap = this.intConfDomainService.queryConf(bizEntitySet);
        this.dbRelationMap = this.intRelationDomainService.queryRelationById(relationIdSet);
        this.bizMsgDynList = new ArrayList<DynamicObject>(16);
        this.bizOpDynList = new ArrayList<DynamicObject>(16);
        relationList.forEach(dyn -> {
            String entityNumber = dyn.getDynamicObject("intsource").getString("entityobj.id");
            DynamicObject intConfig = this.intConfigMap.get(entityNumber);
            BizCategoryEnum categoryEnum = this.categoryMap.get(entityNumber);
            if (intConfig == null) {
                log.info("can not find intConfig, entityNumber:{}, categoryEnum:{}", (Object)entityNumber, (Object)categoryEnum);
                if (BizCategoryEnum.PERSON_ATTACHED.getCode().equals(categoryEnum.getCode())) {
                    this.bizMsgDynList.add((DynamicObject)dyn);
                }
            } else {
                String intType = intConfig.getString("inttype");
                if (StringUtils.equals((String)intType, (String)"1")) {
                    this.bizMsgDynList.add((DynamicObject)dyn);
                } else {
                    this.bizOpDynList.add((DynamicObject)dyn);
                }
            }
        });
    }

    private void fillMsgTypeFields(DynamicObject intRelation, DynamicObject intConfDyn, BizCategoryEnum categoryEnum) {
        List<Long> msgPublisherPkValue = this.getMsgPublisherPkValue(intConfDyn, categoryEnum);
        this.fillMuliBaseData(msgPublisherPkValue, intRelation, "msgpublisher");
        intRelation.set("eventdef", null);
        intRelation.set("evtsubscribe", null);
    }

    private List<Long> getMsgPublisherPkValue(DynamicObject intConfDyn, BizCategoryEnum categoryEnum) {
        ArrayList<Long> msgPubPkValueList = new ArrayList<Long>(16);
        if (intConfDyn != null) {
            DynamicObjectCollection bizMessageCollection = intConfDyn.getDynamicObjectCollection("bizmessage");
            for (DynamicObject bizMsg : bizMessageCollection) {
                msgPubPkValueList.add(bizMsg.getLong("fbasedataid_id"));
            }
        } else if (BizCategoryEnum.PERSON_ATTACHED.getCode().equals(categoryEnum.getCode())) {
            msgPubPkValueList.addAll(this.personMsgPublishSet);
        }
        return msgPubPkValueList;
    }
}

