/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.application.service.middle.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.enums.MetadataOperateTypeEnum;
import kd.hdtc.hrdbs.common.factory.ExecutorFactory;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.application.service.middle.IMidTableConfigApplicationService;
import kd.hdtc.hrdi.business.domain.config.IHRDIBaseConfigDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.business.domain.middle.entity.IMidTableConfigEntityService;
import kd.hdtc.hrdi.business.domain.middle.task.AsynInitMidTableConfigTask;

public class MidTableConfigApplicationServiceImpl
implements IMidTableConfigApplicationService {
    private static final Log log = LogFactory.getLog(MidTableConfigApplicationServiceImpl.class);
    private final IMidTableConfigDomainService midTableConfigDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableConfigDomainService.class);
    private final IHRDIBaseConfigDomainService baseConfigDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IHRDIBaseConfigDomainService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IIntSourceDomainService intSourceDomainService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IIntSourceDomainService.class);
    private final IMidTableConfigEntityService midTableConfigEntityService = kd.hdtc.hrdi.business.common.ServiceFactory.getService(IMidTableConfigEntityService.class);

    @Override
    public void synInitMidTable() {
        DynamicObject[] midTableConfigDyns = null;
        try (TXHandle txHandle = TX.required();){
            try {
                log.info("synInitMidTable start.");
                log.info("synInitMidTable synPresetDataFromMidTableTpl start.");
                midTableConfigDyns = this.midTableConfigDomainService.synPresetDataFromMidTableTpl();
                log.info("synInitMidTable synPresetDataFromMidTableTpl end.");
                this.intSourceDomainService.createIntSource(midTableConfigDyns);
                this.baseConfigDomainService.updateAutoGenerateMidTableConfig("0");
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
                txHandle.markRollback();
            }
        }
        try {
            List<DynamicObject> midTableList = this.getNeedGenerateMidTable();
            this.generateMetadata(midTableList.toArray(new DynamicObject[0]));
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
        log.info("synInitMidTable synInitMidTable end.");
    }

    private List<DynamicObject> getNeedGenerateMidTable() {
        DynamicObject[] midTables = this.midTableConfigEntityService.query("id,midentitynumber", new QFilter[]{QFilterConstants.Q_ENABLE});
        return Arrays.stream(midTables).filter(midTableDyn -> !MetadataUtils.isExist((String)midTableDyn.getString("midentitynumber"))).collect(Collectors.toList());
    }

    private void generateMetadata(DynamicObject[] midTableConfigDyns) {
        if (midTableConfigDyns == null) {
            return;
        }
        log.info("synInitMidTable generateMetadata start.");
        HashSet<Long> midTableIdSet = new HashSet<Long>(midTableConfigDyns.length);
        Arrays.stream(midTableConfigDyns).forEach(midTableConfig -> midTableIdSet.add(midTableConfig.getLong("id")));
        Map<Long, MetadataGenParam> metadataGenParamMap = this.midTableConfigDomainService.batchBuildGenParam(midTableIdSet);
        log.info("synInitMidTable generateMetadata end.");
        for (Map.Entry<Long, MetadataGenParam> entry : metadataGenParamMap.entrySet()) {
            entry.getValue().setMetadataOperateTypeEnum(MetadataOperateTypeEnum.DEPLOY);
            MetadataGenResult result = this.dynamicMetadataApplicationService.generate(entry.getValue());
            this.logGenResult(result, entry.getValue());
        }
    }

    @Override
    public void asynInitMidTable() {
        String autoGenerateMidTableConfig = this.baseConfigDomainService.getAutoGenerateMidTableConfig();
        if ("1".equals(autoGenerateMidTableConfig) && !AsynInitMidTableConfigTask.SYN_MIDTABLE_FLAG.get()) {
            AsynInitMidTableConfigTask.SYN_MIDTABLE_FLAG.set(Boolean.TRUE);
            ExecutorService commonExecutor = ExecutorFactory.getCommonExecutor();
            commonExecutor.execute(new AsynInitMidTableConfigTask());
        }
    }

    @Override
    public void clearByEntityObj(List<String> entityList) {
        this.intSourceDomainService.deleteByEntity(entityList);
        this.midTableConfigDomainService.deleteByEntity(entityList);
    }

    private void logGenResult(MetadataGenResult result, MetadataGenParam genParam) {
        String metadataName = genParam.getBaseParam().getMetadataName();
        String metadataNumber = genParam.getBaseParam().getMetadataNumber();
        StringBuilder logBuilder = new StringBuilder("MetadataGen ");
        logBuilder.append("metadataName:").append(metadataName).append(";metadataNumber:").append(metadataNumber);
        if (result.isSuccess()) {
            logBuilder.append(" success.");
            log.error(logBuilder.toString());
            return;
        }
        int errorCode = result.getErrorCode();
        List msgList = result.getMsgList();
        String msg = String.join((CharSequence)",", msgList);
        logBuilder.append(" error,errorCode:").append(errorCode).append(";errorMsg:").append(msg);
        log.error(logBuilder.toString());
    }
}

