/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IBizSyncAdaptor;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;
import kd.hdtc.hrdi.common.exception.HRDIBizException;

public class BizSyncAdaptorFactory {
    private static final Log LOG = LogFactory.getLog(BizSyncAdaptorFactory.class);
    private final IIntEntityCategoryDomainService domainService = ServiceFactory.getService(IIntEntityCategoryDomainService.class);
    private final IIntSceneRuleDomainService sceneRuleDomainService = ServiceFactory.getService(IIntSceneRuleDomainService.class);
    private static final Map<String, String> ADAPTOR_MAP = ImmutableMap.builder().put((Object)"haos_adminorgdetail", (Object)"kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.adminorg.AdminOrgAdaptor").put((Object)"hrpi_emp_integrate", (Object)"kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.person.PersonAdaptor").put((Object)"hbpm_position_api", (Object)"kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.position.PositionAdaptor").build();
    private static final String PERSON_ATTACHED_ADAPTOR = "kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.personattached.PersonAttachedAdaptor";
    private static final String COMMON_OP_ADAPTOR = "kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.op.CommonOpAdaptor";
    private static final String COMMON_MSERVICE_ADAPTOR = "kd.hdtc.hrdi.adaptor.inbound.biz.sceneadaptor.common.mservice.CommonMServiceAdaptor";

    public IBizSyncAdaptor getAdaptor(String entityNumber) {
        String adaptorClass;
        String writeType = this.getWriteType(entityNumber);
        switch (Objects.requireNonNull(writeType)) {
            case "1": {
                adaptorClass = this.getOpAdaptorClass();
                break;
            }
            case "2": {
                adaptorClass = this.getMServiceAdaptorClass();
                break;
            }
            default: {
                adaptorClass = this.getAdaptorClass(entityNumber);
            }
        }
        if (StringUtils.isEmpty((String)adaptorClass)) {
            throw new HRDIBizException("can not find adaptorclass, entityNumber:" + entityNumber);
        }
        return (IBizSyncAdaptor)TypesContainer.createInstance((String)adaptorClass);
    }

    private String getAdaptorClass(String entityNumber) {
        BizCategoryEnum bizCategoryEnum = this.domainService.getCategoryByEntityNumber(entityNumber);
        String adaptorClass = ADAPTOR_MAP.get(entityNumber);
        if (StringUtils.isNotEmpty((String)adaptorClass)) {
            return adaptorClass;
        }
        if (BizCategoryEnum.PERSON_ATTACHED.getCode().equals(bizCategoryEnum.getCode())) {
            adaptorClass = PERSON_ATTACHED_ADAPTOR;
        }
        return adaptorClass;
    }

    private String getOpAdaptorClass() {
        return COMMON_OP_ADAPTOR;
    }

    private String getMServiceAdaptorClass() {
        return COMMON_MSERVICE_ADAPTOR;
    }

    private String getWriteType(String entityNumber) {
        DynamicObject sceneRule = this.sceneRuleDomainService.getEnabledSceneRule(entityNumber);
        if (sceneRule == null) {
            return "0";
        }
        return sceneRule.getString("writetype");
    }
}

