/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.basedata.handle;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.business.handle.MapHandleEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.basedata.handle.BaseDataValidateHandle;
import kd.hdtc.hrdi.business.domain.adaptor.basedata.handle.IBaseDataSyncHandle;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;

public abstract class AbstractBaseDataSyncHandle
implements IBaseDataSyncHandle {
    private static final Log LOG = LogFactory.getLog(AbstractBaseDataSyncHandle.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    protected String entityNumber;
    protected String opType;
    protected String uniqueField;
    protected List<Map<String, Object>> data;

    public AbstractBaseDataSyncHandle(String entityNumber, String opType, String uniqueField, List<Map<String, Object>> data) {
        this.entityNumber = entityNumber;
        this.opType = opType;
        this.uniqueField = uniqueField;
        this.data = data;
    }

    @Override
    public Map<String, String> sync() {
        LOG.info("BaseDataSyncHandle sync start");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.entityNumber);
        MapHandleEntity mapOpHandleEntity = new MapHandleEntity(this.entityNumber, this.uniqueField, dataEntityType);
        List baseDataDynList = mapOpHandleEntity.handleData(this.data);
        Map<String, String> resultMap = this.doValidateHandle(baseDataDynList);
        this.updateOperateInfo(baseDataDynList);
        LOG.info("BaseDataSyncHandle sync baseDataDynList size:{}", (Object)baseDataDynList.size());
        Map<String, String> opResultMap = this.iBaseCommonDomainService.commonCallOp(this.opType, this.entityNumber, baseDataDynList);
        Map<String, String> newOpResultMap = this.parseResult(opResultMap, baseDataDynList);
        if (CollectionUtils.isNotEmpty(resultMap)) {
            newOpResultMap.putAll(resultMap);
        }
        return newOpResultMap;
    }

    private Map<String, String> parseResult(Map<String, String> opResultMap, List<DynamicObject> dynList) {
        boolean allFailed = opResultMap.containsKey("allFailed");
        if (!allFailed) {
            return opResultMap;
        }
        HashMap<String, String> newOpResultMap = new HashMap<String, String>(16);
        String msg = opResultMap.get("allFailed");
        dynList.forEach(dyn -> newOpResultMap.put(dyn.getString("id"), msg));
        return newOpResultMap;
    }

    private Map<String, String> doValidateHandle(List<DynamicObject> baseDataDynList) {
        BaseDataValidateHandle handle = new BaseDataValidateHandle(baseDataDynList, this.data, this.uniqueField);
        Map<String, String> resultMap = handle.validate();
        this.doFailDataHandle(baseDataDynList, resultMap);
        return resultMap;
    }

    private void doFailDataHandle(List<DynamicObject> baseDataDynList, Map<String, String> errorMap) {
        ArrayList failDynList = new ArrayList(10);
        baseDataDynList.forEach(baseDataDyn -> {
            if (errorMap.containsKey(baseDataDyn.getLong("id") + "")) {
                failDynList.add(baseDataDyn);
            }
        });
        baseDataDynList.removeAll(failDynList);
    }

    private void updateOperateInfo(List<DynamicObject> dys) {
        if (CollectionUtils.isNotEmpty(dys)) {
            List fieldNumberList = MetadataUtils.getFieldNumberList((String)dys.get(0).getDataEntityType().getName());
            dys.forEach(dy -> {
                if (fieldNumberList.contains("modifier")) {
                    dy.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
                }
                if (fieldNumberList.contains("creator")) {
                    dy.set("creator_id", (Object)RequestContext.get().getCurrUserId());
                }
                if (fieldNumberList.contains("modifytime")) {
                    dy.set("modifytime", (Object)new Date());
                }
                if (fieldNumberList.contains("createtime")) {
                    dy.set("createtime", (Object)new Date());
                }
            });
        }
    }
}

