/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.basedata.handle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.domain.adaptor.basedata.validate.IBaseDataValidator;
import kd.hdtc.hrdi.business.domain.adaptor.basedata.validate.impl.BaseDataExistsValidator;

public class BaseDataValidateHandle {
    private List<DynamicObject> baseDataDynList;
    private List<Map<String, Object>> dataList;
    private String uniqueField;
    private final List<IBaseDataValidator> validatorList = ImmutableList.of((Object)new BaseDataExistsValidator());

    public BaseDataValidateHandle(List<DynamicObject> baseDataDynList, List<Map<String, Object>> dataList, String uniqueField) {
        this.baseDataDynList = baseDataDynList;
        this.dataList = dataList;
        this.uniqueField = uniqueField;
    }

    public Map<String, String> validate() {
        HashMap<String, String> errorInfoMap = new HashMap<String, String>(16);
        if (CollectionUtils.isEmpty(this.baseDataDynList)) {
            return errorInfoMap;
        }
        Map<DynamicObject, Map<String, Object>> dynMap = this.buildBaseDataDynMap(this.baseDataDynList, this.dataList, this.uniqueField);
        this.validatorList.forEach(iBaseDataValidator -> {
            Map<String, String> resultMap = iBaseDataValidator.validate(dynMap, this.uniqueField);
            if (CollectionUtils.isNotEmpty(resultMap)) {
                this.resultHandle(resultMap, errorInfoMap);
            }
        });
        return errorInfoMap;
    }

    private Map<DynamicObject, Map<String, Object>> buildBaseDataDynMap(List<DynamicObject> baseDataDynList, List<Map<String, Object>> dataList, String uniqueField) {
        HashMap dynMap = Maps.newHashMapWithExpectedSize((int)baseDataDynList.size());
        Map<Object, DynamicObject> baseDataIdDynMap = baseDataDynList.stream().collect(Collectors.toMap(dyn -> dyn.get(uniqueField), dyn -> dyn, (k1, k2) -> k1));
        dataList.forEach(dataMap -> {
            Object uniqueValue = dataMap.get(uniqueField);
            DynamicObject baseDataDyn = (DynamicObject)baseDataIdDynMap.get(uniqueValue);
            dynMap.put(baseDataDyn, dataMap);
        });
        return dynMap;
    }

    private void resultHandle(Map<String, String> resultMap, Map<String, String> errorInfoMap) {
        resultMap.forEach((key, val) -> {
            String errorInfo = (String)errorInfoMap.get(key);
            errorInfo = StringUtils.isNotEmpty((String)errorInfo) ? errorInfo + val : val;
            errorInfoMap.put((String)key, errorInfo);
        });
    }
}

