/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.basedata.validate.impl;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.domain.adaptor.basedata.validate.IBaseDataValidator;

public class BaseDataExistsValidator
implements IBaseDataValidator {
    private final String BASE_DATA_EXISTS_ERROR = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u5bf9\u5e94\u7684\u503c\u201c%2$s\u201d\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BaseDataExistsValidator_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final Set<String> ignoreFieldSet = ImmutableSet.of((Object)"creator", (Object)"modifier", (Object)"disabler");

    @Override
    public Map<String, String> validate(Map<DynamicObject, Map<String, Object>> dynMap, String uniqueField) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        if (CollectionUtils.isEmpty(dynMap)) {
            return resultMap;
        }
        Map<String, String> baseDataFieldMap = this.getBaseDataFields(dynMap);
        if (CollectionUtils.isEmpty(baseDataFieldMap)) {
            return resultMap;
        }
        dynMap.forEach((baseDataDyn, dataMap) -> {
            String msg = this.doValidate((DynamicObject)baseDataDyn, (Map<String, Object>)dataMap, baseDataFieldMap);
            if (StringUtils.isNotEmpty((String)msg)) {
                resultMap.put(baseDataDyn.getLong("id") + "", msg);
            }
        });
        return resultMap;
    }

    private String doValidate(DynamicObject baseDataDyn, Map<String, Object> dataMap, Map<String, String> baseDataFieldMap) {
        StringBuilder stringBuilder = new StringBuilder();
        baseDataFieldMap.forEach((key, name) -> {
            Object value;
            if (!this.ignoreFieldSet.contains(key) && (value = dataMap.get(key)) != null && !value.equals("") && baseDataDyn.get(key) == null) {
                String errorInfo = String.format(Locale.ROOT, this.BASE_DATA_EXISTS_ERROR, name, value);
                stringBuilder.append(errorInfo);
            }
        });
        return stringBuilder.toString();
    }

    private Map<String, String> getBaseDataFields(Map<DynamicObject, Map<String, Object>> dynMap) {
        DynamicObject baseDataDyn = dynMap.keySet().iterator().next();
        List allEntityItems = MetadataUtils.getAllEntityItems((String)baseDataDyn.getDataEntityType().getName());
        HashMap<String, String> baseDataFieldMap = new HashMap<String, String>(16);
        allEntityItems.forEach(entityItem -> {
            if (entityItem instanceof BasedataField || entityItem instanceof MulBasedataField) {
                baseDataFieldMap.put(entityItem.getKey(), entityItem.getName().getLocaleValue());
            }
        });
        return baseDataFieldMap;
    }
}

