/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncBoBuilder;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncHandleBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncResultBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.PageSizeBo;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.bo.IntLogBuilder;
import kd.hdtc.hrdi.common.enums.OperateStatusEnum;

public class BizDataSyncBo
extends PageSizeBo {
    private static final Log LOG = LogFactory.getLog(BizDataSyncBo.class);
    protected final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    protected final IIntLogDomainService iIntLogDomainService = ServiceFactory.getService(IIntLogDomainService.class);
    protected String midTableNumber;
    protected String bizEntityNumber;
    protected String synType;
    protected String batchNumber;
    protected List<Long> intMiddleIdList;
    protected BizDataSyncResultBo resultBo;
    protected DynamicObject[] midTableDyns;
    protected DynamicObject parentIntLog;

    protected BizDataSyncBo(BizDataSyncBoBuilder builder) {
        this.midTableNumber = builder.getMidTableNumber();
        this.bizEntityNumber = builder.getBizEntityNumber();
        this.batchNumber = builder.getBatchNumber();
        this.intMiddleIdList = builder.getIntMiddleIdList();
        this.midTableDyns = builder.getMidTableDyns();
        this.synType = builder.getSynType();
        this.resultBo = new BizDataSyncResultBo();
        this.parentIntLog = new IntLogBuilder().setEntityNumber(this.bizEntityNumber).setBatchNumber(this.batchNumber).setOperateStatus(OperateStatusEnum.PROCCESSING.getCode()).setDataCount(0L).build();
    }

    public String getSynType() {
        return this.synType;
    }

    public BizDataSyncResultBo syncBiz() {
        LOG.info(ResManager.loadKDString((String)"HRDI\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u5206\u9875\u5904\u7406\uff0c midTableNumber = {}, bizEntityNumber={}, batchNumber= {},", (String)"BizDataSyncBo1", (String)"hdtc-hrdi-business", (Object[])new Object[0]), new Object[]{this.midTableNumber, this.bizEntityNumber, this.batchNumber});
        this.initPage();
        LOG.info("save midTable, count={}", (Object)this.getCount());
        this.parentIntLog.set("datacount", (Object)this.getCount());
        this.iIntLogDomainService.saveIntLog(this.parentIntLog);
        while (this.pageIndex < this.getPageCount()) {
            BizDataSyncHandleBo bizDataSyncHandleBo = new BizDataSyncHandleBo(this);
            bizDataSyncHandleBo.doSync();
            ++this.pageIndex;
        }
        this.iIntLogDomainService.updateIntLog(this.parentIntLog.getLong("id"), OperateStatusEnum.ALL_SUCCESS.getCode(), "", new Date());
        this.resultBo.setSuccessCount(this.getCount() - this.resultBo.getFailCount());
        return this.resultBo;
    }

    @Override
    public void initPage() {
        QFilter qFilter = this.buildQFilter();
        this.setCount(this.iBaseCommonDomainService.count(this.midTableNumber, qFilter.toArray()));
        super.initPage();
    }

    protected QFilter buildQFilter() {
        QFilter intStatusFilter = new QFilter("hrdiintstatus", "in", Arrays.asList("1", "0"));
        QFilter isExceptionFilter = new QFilter("is_exception", "=", (Object)Boolean.FALSE);
        intStatusFilter.and(isExceptionFilter);
        if (StringUtils.isNotEmpty((String)this.batchNumber)) {
            QFilter batchFilter = new QFilter("hrdibatchnumber", "=", (Object)this.batchNumber);
            intStatusFilter.and(batchFilter);
        }
        if (CollectionUtils.isNotEmpty(this.intMiddleIdList)) {
            QFilter idFilter = new QFilter("id", "in", this.intMiddleIdList);
            intStatusFilter.and(idFilter);
        }
        return intStatusFilter;
    }

    public String getMidTableNumber() {
        return this.midTableNumber;
    }

    public String getBizEntityNumber() {
        return this.bizEntityNumber;
    }

    public String getBatchNumber() {
        return this.batchNumber;
    }

    public BizDataSyncResultBo getResultBo() {
        return this.resultBo;
    }

    public void setResultBo(BizDataSyncResultBo resultBo) {
        this.resultBo = resultBo;
    }

    public DynamicObject[] getMidTableDyns() {
        return this.midTableDyns;
    }
}

