/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.BizSyncAdaptorFactory;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncDataMappingBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncResultBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.MidTableDataValidateHandle;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntRowResult;
import kd.hdtc.hrdi.business.domain.adaptor.covert.IRefSelfFieldCovert;
import kd.hdtc.hrdi.business.domain.adaptor.covert.RefSelfFieldCovertFactory;
import kd.hdtc.hrdi.business.domain.adaptor.handle.IMidHandle;
import kd.hdtc.hrdi.business.domain.adaptor.handle.MidOpHandleFactory;
import kd.hdtc.hrdi.business.domain.common.IBaseCommonDomainService;
import kd.hdtc.hrdi.business.domain.datamapping.IDataMappingDomainService;
import kd.hdtc.hrdi.business.domain.datamapping.entity.DataMappingFactory;
import kd.hdtc.hrdi.business.domain.datamapping.entity.IDataMappingEntityService;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.business.domain.monitor.IIntLogDomainService;
import kd.hdtc.hrdi.business.domain.monitor.bo.IntLogBuilder;
import kd.hdtc.hrdi.common.enums.OperateStatusEnum;
import kd.hdtc.hrdi.common.enums.SynTypeEnum;
import kd.hdtc.hrdi.common.pojo.DataMapping;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hdtc.hrdi.common.pojo.MidTableConfigField;

public class BizDataSyncHandleBo {
    private static final Log LOG = LogFactory.getLog(BizDataSyncHandleBo.class);
    private final IBaseCommonDomainService iBaseCommonDomainService = ServiceFactory.getService(IBaseCommonDomainService.class);
    private final IDataMappingDomainService iDataMappingDomainService = ServiceFactory.getService(IDataMappingDomainService.class);
    private final IIntSourceSysDomainService iIntSourceSysDomainService = ServiceFactory.getService(IIntSourceSysDomainService.class);
    private final String SERVICE_ERROR = ResManager.loadKDString((String)"\u670d\u52a1\u5f02\u5e38", (String)"BizDataSyncHandleBo_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final String PARTIALL_SUCCESS_MSG = ResManager.loadKDString((String)"\u540c\u6b65\u603b\u6761\u6570\uff1a%1$s\uff0c\u5176\u4e2d\u540c\u6b65\u6210\u529f%2$s\u6761\uff0c\u540c\u6b65\u5931\u8d25%3$s\u6761", (String)"BizDataSyncHandleBo_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final String ALL_FAIL_MSG = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\u603b\u6761\u6570\uff1a%s", (String)"BizDataSyncHandleBo_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final IIntLogDomainService iIntLogDomainService = ServiceFactory.getService(IIntLogDomainService.class);
    private final IMidTableConfigDomainService midTableConfigDomainService = ServiceFactory.getService(IMidTableConfigDomainService.class);
    private final IIntSourceSysDomainService sourceSysDomainService = ServiceFactory.getService(IIntSourceSysDomainService.class);
    private final String midTableNumber;
    private final String bizEntityNumber;
    private final BizDataSyncBo bizDataSyncBo;
    private final BizDataSyncResultBo resultBo;
    private final DynamicObject parentIntLog;

    public BizDataSyncHandleBo(BizDataSyncBo bizDataSyncBo) {
        this.midTableNumber = bizDataSyncBo.getMidTableNumber();
        this.bizEntityNumber = bizDataSyncBo.getBizEntityNumber();
        this.bizDataSyncBo = bizDataSyncBo;
        this.parentIntLog = bizDataSyncBo.parentIntLog;
        this.resultBo = this.bizDataSyncBo.getResultBo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSync() {
        IntBizSyncContext.create(this.midTableNumber, this.bizEntityNumber);
        this.initContext();
        DynamicObject[] midDys = this.getMidTableData();
        this.updateIntLogSourceSys(midDys);
        DynamicObject[] newMidDys = this.repeatDataHandle(midDys);
        DynamicObject intLog = this.saveIntLog(newMidDys);
        try {
            this.handleData(newMidDys);
            this.iIntLogDomainService.updateIntLog(intLog.getLong("id"), this.getOperateStatus(newMidDys.length).getCode(), this.getOperateMsg(newMidDys.length), new Date());
        }
        catch (Error | Exception e) {
            LOG.error("BizDataSyncHandle exception, errorMsg:", e);
            String msg = ThrowableUtils.toString((Throwable)e);
            this.iIntLogDomainService.updateIntLog(intLog.getLong("id"), OperateStatusEnum.SERVICE_EXCEPTION.getCode(), msg, new Date());
            this.exceptionResultHandle(this.SERVICE_ERROR, newMidDys);
        }
        finally {
            IntBizSyncContext.remove();
        }
    }

    private void updateIntLogSourceSys(DynamicObject[] midDys) {
        if (midDys == null) {
            return;
        }
        String sourceSys = midDys[0].getString("hrdisourcesys");
        this.parentIntLog.set("sourcesys", (Object)this.sourceSysDomainService.queryByNumber(sourceSys));
        this.iIntLogDomainService.saveIntLog(this.parentIntLog);
    }

    private OperateStatusEnum getOperateStatus(long dataCount) {
        long failCount = this.resultBo.getFailCount();
        if (dataCount == failCount) {
            return OperateStatusEnum.ALL_FAIL;
        }
        if (failCount == 0L) {
            return OperateStatusEnum.ALL_SUCCESS;
        }
        return OperateStatusEnum.PARTIALL_SUCCESS;
    }

    private String getOperateMsg(long dataCount) {
        long failCount = this.resultBo.getFailCount();
        if (dataCount == failCount) {
            return String.format(Locale.ROOT, this.ALL_FAIL_MSG, failCount);
        }
        if (failCount == 0L) {
            return "";
        }
        return String.format(Locale.ROOT, this.PARTIALL_SUCCESS_MSG, dataCount, dataCount - failCount, failCount);
    }

    public void doRetrySync() {
        IntBizSyncContext.create(this.midTableNumber, this.bizEntityNumber);
        this.initContext();
        Object[] midDys = this.getMidTableData();
        if (ArrayUtils.isEmpty((Object[])midDys)) {
            this.iIntLogDomainService.updateIntLogRetryCount(this.parentIntLog);
            this.iIntLogDomainService.updateIntLog(this.parentIntLog.getLong("id"), OperateStatusEnum.ALL_SUCCESS.getCode(), "", new Date());
            return;
        }
        DynamicObject[] newMidDys = this.repeatDataHandle((DynamicObject[])midDys);
        try {
            this.iIntLogDomainService.updateIntLogRetryCount(this.parentIntLog);
            this.handleData(newMidDys);
            this.iIntLogDomainService.updateIntLog(this.parentIntLog.getLong("id"), this.getOperateStatus(newMidDys.length).getCode(), this.getOperateMsg(newMidDys.length), new Date());
        }
        catch (Error | Exception e) {
            LOG.error("handleData error:", e);
            this.iIntLogDomainService.updateIntLog(this.parentIntLog.getLong("id"), OperateStatusEnum.SERVICE_EXCEPTION.getCode(), ThrowableUtils.toString((Throwable)e), new Date());
            this.exceptionResultHandle(this.SERVICE_ERROR, newMidDys);
        }
        IntBizSyncContext.remove();
    }

    private void handleData(DynamicObject[] newMidDys) {
        LOG.info("BizDataSyncHandleBo handleData start.");
        IMidHandle iMidHandle = MidOpHandleFactory.getMidOpHandle(this.bizEntityNumber, "hrdisourcesyskey", this.midTableNumber);
        Map<String, Object> objectMap = iMidHandle.handleData(newMidDys, IntBizSyncContext.get().getMidTableConfig());
        List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList = this.convertToDataMappingBoList(newMidDys, objectMap);
        this.packageDataMapping(bizDataSyncDataMappingBoList);
        this.handleRefSelf(bizDataSyncDataMappingBoList);
        bizDataSyncDataMappingBoList = this.handleMidTableDataValidate(bizDataSyncDataMappingBoList);
        if (CollectionUtils.isEmpty(bizDataSyncDataMappingBoList)) {
            LOG.error("validate midTableData all failed.");
            return;
        }
        this.packageContextParam(bizDataSyncDataMappingBoList);
        new BizSyncAdaptorFactory().getAdaptor(this.bizEntityNumber).sync();
        this.resultHandle();
    }

    private void initContext() {
        this.initMidTableConfig();
        this.initBizEntityInfo();
        this.initEntryIntField();
    }

    private void initEntryIntField() {
        MidTableConfig midTableConfig = IntBizSyncContext.get().getMidTableConfig();
        Set intFieldSet = midTableConfig.getFieldConfigList().stream().filter(MidTableConfigField::isIntField).map(MidTableConfigField::getEntityNumber).collect(Collectors.toSet());
        Map<String, String> entryFieldMap = IntBizSyncContext.get().getEntryFieldMap();
        boolean entryIntField = false;
        for (String entryField : entryFieldMap.keySet()) {
            if (!intFieldSet.contains(entryField)) continue;
            entryIntField = true;
            break;
        }
        IntBizSyncContext.get().setEntryIntField(entryIntField);
    }

    private void initBizEntityInfo() {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)IntBizSyncContext.get().getBizEntityNumber());
        Map allFieldMap = mainEntityType.getAllFields();
        ArrayList<String> billHeadFieldList = new ArrayList<String>(10);
        HashMap<String, String> entryFieldMap = new HashMap<String, String>(16);
        allFieldMap.forEach((field, prop) -> {
            IDataEntityType parent = prop.getParent();
            if (parent instanceof EntryType) {
                entryFieldMap.put((String)field, parent.getName());
            } else {
                billHeadFieldList.add((String)field);
            }
        });
        IntBizSyncContext.get().setBillHeadFieldList(billHeadFieldList);
        IntBizSyncContext.get().setEntryFieldMap(entryFieldMap);
    }

    private void initMidTableConfig() {
        IntBizSyncContext.get().setMidTableConfig(this.midTableConfigDomainService.getMidTableConfigByBizNumber(this.bizEntityNumber));
    }

    protected DynamicObject[] getMidTableData() {
        return this.iBaseCommonDomainService.queryPageCollection(this.midTableNumber, DynamicObjectUtils.getFieldByPage((String)this.midTableNumber), this.bizDataSyncBo.buildQFilter().toArray(), this.bizDataSyncBo.getPageIndex(), this.bizDataSyncBo.getPageSize());
    }

    private DynamicObject saveIntLog(DynamicObject[] newMidDys) {
        DynamicObject childIntLog = new IntLogBuilder().setParent(this.parentIntLog).setEntityNumber(this.bizEntityNumber).setBatchNumber(this.bizDataSyncBo.getBatchNumber()).setOperateStatus(OperateStatusEnum.PROCCESSING.getCode()).setDataCount(Long.valueOf(newMidDys.length)).setStartNumber(this.getStartNumber(newMidDys)).setEndNumber(this.getEndNumber(newMidDys)).setSourceSys(newMidDys[0].getString("hrdisourcesys")).setSelectNumberList(this.getSelectNumberList(newMidDys)).build();
        this.iIntLogDomainService.saveIntLog(childIntLog);
        LOG.info("saveIntLog batchNumber: {}, bizEntityNumber:{}", (Object)this.bizDataSyncBo.getBatchNumber(), (Object)this.bizEntityNumber);
        return childIntLog;
    }

    private List<String> getSelectNumberList(DynamicObject[] newMidDys) {
        if (SynTypeEnum.MIDDLE_MANUAL_RETRY.getCode().equals(this.bizDataSyncBo.getSynType())) {
            return Stream.of(newMidDys).map(dy -> dy.getString("hrdinumber")).collect(Collectors.toList());
        }
        return null;
    }

    private String getStartNumber(DynamicObject[] newMidDys) {
        if (SynTypeEnum.NEW.getCode().equals(this.bizDataSyncBo.getSynType())) {
            DynamicObject newMidDy = Arrays.stream(newMidDys).min(Comparator.comparing(dd -> dd.getString("hrdinumber"))).get();
            return newMidDy.getString("hrdinumber");
        }
        return "";
    }

    private String getEndNumber(DynamicObject[] newMidDys) {
        if (SynTypeEnum.NEW.getCode().equals(this.bizDataSyncBo.getSynType())) {
            DynamicObject newMidDy = Arrays.stream(newMidDys).max(Comparator.comparing(dd -> dd.getString("hrdinumber"))).get();
            return newMidDy.getString("hrdinumber");
        }
        return "";
    }

    private void handleRefSelf(List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList) {
        LOG.info("BizDataSyncHandleBo packageDataMapping start.");
        IRefSelfFieldCovert refSelfFieldCovert = RefSelfFieldCovertFactory.getRefSelfFieldCovert(this.midTableNumber, this.bizEntityNumber, bizDataSyncDataMappingBoList);
        refSelfFieldCovert.covert();
    }

    private DynamicObject[] repeatDataHandle(DynamicObject[] midDys) {
        if (IntBizSyncContext.get().isEntryIntField()) {
            return midDys;
        }
        Map<String, List<DynamicObject>> groupMap = Arrays.stream(midDys).collect(Collectors.groupingBy(dyn -> dyn.getString("hrdibatchnumber") + dyn.getString("hrdisourcesys") + dyn.getString("hrdisourcesyskey")));
        ArrayList<DynamicObject> repeatDynList = new ArrayList<DynamicObject>();
        ArrayList noRepeatDynList = new ArrayList();
        groupMap.forEach((key, dynList) -> {
            int size = dynList.size();
            if (size > 1) {
                noRepeatDynList.add(dynList.get(size - 1));
                dynList.remove(size - 1);
                repeatDynList.addAll((Collection<DynamicObject>)dynList);
            } else {
                noRepeatDynList.addAll(dynList);
            }
        });
        this.saveRepeatDataStatus(repeatDynList);
        return noRepeatDynList.toArray(new DynamicObject[0]);
    }

    private void saveRepeatDataStatus(List<DynamicObject> repeatDynList) {
        if (CollectionUtils.isEmpty(repeatDynList)) {
            return;
        }
        repeatDynList.forEach(repeatDyn -> repeatDyn.set("hrdiintstatus", (Object)"-1"));
        this.iBaseCommonDomainService.save(repeatDynList);
    }

    private List<BizDataSyncDataMappingBo> handleMidTableDataValidate(List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList) {
        LOG.info("BizDataSyncHandleBo validateMidTableData start.");
        Map<Long, String> resultMap = new MidTableDataValidateHandle().doValidate(bizDataSyncDataMappingBoList);
        if (CollectionUtils.isEmpty(resultMap)) {
            return bizDataSyncDataMappingBoList;
        }
        LOG.info("BizDataSyncHandleBo validateMidTableData datasize:{}, result:{}", (Object)bizDataSyncDataMappingBoList.size(), (Object)resultMap.toString());
        return this.parseResultMap(resultMap, bizDataSyncDataMappingBoList);
    }

    private List<BizDataSyncDataMappingBo> parseResultMap(Map<Long, String> resultMap, List<BizDataSyncDataMappingBo> allBizDataSyncBoList) {
        ArrayList newBizDataSyncBoList = Lists.newArrayListWithExpectedSize((int)resultMap.size());
        ArrayList allErrorDataList = Lists.newArrayListWithExpectedSize((int)resultMap.size());
        allBizDataSyncBoList.forEach(bizDataSyncDataMappingBo -> {
            List<DynamicObject> failMidDataList = this.getFailMidData(resultMap, (BizDataSyncDataMappingBo)bizDataSyncDataMappingBo);
            allErrorDataList.addAll(failMidDataList);
            List<DynamicObject> midDynList = bizDataSyncDataMappingBo.getMidDynamicObjectList();
            midDynList.removeAll(failMidDataList);
            if (CollectionUtils.isNotEmpty(midDynList)) {
                newBizDataSyncBoList.add(bizDataSyncDataMappingBo);
            }
        });
        this.updateMidTableErrorInfo(allErrorDataList);
        return newBizDataSyncBoList;
    }

    private List<DynamicObject> getFailMidData(Map<Long, String> resultMap, BizDataSyncDataMappingBo bizDataSyncDataMappingBo) {
        ArrayList<DynamicObject> errorMidDataList = new ArrayList<DynamicObject>(16);
        List<DynamicObject> midDynList = bizDataSyncDataMappingBo.getMidDynamicObjectList();
        midDynList.forEach(midDataDyn -> {
            String errorInfo = (String)resultMap.get(midDataDyn.getLong("id"));
            if (StringUtils.isNotEmpty((String)errorInfo)) {
                midDataDyn.set("hrdiintstatus", (Object)"1");
                midDataDyn.set("is_exception", (Object)Boolean.FALSE);
                DynamicObjectUtils.setBigText((DynamicObject)midDataDyn, (String)"interrormsg", (String)errorInfo);
                errorMidDataList.add((DynamicObject)midDataDyn);
                this.resultBo.addErrorMsg(midDataDyn.getString("hrdisourcesyskey"), errorInfo);
            }
        });
        return errorMidDataList;
    }

    protected void updateMidTableErrorInfo(List<DynamicObject> errorMidTableDataList) {
        this.iBaseCommonDomainService.save(errorMidTableDataList);
    }

    private void exceptionResultHandle(String errorMsg, DynamicObject[] midDyns) {
        Map idAndDyMap = Stream.of(midDyns).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        List<IntRowResult> intRowResultList = IntBizSyncContext.get().getIntRowResultList();
        ArrayList allErrorMidDynList = Lists.newArrayListWithExpectedSize((int)midDyns.length);
        if (CollectionUtils.isEmpty(intRowResultList)) {
            Stream.of(midDyns).forEach(midDyn -> {
                this.fillMidData((DynamicObject)midDyn, "1", Boolean.TRUE, errorMsg);
                allErrorMidDynList.add(midDyn);
            });
        } else {
            intRowResultList.forEach(intRowResult -> {
                List<DynamicObject> errorDynList;
                List<DynamicObject> midDynamicObjectList = intRowResult.getBizDataSyncDataMappingBo().getMidDynamicObjectList();
                if (intRowResult.getSuccess() == null || intRowResult.getException().booleanValue()) {
                    errorDynList = this.rowResultHandle(midDynamicObjectList, idAndDyMap, "1", Boolean.TRUE, errorMsg);
                } else {
                    String intStatus2 = Boolean.TRUE.equals(intRowResult.getSuccess()) ? "2" : "1";
                    errorDynList = this.rowResultHandle(midDynamicObjectList, idAndDyMap, intStatus2, intRowResult.getException(), intRowResult.getErrorMsg());
                }
                allErrorMidDynList.addAll(errorDynList);
            });
        }
        this.updateMidTableErrorInfo(allErrorMidDynList);
    }

    private List<DynamicObject> rowResultHandle(List<DynamicObject> midDynList, Map<Long, DynamicObject> idAndDyMap, String intStatus2, boolean exception, String errorMsg) {
        ArrayList<DynamicObject> errorMidDynList = new ArrayList<DynamicObject>(10);
        midDynList.forEach(dd -> {
            DynamicObject midDyn = (DynamicObject)idAndDyMap.get(dd.getLong("id"));
            if (midDyn != null) {
                this.fillMidData(midDyn, intStatus2, exception, errorMsg);
                errorMidDynList.add(midDyn);
            }
        });
        return errorMidDynList;
    }

    private void fillMidData(DynamicObject midDyn, String intStatus2, boolean exception, String errorMsg) {
        midDyn.set("hrdiintstatus", (Object)intStatus2);
        midDyn.set("is_exception", (Object)exception);
        DynamicObjectUtils.setBigText((DynamicObject)midDyn, (String)"interrormsg", (String)errorMsg);
        if ("1".equals(intStatus2)) {
            this.resultBo.addErrorMap(midDyn.getString("hrdisourcesyskey"), errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resultHandle() {
        LOG.info("BizDataSyncHandleBo resultHandle start.");
        List<IntRowResult> intRowResultList = IntBizSyncContext.get().getIntRowResultList();
        Set<Long> idSet = intRowResultList.stream().map(IntRowResult::getBizDataSyncDataMappingBo).map(BizDataSyncDataMappingBo::getMidDynamicObjectList).flatMap(Collection::stream).map(it -> it.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> midDyList = this.iBaseCommonDomainService.query(IntBizSyncContext.get().getMidTableNumber(), "is_exception,hrdiintstatus,interrormsg,interrormsg_tag,hrdisourcesyskey", idSet);
        Map dyMap = midDyList.stream().collect(Collectors.toMap(it -> it.getLong("id"), Function.identity(), (o1, o2) -> o1));
        for (IntRowResult intRowResult : intRowResultList) {
            intRowResult.getBizDataSyncDataMappingBo().getMidDynamicObjectList().forEach(it -> {
                DynamicObject dynamicObject = (DynamicObject)dyMap.get(it.getLong("id"));
                this.addResultInfo(dynamicObject, intRowResult);
            });
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.iBaseCommonDomainService.save(midDyList);
            IDataMappingEntityService dataMappingEntityService = new DataMappingFactory().getDataMappingEntityService(this.bizEntityNumber);
            dataMappingEntityService.updateDataMappingEffectiveStatus(intRowResultList);
        }
    }

    protected void buildSyncResult(List<IntRowResult> intRowResultList) {
        intRowResultList.forEach(intRowResult -> {
            if (!intRowResult.getSuccess().booleanValue()) {
                String errorMsg = intRowResult.getErrorMsg();
                List<DynamicObject> midDynList = intRowResult.getBizDataSyncDataMappingBo().getMidDynamicObjectList();
                midDynList.forEach(midDyn -> this.resultBo.addErrorMap(midDyn.getString("hrdisourcesyskey"), errorMsg));
            }
        });
    }

    private void addResultInfo(DynamicObject dynamicObject, IntRowResult intRowResult) {
        dynamicObject.set("is_exception", (Object)intRowResult.getException());
        if (intRowResult.getSuccess().booleanValue()) {
            dynamicObject.set("hrdiintstatus", (Object)"2");
            DynamicObjectUtils.setBigText((DynamicObject)dynamicObject, (String)"interrormsg", (String)"");
        } else {
            dynamicObject.set("hrdiintstatus", (Object)"1");
            String errorMsg = intRowResult.getErrorMsg();
            DynamicObjectUtils.setBigText((DynamicObject)dynamicObject, (String)"interrormsg", (String)errorMsg);
            this.resultBo.addErrorMsg(dynamicObject.getString("hrdisourcesyskey"), errorMsg);
        }
    }

    private void packageContextParam(List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList) {
        LOG.info("BizDataSyncHandleBo packageContextParam start.");
        IntBizSyncContext context = IntBizSyncContext.get();
        bizDataSyncDataMappingBoList.forEach(it -> context.addResult(new IntRowResult((BizDataSyncDataMappingBo)it)));
    }

    private void packageDataMapping(List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList) {
        LOG.info("BizDataSyncHandleBo packageDataMapping start.");
        Set<String> sourceSysNumberSet = bizDataSyncDataMappingBoList.stream().map(dy -> dy.getMidDynamicObjectList().get(0).getString("hrdisourcesys")).collect(Collectors.toSet());
        Map<String, DynamicObject> sysNumberSourceSysMap = this.iIntSourceSysDomainService.querySourceSysByNumberList(sourceSysNumberSet);
        List<DataMapping> dataMappingList = bizDataSyncDataMappingBoList.stream().map(dy -> dy.toQueryMapping(sysNumberSourceSysMap)).collect(Collectors.toList());
        Map dataMappingMap = dataMappingList.stream().collect(Collectors.toMap(DataMapping::getDataMappingKey, Function.identity(), (o1, o2) -> o1));
        List<DataMapping> dmList = this.iDataMappingDomainService.query(dataMappingList);
        IDataMappingEntityService dataMappingEntityService = new DataMappingFactory().getDataMappingEntityService(this.bizEntityNumber);
        for (DataMapping dm : dmList) {
            DataMapping dataMapping = (DataMapping)dataMappingMap.get(dm.getDataMappingKey());
            dataMapping.setBizDataKey(dm.getBizDataKey());
            dataMappingEntityService.setDataMappingOtherField(dm, dataMapping);
        }
        ArrayList needSetInfoDataMappingList = Lists.newArrayListWithExpectedSize((int)dataMappingList.size());
        ArrayList needSaveDataMappingList = Lists.newArrayListWithExpectedSize((int)dataMappingList.size());
        dataMappingList.forEach(it -> {
            if (Objects.isNull(it.getBizDataKey())) {
                needSetInfoDataMappingList.add(it);
            } else if (it.getEffectiveStatus() != null && it.getEffectiveStatus().equals("4")) {
                it.setEffectiveStatus("1");
                needSaveDataMappingList.add(it);
            }
        });
        needSetInfoDataMappingList.forEach(it -> it.setBizDataKey(Long.valueOf(ID.genLongId())));
        dataMappingEntityService.addDataMappingOtherFieldId(needSetInfoDataMappingList, bizDataSyncDataMappingBoList);
        needSaveDataMappingList.addAll(needSetInfoDataMappingList);
        this.iDataMappingDomainService.save(needSaveDataMappingList);
        bizDataSyncDataMappingBoList.forEach(BizDataSyncDataMappingBo::setMappingIdToBizDy);
    }

    private List<BizDataSyncDataMappingBo> convertToDataMappingBoList(DynamicObject[] midDys, Map<String, Object> objectMap) {
        LOG.info("BizDataSyncHandleBo convertToDataMappingBoList start.");
        Map<Long, DynamicObject> midDyMap = Arrays.stream(midDys).collect(Collectors.toMap(it -> it.getLong("id"), Function.identity(), (o1, o2) -> o1));
        List dyList = (List)objectMap.get("data");
        Map dyMap = dyList.stream().collect(Collectors.toMap(it -> it.getLong("id"), Function.identity(), (o1, o2) -> o1));
        Map idMappingMap = (Map)objectMap.get("idmapping");
        ArrayList bizDataSyncDataMappingBoList = Lists.newArrayListWithExpectedSize((int)idMappingMap.size());
        for (Map.Entry entry : idMappingMap.entrySet()) {
            bizDataSyncDataMappingBoList.add(new BizDataSyncDataMappingBo(BizDataSyncHandleBo.getMidDyList(midDyMap, (Set)entry.getValue()), (DynamicObject)dyMap.get(entry.getKey())));
        }
        return bizDataSyncDataMappingBoList;
    }

    private static List<DynamicObject> getMidDyList(Map<Long, DynamicObject> midDyMap, Set<Long> idSet) {
        return idSet.stream().map(midDyMap::get).collect(Collectors.toList());
    }

    public BizDataSyncBo getBizDataSyncBo() {
        return this.bizDataSyncBo;
    }
}

