/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.IMidTableDataValidator;
import kd.hdtc.hrdi.business.domain.adaptor.context.IntBizSyncContext;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hdtc.hrdi.common.pojo.MidTableConfigField;

public class BaseDataExistsValidator
implements IMidTableDataValidator {
    private final String BASE_DATA_EXISTS_ERROR = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u5bf9\u5e94\u7684\u503c\u201c%2$s\u201d\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BaseDataExistsValidator_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);

    @Override
    public Map<Long, String> validate(Map<DynamicObject, List<DynamicObject>> dynMap) {
        Map<String, Map<String, DynamicObject>> basedataMappingMap = IntBizSyncContext.get().getBasedataMappingMap();
        Set<String> mulBasedataFieldSet = IntBizSyncContext.get().getMulBasedataFieldSet();
        List<MidTableConfigField> baseDataExistsFieldConfigList = this.getBaseDataExistsFieldConfig();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        if (CollectionUtils.isNotEmpty(baseDataExistsFieldConfigList)) {
            dynMap.forEach((bizDyn, midDynList) -> {
                ArrayList midDynIdList = new ArrayList(10);
                StringBuilder msgBuilder = new StringBuilder();
                midDynList.forEach(midDyn -> {
                    msgBuilder.append(this.validateExists((DynamicObject)midDyn, baseDataExistsFieldConfigList, mulBasedataFieldSet, basedataMappingMap));
                    midDynIdList.add(midDyn.getLong("id"));
                });
                String errorInfo = msgBuilder.toString();
                if (StringUtils.isNotEmpty((String)errorInfo)) {
                    midDynIdList.forEach(midDynId -> resultMap.put((Long)midDynId, errorInfo));
                }
            });
        }
        return resultMap;
    }

    private String validateExists(DynamicObject midDyn, List<MidTableConfigField> baseDataExistsFieldConfigList, Set<String> mulBasedataFieldSet, Map<String, Map<String, DynamicObject>> basedataMappingMap) {
        StringBuilder msgBuilder = new StringBuilder();
        for (MidTableConfigField fieldConfig : baseDataExistsFieldConfigList) {
            String field = fieldConfig.getNumberAlias();
            String baseDataValue = midDyn.getString(field);
            if (StringUtils.isEmpty((String)baseDataValue)) continue;
            Map<String, DynamicObject> basedataValueMap = basedataMappingMap.get(field);
            if (basedataValueMap == null) {
                msgBuilder.append(this.buildErrorMsg(fieldConfig, baseDataValue));
                continue;
            }
            if (mulBasedataFieldSet.contains(field)) {
                msgBuilder.append(this.validateMulBasedata(fieldConfig, basedataValueMap, baseDataValue));
                continue;
            }
            msgBuilder.append(this.validateBasedata(fieldConfig, basedataValueMap, baseDataValue));
        }
        return msgBuilder.toString();
    }

    private String validateBasedata(MidTableConfigField fieldConfig, Map<String, DynamicObject> basedataValueMap, String baseDataValue) {
        if (basedataValueMap.get(baseDataValue) == null) {
            return this.buildErrorMsg(fieldConfig, baseDataValue);
        }
        return "";
    }

    private String validateMulBasedata(MidTableConfigField fieldConfig, Map<String, DynamicObject> basedataValueMap, String baseDataValue) {
        StringBuilder errorMsg = new StringBuilder();
        Arrays.stream(baseDataValue.split(",")).forEach(value -> {
            if (basedataValueMap.get(value) == null) {
                errorMsg.append(this.buildErrorMsg(fieldConfig, baseDataValue));
            }
        });
        return errorMsg.toString();
    }

    private String buildErrorMsg(MidTableConfigField fieldConfig, String baseDataValue) {
        String entityName = fieldConfig.getEntityName();
        if (!StringUtils.isEmpty((String)entityName) && entityName.endsWith("*")) {
            entityName = entityName.substring(0, entityName.length() - 1);
        }
        return String.format(Locale.ROOT, this.BASE_DATA_EXISTS_ERROR, entityName, baseDataValue);
    }

    private List<MidTableConfigField> getBaseDataExistsFieldConfig() {
        MidTableConfig midTableConfig = IntBizSyncContext.get().getMidTableConfig();
        ArrayList<MidTableConfigField> baseDataExistsFieldConfigList = new ArrayList<MidTableConfigField>(16);
        midTableConfig.getFieldConfigList().forEach(fieldConfig -> {
            if (fieldConfig.isIntField() && fieldConfig.isBaseData() && fieldConfig.isValidateExist()) {
                baseDataExistsFieldConfigList.add((MidTableConfigField)fieldConfig);
            }
        });
        return baseDataExistsFieldConfigList;
    }
}

