/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo.validate;

import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncBoBuilder;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncHandleBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncResultBo;

public class BizDataRetrySyncBo
extends BizDataSyncBo {
    private static final Log LOG = LogFactory.getLog(BizDataRetrySyncBo.class);
    private String startNumber;
    private String endNumber;
    private String[] selectNumbers;

    public BizDataRetrySyncBo(Long intLogId, BizDataSyncBoBuilder bizDataSyncBoBuilder, String startNumber, String endNumber, String selectNumber) {
        super(bizDataSyncBoBuilder);
        this.startNumber = startNumber;
        this.endNumber = endNumber;
        this.parentIntLog = this.iIntLogDomainService.queryOneById(intLogId);
        if (StringUtils.isNotEmpty((String)selectNumber)) {
            this.selectNumbers = selectNumber.split(",");
        }
        this.resultBo = new BizDataSyncResultBo();
    }

    @Override
    public BizDataSyncResultBo syncBiz() {
        LOG.info(ResManager.loadKDString((String)"HRDI\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u5206\u9875\u5904\u7406\uff0c midTableNumber = {}, bizEntityNumber={}, batchNumber= {}, count={}, ", (String)"BizSyncDomainServiceImpl1", (String)"hdtc-hrdi-business", (Object[])new Object[0]), new Object[]{this.midTableNumber, this.bizEntityNumber, this.batchNumber, this.getCount()});
        new BizDataSyncHandleBo(this).doRetrySync();
        this.resultBo.setSuccessCount(this.getCount() - this.resultBo.getFailCount());
        return this.resultBo;
    }

    @Override
    public QFilter buildQFilter() {
        QFilter isExceptionFilter = new QFilter("is_exception", "=", (Object)Boolean.TRUE);
        QFilter intStatusFilter = new QFilter("hrdiintstatus", "in", Arrays.asList("1", "0"));
        isExceptionFilter.and(intStatusFilter);
        if (StringUtils.isNotEmpty((String)this.batchNumber)) {
            QFilter batchFilter = new QFilter("hrdibatchnumber", "=", (Object)this.batchNumber);
            isExceptionFilter.and(batchFilter);
        }
        if (ArrayUtils.isNotEmpty((Object[])this.selectNumbers)) {
            QFilter numberFilter = new QFilter("hrdinumber", "in", (Object)this.selectNumbers);
            isExceptionFilter.and(numberFilter);
        } else {
            QFilter startNumberFilter = new QFilter("hrdinumber", ">=", (Object)this.startNumber);
            isExceptionFilter.and(startNumberFilter);
            QFilter numberFilter = new QFilter("hrdinumber", "<=", (Object)this.endNumber);
            isExceptionFilter.and(numberFilter);
        }
        return isExceptionFilter;
    }
}

