/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo.validate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.IMidTableDataValidator;
import kd.hdtc.hrdi.business.domain.intgovern.IIntEntityCategoryDomainService;
import kd.hdtc.hrdi.common.adaptor.enums.IntSceneEnum;
import kd.hdtc.hrdi.common.enums.BizCategoryEnum;

public class DeleteSceneValidator
implements IMidTableDataValidator {
    private final IIntSceneRuleDomainService sceneRuleDomainService = ServiceFactory.getService(IIntSceneRuleDomainService.class);
    private final IIntEntityCategoryDomainService domainService = ServiceFactory.getService(IIntEntityCategoryDomainService.class);
    private final String DELETE_SCENE_ERROR = ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u4e0d\u652f\u6301\u5220\u9664\u573a\u666f\u3002", (String)"DeleteSceneValidator_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);

    @Override
    public Map<Long, String> validate(Map<DynamicObject, List<DynamicObject>> dynMap) {
        String bizNumber = dynMap.keySet().iterator().next().getDataEntityType().getName();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        BizCategoryEnum bizCategoryEnum = this.domainService.getCategoryByEntityNumber(bizNumber);
        if (StringUtils.equals((String)BizCategoryEnum.PERSON_ATTACHED.getCode(), (String)bizCategoryEnum.getCode())) {
            return resultMap;
        }
        boolean deleteScene = this.isDeleteScene(bizNumber);
        if (!deleteScene) {
            dynMap.forEach((bizDyn, midDynList) -> midDynList.forEach(midDyn -> {
                if (midDyn.getBoolean("is_delete")) {
                    resultMap.put(midDyn.getLong("id"), this.DELETE_SCENE_ERROR);
                }
            }));
        }
        return resultMap;
    }

    private boolean isDeleteScene(String bizNumber) {
        DynamicObject enabledSceneRule = this.sceneRuleDomainService.getEnabledSceneRule(bizNumber);
        if (enabledSceneRule != null) {
            DynamicObjectCollection ruleEntry = enabledSceneRule.getDynamicObjectCollection("ruleentry");
            for (DynamicObject rule : ruleEntry) {
                if (!IntSceneEnum.DELETE.getSceneType().equals(rule.getString("scenetype"))) continue;
                return true;
            }
        }
        return false;
    }
}

