/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo.validate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.IIntSceneRuleDomainService;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.IMidTableDataValidator;
import kd.hdtc.hrdi.business.domain.middle.IMidTableConfigDomainService;
import kd.hdtc.hrdi.common.pojo.MidTableConfig;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;

public class HisEntityValidator
implements IMidTableDataValidator {
    private final IMidTableConfigDomainService configDomainService = ServiceFactory.getService(IMidTableConfigDomainService.class);
    private final IIntSceneRuleDomainService sceneRuleDomainService = ServiceFactory.getService(IIntSceneRuleDomainService.class);
    private final String HIS_ENTITY_VALUE_ERROR = ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u4e3aHR\u65f6\u5e8f\u5386\u53f2\u6a21\u578b\u5b9e\u4f53\uff0c\u5fc5\u987b\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"HisEntityValidator_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);
    private final String HIS_ENTITY_INTFIELD_ERROR = ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u4e3aHR\u65f6\u5e8f\u5386\u53f2\u6a21\u578b\u5b9e\u4f53\uff0c\u751f\u6548\u65e5\u671f\u9700\u8981\u8bbe\u7f6e\u4e3a\u96c6\u6210\u5b57\u6bb5\u3002", (String)"HisEntityValidator_1", (String)"hdtc-hrdi-business", (Object[])new Object[0]);

    @Override
    public Map<Long, String> validate(Map<DynamicObject, List<DynamicObject>> dynMap) {
        return this.validateBsed(dynMap);
    }

    private Map<Long, String> validateBsed(Map<DynamicObject, List<DynamicObject>> dynMap) {
        IDataEntityType bizEntityType = dynMap.keySet().iterator().next().getDataEntityType();
        String entityNumber = bizEntityType.getName();
        if (!this.isHisEntity(entityNumber)) {
            return null;
        }
        if (!StringUtils.equals((String)"1", (String)this.getWriteType(entityNumber))) {
            return null;
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        boolean bsedIntField = this.isBsedIntField(entityNumber);
        dynMap.forEach((bizDyn, midDynList) -> midDynList.forEach(midDyn -> {
            if (midDyn.getBoolean("is_delete")) {
                return;
            }
            if (!bsedIntField) {
                resultMap.put(midDyn.getLong("id"), this.HIS_ENTITY_INTFIELD_ERROR);
            } else if (midDyn.get("bsed") == null) {
                resultMap.put(midDyn.getLong("id"), this.HIS_ENTITY_VALUE_ERROR);
            }
        }));
        return resultMap;
    }

    private boolean isHisEntity(String entityNumber) {
        String entityTpl = HisModelController.getInstance().entityInhRelation(entityNumber);
        return EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityTpl);
    }

    private boolean isBsedIntField(String entityNumber) {
        Set<String> intFieldSet = this.getIntFields(entityNumber);
        return intFieldSet.contains("bsed");
    }

    private Set<String> getIntFields(String entityNumber) {
        MidTableConfig midTableConfig = this.configDomainService.getMidTableConfigByBizNumber(entityNumber);
        HashSet<String> intFieldSet = new HashSet<String>(16);
        midTableConfig.getFieldConfigList().forEach(field -> {
            if (field.isIntField()) {
                intFieldSet.add(field.getEntityNumber());
            }
        });
        return intFieldSet;
    }

    private String getWriteType(String entityNumber) {
        DynamicObject sceneRule = this.sceneRuleDomainService.getEnabledSceneRule(entityNumber);
        if (sceneRule == null) {
            return "";
        }
        return sceneRule.getString("writetype");
    }
}

