/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo.validate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdi.business.domain.adaptor.bo.BizDataSyncDataMappingBo;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.BaseDataExistsValidator;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.DefaultDataValidator;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.DeleteSceneValidator;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.HisEntityValidator;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.IMidTableDataValidator;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.IntRelationValidator;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.SourceSysExistsValidator;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.hdtc.hrdi.adaptor.extend.IMidTableDataExtendValidator;

public class MidTableDataValidateHandle {
    private final List<IMidTableDataValidator> validatorList = ImmutableList.of((Object)new BaseDataExistsValidator(), (Object)new SourceSysExistsValidator(), (Object)new DeleteSceneValidator(), (Object)new IntRelationValidator(), (Object)new HisEntityValidator());

    public Map<Long, String> doValidate(List<BizDataSyncDataMappingBo> bizDataSyncDataMappingBoList) {
        HashMap bizDataMidDataMap = Maps.newHashMapWithExpectedSize((int)bizDataSyncDataMappingBoList.size());
        bizDataSyncDataMappingBoList.forEach(bizDataSyncDataMappingBo -> bizDataMidDataMap.put(bizDataSyncDataMappingBo.getBizDynamicObject(), bizDataSyncDataMappingBo.getMidDynamicObjectList()));
        HashMap<Long, String> errorInfoMap = new HashMap<Long, String>(16);
        this.validatorList.forEach(iMidTableDataValidator -> {
            Map<Long, String> resultMap = iMidTableDataValidator.validate(bizDataMidDataMap);
            if (CollectionUtils.isNotEmpty(resultMap)) {
                this.resultHandle(resultMap, errorInfoMap);
            }
        });
        this.validateExtHandle(bizDataMidDataMap, errorInfoMap);
        return errorInfoMap;
    }

    private void validateExtHandle(Map<DynamicObject, List<DynamicObject>> bizDataMidDataMap, Map<Long, String> errorInfoMap) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)new DefaultDataValidator(), IMidTableDataExtendValidator.class, (String)"kd.sdk.hdtc.hrdi.adaptor.extend.IMidTableDataExtendValidator", null);
        ArrayList midDynList = new ArrayList(16);
        bizDataMidDataMap.forEach((key, dynList) -> midDynList.addAll(dynList));
        List resultList = pluginProxy.callAfter(validateExt -> validateExt.validate(midDynList));
        resultList.forEach(resultMap -> {
            if (CollectionUtils.isNotEmpty((Map)resultMap)) {
                this.resultHandle((Map<Long, String>)resultMap, errorInfoMap);
            }
        });
    }

    private void resultHandle(Map<Long, String> resultMap, Map<Long, String> errorInfoMap) {
        resultMap.forEach((key, val) -> {
            String errorInfo = (String)errorInfoMap.get(key);
            errorInfo = StringUtils.isNotEmpty((String)errorInfo) ? errorInfo + val : val;
            errorInfoMap.put((Long)key, errorInfo);
        });
    }
}

