/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdi.business.domain.adaptor.bo.validate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hdtc.hrdi.business.common.ServiceFactory;
import kd.hdtc.hrdi.business.domain.adaptor.bo.validate.IMidTableDataValidator;
import kd.hdtc.hrdi.business.domain.intgovern.IIntSourceSysDomainService;

public class SourceSysExistsValidator
implements IMidTableDataValidator {
    private final IIntSourceSysDomainService iIntSourceSysDomainService = ServiceFactory.getService(IIntSourceSysDomainService.class);
    private final String SOURCE_SYS_EXISTS_ERROR = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u6765\u6e90\u7cfb\u7edf\u201d\u7684\u503c\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"SourceSysExistsValidator_0", (String)"hdtc-hrdi-business", (Object[])new Object[0]);

    @Override
    public Map<Long, String> validate(Map<DynamicObject, List<DynamicObject>> dynMap) {
        HashSet<String> sourceSysSet = new HashSet<String>(16);
        dynMap.forEach((bizDyn, midDynList) -> midDynList.forEach(midDyn -> sourceSysSet.add(midDyn.getString("hrdisourcesys"))));
        Map<String, DynamicObject> sourceSystemsMap = this.iIntSourceSysDomainService.querySourceSysByNumberList(sourceSysSet);
        Set<String> sourceSysNumberSet = sourceSystemsMap.keySet();
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        dynMap.forEach((bizDyn, midDynList) -> midDynList.forEach(midDyn -> {
            String sourceSysNumber = midDyn.getString("hrdisourcesys");
            if (!sourceSysNumberSet.contains(sourceSysNumber)) {
                String errorInfo = String.format(Locale.ROOT, this.SOURCE_SYS_EXISTS_ERROR, sourceSysNumber);
                resultMap.put(midDyn.getLong("id"), errorInfo);
            }
        }));
        return resultMap;
    }
}

